/**
 * ShapeChange - processing application schemas for geographic information
 *
 * This file is part of ShapeChange. ShapeChange takes a ISO 19109 
 * Application Schema from a UML model and translates it into a 
 * GML Application Schema or other implementation representations.
 *
 * Additional information about the software can be found at
 * http://shapechange.net/
 *
 * (c) 2002-2020 interactive instruments GmbH, Bonn, Germany
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact:
 * interactive instruments GmbH
 * Trierer Strasse 70-72
 * 53115 Bonn
 * Germany
 */
package de.interactive_instruments.ShapeChange.Target.XmlSchema;

/**
 * @author Johannes Echterhoff (echterhoff at interactive-instruments dot de)
 *
 */
public class XmlSchemaConstants {

    public static final String PARAM_SCH_XLINK_HREF_PREFIX = "schematronXlinkHrefPrefix";
    public static final String PARAM_DEFAULT_CODELIST_VALUE_PATTERN = "defaultCodeListValuePattern";
    public static final String PARAM_SCH_XLINK_HREF_POSTFIX = "schematronXlinkHrefPostfix";
    public static final String PARAM_SUPPRESSED_TYPE_INTERPRETATION = "suppressedTypeInterpretation";
    public static final String PARAM_SCH_FILENAME_TEMPLATE = "schematronFileNameTemplate";
    public static final String PARAM_DEFAULT_VOID_REASON_TYPE = "defaultVoidReasonType";
    public static final String PARAM_SCH_QUERY_BINDING = "schematronQueryBinding";
    public static final String PARAM_SEGMENT_SCH = "segmentSchematron";
    public static final String PARAM_SKIP_XML_SCHEMA_OUTPUT = "skipXmlSchemaOutput";
    public static final String PARAM_REPRESENT_DESCRIPTORS = "representDescriptors";
    public static final String PARAM_DEFAULT_CODELIST_REPRESENTATION = "defaultCodeListRepresentation";
    public static final String PARAM_OKSTRA_KEY_VALUE_PROPERTY_TYPE = "okstraKeyValuePropertyType";
    public static final String PARAM_OKSTRA_KEY_VALUE_BASE_TYPE = "okstraKeyValueBaseType";
    public static final String PARAM_OKSTRA_OBJECT_REF_TYPE = "okstraObjectRefType";
    public static final String PARAM_OKSTRA = "okstra";
    public static final String PARAM_INCLUDE_DOCUMENTATION = "includeDocumentation";
    public static final String PARAM_INCLUDE_DERIVED_PROPERTIES = "includeDerivedProperties";
    public static final String PARAM_SCHEMATRON = "schematron";
    public static final String PARAM_BASIC_TYPE_STYLE = "basicTypeStyle";
    public static final String PARAM_ENUM_STYLE = "enumStyle";
    public static final String PARAM_REALISATION_LIKE_GENERALISATION = "realisationLikeGeneralisation";
}
