/**
 * ShapeChange - processing application schemas for geographic information
 *
 * This file is part of ShapeChange. ShapeChange takes a ISO 19109
 * Application Schema from a UML model and translates it into a
 * GML Application Schema or other implementation representations.
 *
 * Additional information about the software can be found at
 * http://shapechange.net/
 *
 * (c) 2002-2017 interactive instruments GmbH, Bonn, Germany
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact:
 * interactive instruments GmbH
 * Trierer Strasse 70-72
 * 53115 Bonn
 * Germany
 */
package de.interactive_instruments.ShapeChange.Target.SQL.expressions;

/**
 * @author Johannes Echterhoff (echterhoff at interactive-instruments
 *         dot de)
 *
 */
public class InExpression implements Expression {

	private boolean not = false;
	private Expression leftExpression = null;
	private ExpressionList rightExpressionList = null;

	/**
	 * @return the not
	 */
	public boolean isNot() {
		return not;
	}

	/**
	 * @param not
	 *            the not to set
	 */
	public void setNot(boolean not) {
		this.not = not;
	}

	/**
	 * @return the leftExpression
	 */
	public Expression getLeftExpression() {
		return leftExpression;
	}

	/**
	 * @param leftExpression
	 *            the leftExpression to set
	 */
	public void setLeftExpression(Expression leftExpression) {
		this.leftExpression = leftExpression;
	}

	/**
	 * @return the rightExpressionList
	 */
	public ExpressionList getRightExpressionsList() {
		return rightExpressionList;
	}

	/**
	 * @param rightExpressionList
	 *            the rightExpressionList to set
	 */
	public void setRightExpressionsList(ExpressionList rightExpressionList) {
		this.rightExpressionList = rightExpressionList;
	}

	@Override
	public void accept(ExpressionVisitor expressionVisitor) {
		expressionVisitor.visit(this);
	}

	@Override
	public String toString() {
		return leftExpression + " " + (not ? "NOT " : "") + "IN "
				+ rightExpressionList;
	}
}
