/**
 * ShapeChange - processing application schemas for geographic information
 *
 * This file is part of ShapeChange. ShapeChange takes a ISO 19109 
 * Application Schema from a UML model and translates it into a 
 * GML Application Schema or other implementation representations.
 *
 * Additional information about the software can be found at
 * http://shapechange.net/
 *
 * (c) 2002-2020 interactive instruments GmbH, Bonn, Germany
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact:
 * interactive instruments GmbH
 * Trierer Strasse 70-72
 * 53115 Bonn
 * Germany
 */
package de.interactive_instruments.ShapeChange.Target.JSON.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

/**
 * @author Johannes Echterhoff (echterhoff at interactive-instruments dot de)
 *
 */
public class JsonBoolean implements JsonValue {

    private boolean value;

    /**
     * @param value the value of this JSON boolean
     */
    public JsonBoolean(boolean value) {
	super();
	this.value = value;
    }

    /**
     * @param value String value representing the boolean value: if equal to,
     *              ignoring case, 'true', then the boolean value will be
     *              <code>true</code>; otherwise, it will be <code>false</code>
     */
    public JsonBoolean(String value) {
	super();
	this.value = "true".equalsIgnoreCase(value) ? true : false;
    }

    /**
     * @return the value
     */
    public boolean value() {
	return value;
    }

    @Override
    public JsonElement toGson() {
	return new JsonPrimitive(value);
    }

}
