/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.svg;

import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.Size;
import net.arnx.wmf2svg.gdi.svg.SvgBrush;
import net.arnx.wmf2svg.gdi.svg.SvgFont;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.svg.SvgPen;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgDc
implements Cloneable {
    private SvgGdi gdi;
    private int dpi = 1440;
    private int wx = 0;
    private int wy = 0;
    private int ww = 0;
    private int wh = 0;
    private int wox = 0;
    private int woy = 0;
    private double wsx = 1.0;
    private double wsy = 1.0;
    private double mx = 1.0;
    private double my = 1.0;
    private int vx = 0;
    private int vy = 0;
    private int vw = 0;
    private int vh = 0;
    private int vox = 0;
    private int voy = 0;
    private double vsx = 1.0;
    private double vsy = 1.0;
    private int cx = 0;
    private int cy = 0;
    private int cox = 0;
    private int coy = 0;
    private int mapMode = 1;
    private int bkColor = 0xFFFFFF;
    private int bkMode = 2;
    private int textColor = 0;
    private int textSpace = 0;
    private int textAlign = 0;
    private int textDx = 0;
    private int polyFillMode = 1;
    private int relAbsMode = 0;
    private int rop2Mode = 13;
    private int stretchBltMode = 2;
    private long layout = 0L;
    private long mapperFlags = 0L;
    private SvgBrush brush = null;
    private SvgFont font = null;
    private SvgPen pen = null;
    private Element mask = null;

    public SvgDc(SvgGdi gdi) {
        this.gdi = gdi;
    }

    public int getDpi() {
        return this.dpi;
    }

    public void setWindowOrgEx(int x, int y, Point old) {
        if (old != null) {
            old.x = this.wx;
            old.y = this.wy;
        }
        this.wx = x;
        this.wy = y;
    }

    public void setWindowExtEx(int width, int height, Size old) {
        if (old != null) {
            old.width = this.ww;
            old.height = this.wh;
        }
        this.ww = width;
        this.wh = height;
    }

    public void offsetWindowOrgEx(int x, int y, Point old) {
        if (old != null) {
            old.x = this.wox;
            old.y = this.woy;
        }
        this.wox += x;
        this.woy += y;
    }

    public void scaleWindowExtEx(int x, int xd, int y, int yd, Size old) {
        this.wsx = this.wsx * (double)x / (double)xd;
        this.wsy = this.wsy * (double)y / (double)yd;
    }

    public int getWindowX() {
        return this.wx;
    }

    public int getWindowY() {
        return this.wy;
    }

    public int getWindowWidth() {
        return this.ww;
    }

    public int getWindowHeight() {
        return this.wh;
    }

    public void setViewportOrgEx(int x, int y, Point old) {
        if (old != null) {
            old.x = this.vx;
            old.y = this.vy;
        }
        this.vx = x;
        this.vy = y;
    }

    public void setViewportExtEx(int width, int height, Size old) {
        if (old != null) {
            old.width = this.vw;
            old.height = this.vh;
        }
        this.vw = width;
        this.vh = height;
    }

    public void offsetViewportOrgEx(int x, int y, Point old) {
        if (old != null) {
            old.x = this.vox;
            old.y = this.voy;
        }
        this.vox = x;
        this.voy = y;
    }

    public void scaleViewportExtEx(int x, int xd, int y, int yd, Size old) {
        this.vsx = this.vsx * (double)x / (double)xd;
        this.vsy = this.vsy * (double)y / (double)yd;
    }

    public void offsetClipRgn(int x, int y) {
        this.cox = x;
        this.coy = y;
    }

    public int getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(int mode) {
        this.mapMode = mode;
        switch (mode) {
            case 5: {
                this.mx = 0.09;
                this.my = -0.09;
                break;
            }
            case 4: {
                this.mx = 0.9;
                this.my = -0.9;
                break;
            }
            case 3: {
                this.mx = 0.03543307;
                this.my = -0.03543307;
                break;
            }
            case 2: {
                this.mx = 0.3543307;
                this.my = -0.3543307;
                break;
            }
            case 6: {
                this.mx = 0.0625;
                this.my = -0.0625;
                break;
            }
            default: {
                this.mx = 1.0;
                this.my = 1.0;
            }
        }
    }

    public int getCurrentX() {
        return this.cx;
    }

    public int getCurrentY() {
        return this.cy;
    }

    public int getOffsetClipX() {
        return this.cox;
    }

    public int getOffsetClipY() {
        return this.coy;
    }

    public void moveToEx(int x, int y, Point old) {
        if (old != null) {
            old.x = this.cx;
            old.y = this.cy;
        }
        this.cx = x;
        this.cy = y;
    }

    public double toAbsoluteX(double x) {
        return (double)(this.ww >= 0 ? 1 : -1) * (this.mx * x - (double)(this.wx + this.wox)) / this.wsx;
    }

    public double toAbsoluteY(double y) {
        return (double)(this.wh >= 0 ? 1 : -1) * (this.my * y - (double)(this.wy + this.woy)) / this.wsy;
    }

    public double toRelativeX(double x) {
        return (double)(this.ww >= 0 ? 1 : -1) * (this.mx * x) / this.wsx;
    }

    public double toRelativeY(double y) {
        return (double)(this.wh >= 0 ? 1 : -1) * (this.my * y) / this.wsy;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi > 0 ? dpi : 1440;
    }

    public int getBkColor() {
        return this.bkColor;
    }

    public void setBkColor(int color) {
        this.bkColor = color;
    }

    public int getBkMode() {
        return this.bkMode;
    }

    public void setBkMode(int mode) {
        this.bkMode = mode;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public int getPolyFillMode() {
        return this.polyFillMode;
    }

    public void setPolyFillMode(int mode) {
        this.polyFillMode = mode;
    }

    public int getRelAbs() {
        return this.relAbsMode;
    }

    public void setRelAbs(int mode) {
        this.relAbsMode = mode;
    }

    public int getROP2() {
        return this.rop2Mode;
    }

    public void setROP2(int mode) {
        this.rop2Mode = mode;
    }

    public int getStretchBltMode() {
        return this.stretchBltMode;
    }

    public void setStretchBltMode(int mode) {
        this.stretchBltMode = mode;
    }

    public int getTextSpace() {
        return this.textSpace;
    }

    public void setTextSpace(int space) {
        this.textSpace = space;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(int align) {
        this.textAlign = align;
    }

    public int getTextCharacterExtra() {
        return this.textDx;
    }

    public void setTextCharacterExtra(int extra) {
        this.textDx = extra;
    }

    public long getLayout() {
        return this.layout;
    }

    public void setLayout(long layout) {
        this.layout = layout;
    }

    public long getMapperFlags() {
        return this.mapperFlags;
    }

    public void setMapperFlags(long flags) {
        this.mapperFlags = flags;
    }

    public SvgBrush getBrush() {
        return this.brush;
    }

    public void setBrush(SvgBrush brush) {
        this.brush = brush;
    }

    public SvgFont getFont() {
        return this.font;
    }

    public void setFont(SvgFont font) {
        this.font = font;
    }

    public SvgPen getPen() {
        return this.pen;
    }

    public void setPen(SvgPen pen) {
        this.pen = pen;
    }

    public void setMask(Element mask) {
        this.mask = mask;
    }

    public Element getMask() {
        return this.mask;
    }

    public String getRopFilter(long rop) {
        String name = null;
        Document doc = this.gdi.getDocument();
        if (rop == 66L) {
            name = "BLACKNESS_FILTER";
            Element filter = doc.getElementById(name);
            if (filter == null) {
                filter = this.gdi.getDocument().createElement("filter");
                filter.setAttribute("id", name);
                filter.setIdAttribute("id", true);
                Element feColorMatrix = doc.createElement("feColorMatrix");
                feColorMatrix.setAttribute("type", "matrix");
                feColorMatrix.setAttribute("in", "SourceGraphic");
                feColorMatrix.setAttribute("values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0");
                filter.appendChild(feColorMatrix);
                this.gdi.getDefsElement().appendChild(filter);
            }
        } else if (rop == 1114278L) {
            name = "NOTSRCERASE_FILTER";
            Element filter = doc.getElementById(name);
            if (filter == null) {
                filter = this.gdi.getDocument().createElement("filter");
                filter.setAttribute("id", name);
                filter.setIdAttribute("id", true);
                Element feComposite = doc.createElement("feComposite");
                feComposite.setAttribute("in", "SourceGraphic");
                feComposite.setAttribute("in2", "BackgroundImage");
                feComposite.setAttribute("operator", "arithmetic");
                feComposite.setAttribute("k1", "1");
                feComposite.setAttribute("result", "result0");
                filter.appendChild(feComposite);
                Element feColorMatrix = doc.createElement("feColorMatrix");
                feColorMatrix.setAttribute("in", "result0");
                feColorMatrix.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                filter.appendChild(feColorMatrix);
                this.gdi.getDefsElement().appendChild(filter);
            }
        } else if (rop == 0x330008L) {
            name = "NOTSRCCOPY_FILTER";
            Element filter = doc.getElementById(name);
            if (filter == null) {
                filter = this.gdi.getDocument().createElement("filter");
                filter.setAttribute("id", name);
                filter.setIdAttribute("id", true);
                Element feColorMatrix = doc.createElement("feColorMatrix");
                feColorMatrix.setAttribute("type", "matrix");
                feColorMatrix.setAttribute("in", "SourceGraphic");
                feColorMatrix.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                filter.appendChild(feColorMatrix);
                this.gdi.getDefsElement().appendChild(filter);
            }
        } else if (rop == 4457256L) {
            name = "SRCERASE_FILTER";
            Element filter = doc.getElementById(name);
            if (filter == null) {
                filter = this.gdi.getDocument().createElement("filter");
                filter.setAttribute("id", name);
                filter.setIdAttribute("id", true);
                Element feColorMatrix = doc.createElement("feColorMatrix");
                feColorMatrix.setAttribute("type", "matrix");
                feColorMatrix.setAttribute("in", "BackgroundImage");
                feColorMatrix.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                feColorMatrix.setAttribute("result", "result0");
                filter.appendChild(feColorMatrix);
                Element feComposite = doc.createElement("feComposite");
                feComposite.setAttribute("in", "SourceGraphic");
                feComposite.setAttribute("in2", "result0");
                feComposite.setAttribute("operator", "arithmetic");
                feComposite.setAttribute("k2", "1");
                feComposite.setAttribute("k3", "1");
                filter.appendChild(feComposite);
                this.gdi.getDefsElement().appendChild(filter);
            }
        } else if (rop != 5898313L && rop != 0x660046L) {
            if (rop == 0x550009L) {
                name = "DSTINVERT_FILTER";
                Element filter = doc.getElementById(name);
                if (filter == null) {
                    filter = this.gdi.getDocument().createElement("filter");
                    filter.setAttribute("id", name);
                    filter.setIdAttribute("id", true);
                    Element feColorMatrix = doc.createElement("feColorMatrix");
                    feColorMatrix.setAttribute("type", "matrix");
                    feColorMatrix.setAttribute("in", "BackgroundImage");
                    feColorMatrix.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                    filter.appendChild(feColorMatrix);
                    this.gdi.getDefsElement().appendChild(filter);
                }
            } else if (rop == 8913094L) {
                name = "SRCAND_FILTER";
                Element filter = doc.getElementById(name);
                if (filter == null) {
                    filter = this.gdi.getDocument().createElement("filter");
                    filter.setAttribute("id", name);
                    filter.setIdAttribute("id", true);
                    Element feComposite = doc.createElement("feComposite");
                    feComposite.setAttribute("in", "SourceGraphic");
                    feComposite.setAttribute("in2", "BackgroundImage");
                    feComposite.setAttribute("operator", "arithmetic");
                    feComposite.setAttribute("k1", "1");
                    filter.appendChild(feComposite);
                    this.gdi.getDefsElement().appendChild(filter);
                }
            } else if (rop == 12255782L) {
                name = "MERGEPAINT_FILTER";
                Element filter = doc.getElementById(name);
                if (filter == null) {
                    filter = this.gdi.getDocument().createElement("filter");
                    filter.setAttribute("id", name);
                    filter.setIdAttribute("id", true);
                    Element feColorMatrix = doc.createElement("feColorMatrix");
                    feColorMatrix.setAttribute("type", "matrix");
                    feColorMatrix.setAttribute("in", "SourceGraphic");
                    feColorMatrix.setAttribute("values", "-1 0 0 0 1 0 -1 0 0 1 0 0 -1 0 1 0 0 0 1 0");
                    feColorMatrix.setAttribute("result", "result0");
                    filter.appendChild(feColorMatrix);
                    Element feComposite = doc.createElement("feComposite");
                    feComposite.setAttribute("in", "result0");
                    feComposite.setAttribute("in2", "BackgroundImage");
                    feComposite.setAttribute("operator", "arithmetic");
                    feComposite.setAttribute("k1", "1");
                    filter.appendChild(feComposite);
                    this.gdi.getDefsElement().appendChild(filter);
                }
            } else if (rop != 0xC000CAL) {
                Element filter;
                if (rop == 15597702L) {
                    name = "SRCPAINT_FILTER";
                    Element filter2 = doc.getElementById(name);
                    if (filter2 == null) {
                        filter2 = this.gdi.getDocument().createElement("filter");
                        filter2.setAttribute("id", name);
                        filter2.setIdAttribute("id", true);
                        Element feComposite = doc.createElement("feComposite");
                        feComposite.setAttribute("in", "SourceGraphic");
                        feComposite.setAttribute("in2", "BackgroundImage");
                        feComposite.setAttribute("operator", "arithmetic");
                        feComposite.setAttribute("k2", "1");
                        feComposite.setAttribute("k3", "1");
                        filter2.appendChild(feComposite);
                        this.gdi.getDefsElement().appendChild(filter2);
                    }
                } else if (rop != 15728673L && rop != 16452105L && rop == 16711778L && (filter = doc.getElementById(name = "WHITENESS_FILTER")) == null) {
                    filter = this.gdi.getDocument().createElement("filter");
                    filter.setAttribute("id", name);
                    filter.setIdAttribute("id", true);
                    Element feColorMatrix = doc.createElement("feColorMatrix");
                    feColorMatrix.setAttribute("type", "matrix");
                    feColorMatrix.setAttribute("in", "SourceGraphic");
                    feColorMatrix.setAttribute("values", "1 0 0 0 1 0 1 0 0 1 0 0 1 0 1 0 0 0 1 0");
                    filter.appendChild(feColorMatrix);
                    this.gdi.getDefsElement().appendChild(filter);
                }
            }
        }
        if (name != null) {
            if (!doc.getDocumentElement().hasAttribute("enable-background")) {
                doc.getDocumentElement().setAttribute("enable-background", "new");
            }
            return "url(#" + name + ")";
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public String toString() {
        return "SvgDc [gdi=" + this.gdi + ", dpi=" + this.dpi + ", wx=" + this.wx + ", wy=" + this.wy + ", ww=" + this.ww + ", wh=" + this.wh + ", wox=" + this.wox + ", woy=" + this.woy + ", wsx=" + this.wsx + ", wsy=" + this.wsy + ", mx=" + this.mx + ", my=" + this.my + ", vx=" + this.vx + ", vy=" + this.vy + ", vw=" + this.vw + ", vh=" + this.vh + ", vox=" + this.vox + ", voy=" + this.voy + ", vsx=" + this.vsx + ", vsy=" + this.vsy + ", cx=" + this.cx + ", cy=" + this.cy + ", mapMode=" + this.mapMode + ", bkColor=" + this.bkColor + ", bkMode=" + this.bkMode + ", textColor=" + this.textColor + ", textSpace=" + this.textSpace + ", textAlign=" + this.textAlign + ", textDx=" + this.textDx + ", polyFillMode=" + this.polyFillMode + ", relAbsMode=" + this.relAbsMode + ", rop2Mode=" + this.rop2Mode + ", stretchBltMode=" + this.stretchBltMode + ", brush=" + this.brush + ", font=" + this.font + ", pen=" + this.pen + "]";
    }
}

