/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.sys.DatasetControl;

public class DatasetControlReadOnly
implements DatasetControl {
    private final AtomicLong readCounter = new AtomicLong(0L);

    @Override
    public void startRead() {
        this.readCounter.getAndIncrement();
    }

    @Override
    public void finishRead() {
        this.readCounter.decrementAndGet();
    }

    @Override
    public void startUpdate() {
        throw new TDBException("Read-only");
    }

    @Override
    public void finishUpdate() {
        throw new TDBException("Read-only");
    }

    @Override
    public <T> Iterator<T> iteratorControl(Iterator<T> iter) {
        return iter;
    }
}

