/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.lib;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.lib.ColumnMap;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;

public class TupleLib {
    public static Iterator<Tuple<Node>> convertToNodes(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.tupleNodes(nodeTable, (Tuple<NodeId>)item));
    }

    public static Iterator<Tuple<NodeId>> convertToNodeId(NodeTable nodeTable, Iterator<Tuple<Node>> iter) {
        return Iter.map(iter, item -> TupleLib.tupleNodeIds(nodeTable, (Tuple<Node>)item));
    }

    public static Iterator<Triple> convertToTriples(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.triple(nodeTable, (Tuple<NodeId>)item));
    }

    public static Iterator<Quad> convertToQuads(NodeTable nodeTable, Iterator<Tuple<NodeId>> iter) {
        return Iter.map(iter, item -> TupleLib.quad(nodeTable, (Tuple<NodeId>)item));
    }

    public static Tuple<Node> tupleNodes(NodeTable nodeTable, Tuple<NodeId> ids) {
        int N = ids.len();
        Object[] n = new Node[N];
        for (int i = 0; i < N; ++i) {
            n[i] = nodeTable.getNodeForNodeId((NodeId)ids.get(i));
        }
        return TupleFactory.asTuple((Object[])n);
    }

    public static Tuple<NodeId> tupleNodeIds(NodeTable nodeTable, Tuple<Node> nodes) {
        int N = nodes.len();
        Object[] n = new NodeId[N];
        for (int i = 0; i < N; ++i) {
            n[i] = nodeTable.getNodeIdForNode((Node)nodes.get(i));
        }
        return TupleFactory.asTuple((Object[])n);
    }

    private static Triple triple(NodeTable nodeTable, Tuple<NodeId> tuple) {
        if (tuple.len() != 3) {
            throw new TDBException("Tuple is not of length 3: " + tuple);
        }
        return TupleLib.triple(nodeTable, (NodeId)tuple.get(0), (NodeId)tuple.get(1), (NodeId)tuple.get(2));
    }

    private static Triple triple(NodeTable nodeTable, NodeId s, NodeId p, NodeId o) {
        if (!NodeId.isConcrete(s)) {
            throw new InternalErrorException("Invalid id for subject: " + TupleLib.fmt(s, p, o));
        }
        if (!NodeId.isConcrete(p)) {
            throw new InternalErrorException("Invalid id for predicate: " + TupleLib.fmt(s, p, o));
        }
        if (!NodeId.isConcrete(o)) {
            throw new InternalErrorException("Invalid id for object: " + TupleLib.fmt(s, p, o));
        }
        Node sNode = nodeTable.getNodeForNodeId(s);
        if (sNode == null) {
            throw new InternalErrorException("Invalid id node for subject (null node): " + TupleLib.fmt(s, p, o));
        }
        Node pNode = nodeTable.getNodeForNodeId(p);
        if (pNode == null) {
            throw new InternalErrorException("Invalid id node for predicate (null node): " + TupleLib.fmt(s, p, o));
        }
        Node oNode = nodeTable.getNodeForNodeId(o);
        if (oNode == null) {
            throw new InternalErrorException("Invalid id node for object (null node): " + TupleLib.fmt(s, p, o));
        }
        return new Triple(sNode, pNode, oNode);
    }

    private static String fmt(NodeId s, NodeId p, NodeId o) {
        return "(" + s + ", " + p + ", " + o + ")";
    }

    private static Quad quad(NodeTable nodeTable, Tuple<NodeId> tuple) {
        if (tuple.len() != 4) {
            throw new TDBException("Tuple is not of length 4: " + tuple);
        }
        return TupleLib.quad(nodeTable, (NodeId)tuple.get(0), (NodeId)tuple.get(1), (NodeId)tuple.get(2), (NodeId)tuple.get(3));
    }

    private static Quad quad(NodeTable nodeTable, NodeId g, NodeId s, NodeId p, NodeId o) {
        Node gNode = nodeTable.getNodeForNodeId(g);
        Node sNode = nodeTable.getNodeForNodeId(s);
        Node pNode = nodeTable.getNodeForNodeId(p);
        Node oNode = nodeTable.getNodeForNodeId(o);
        return new Quad(gNode, sNode, pNode, oNode);
    }

    public static Tuple<NodeId> tuple(Record r, ColumnMap cMap) {
        int N = r.getKey().length / 8;
        Object[] nodeIds = new NodeId[N];
        for (int i = 0; i < N; ++i) {
            NodeId id = NodeId.create(r.getKey(), i * 8);
            int j = i;
            if (cMap != null) {
                j = cMap.fetchSlotIdx(i);
            }
            nodeIds[j] = id;
        }
        return TupleFactory.asTuple((Object[])nodeIds);
    }

    public static Record record(RecordFactory factory, Tuple<NodeId> tuple, ColumnMap cMap) {
        byte[] b = new byte[tuple.len() * 8];
        for (int i = 0; i < tuple.len(); ++i) {
            int j = cMap.mapSlotIdx(i);
            Bytes.setLong((long)((NodeId)tuple.get(i)).getId(), (byte[])b, (int)(j * 8));
        }
        return factory.create(b);
    }
}

