/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.Polygon;
import mil.nga.sf.Surface;
import mil.nga.sf.util.GeometryUtils;

public class PolyhedralSurface
extends Surface {
    private static final long serialVersionUID = 1L;
    private List<Polygon> polygons = new ArrayList<Polygon>();

    public PolyhedralSurface() {
        this(false, false);
    }

    public PolyhedralSurface(boolean hasZ, boolean hasM) {
        super(GeometryType.POLYHEDRALSURFACE, hasZ, hasM);
    }

    public PolyhedralSurface(List<Polygon> polygons) {
        this(GeometryUtils.hasZ(polygons), GeometryUtils.hasM(polygons));
        this.setPolygons(polygons);
    }

    public PolyhedralSurface(Polygon polygon) {
        this(polygon.hasZ(), polygon.hasM());
        this.addPolygon(polygon);
    }

    public PolyhedralSurface(PolyhedralSurface polyhedralSurface) {
        this(polyhedralSurface.hasZ(), polyhedralSurface.hasM());
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            this.addPolygon((Polygon)polygon.copy());
        }
    }

    protected PolyhedralSurface(GeometryType type, boolean hasZ, boolean hasM) {
        super(type, hasZ, hasM);
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    public List<Polygon> getPatches() {
        return this.getPolygons();
    }

    public void setPolygons(List<Polygon> polygons) {
        this.polygons = polygons;
    }

    public void setPatches(List<Polygon> patches) {
        this.setPolygons(patches);
    }

    public void addPolygon(Polygon polygon) {
        this.polygons.add(polygon);
    }

    public void addPatch(Polygon patch) {
        this.addPolygon(patch);
    }

    public void addPolygons(List<Polygon> polygons) {
        this.polygons.addAll(polygons);
    }

    public void addPatches(List<Polygon> patches) {
        this.addPolygons(patches);
    }

    public int numPolygons() {
        return this.polygons.size();
    }

    public int numPatches() {
        return this.numPolygons();
    }

    public Polygon getPolygon(int n) {
        return this.polygons.get(n);
    }

    public Polygon getPatch(int n) {
        return this.getPolygon(n);
    }

    @Override
    public Geometry copy() {
        return new PolyhedralSurface(this);
    }

    @Override
    public boolean isEmpty() {
        return this.polygons.isEmpty();
    }

    @Override
    public boolean isSimple() {
        throw new UnsupportedOperationException("Is Simple not implemented for " + this.getClass().getSimpleName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.polygons == null ? 0 : this.polygons.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolyhedralSurface other = (PolyhedralSurface)obj;
        return !(this.polygons == null ? other.polygons != null : !this.polygons.equals(other.polygons));
    }
}

