/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf;

import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;

public class Point
extends Geometry {
    private static final long serialVersionUID = 1L;
    private double x;
    private double y;
    private Double z;
    private Double m;

    public Point() {
        this(0.0, 0.0);
    }

    public Point(double x, double y) {
        this(false, false, x, y);
    }

    public Point(double x, double y, Double z) {
        this(x, y, z, null);
    }

    public Point(double x, double y, Double z, Double m) {
        super(GeometryType.POINT, z != null, m != null);
        this.x = x;
        this.y = y;
        this.z = z;
        this.m = m;
    }

    public Point(boolean hasZ, boolean hasM, double x, double y) {
        super(GeometryType.POINT, hasZ, hasM);
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        this(point.hasZ(), point.hasM(), point.getX(), point.getY());
        this.setZ(point.getZ());
        this.setM(point.getM());
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Double getZ() {
        return this.z;
    }

    public void setZ(Double z) {
        this.z = z;
    }

    public Double getM() {
        return this.m;
    }

    public void setM(Double m) {
        this.m = m;
    }

    @Override
    public Geometry copy() {
        return new Point(this);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m == null ? 0 : this.m.hashCode());
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.z == null ? 0 : this.z.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.m == null ? other.m != null : !this.m.equals(other.m)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return !(this.z == null ? other.z != null : !this.z.equals(other.z));
    }
}

