/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import java.io.Serializable;
import java.text.FieldPosition;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.datum.AxisOrder;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.datum.PrimeMeridian;
import org.locationtech.proj4j.units.AngleFormat;
import org.locationtech.proj4j.units.Unit;
import org.locationtech.proj4j.units.Units;
import org.locationtech.proj4j.util.ProjectionMath;

public abstract class Projection
implements Cloneable,
Serializable {
    protected double minLatitude = -1.5707963267948966;
    protected double minLongitude = -Math.PI;
    protected double maxLatitude = 1.5707963267948966;
    protected double maxLongitude = Math.PI;
    protected double projectionLatitude = 0.0;
    protected double projectionLongitude = 0.0;
    protected double projectionLatitude1 = 0.0;
    protected double projectionLatitude2 = 0.0;
    protected double alpha = Double.NaN;
    protected double lonc = Double.NaN;
    protected double scaleFactor = 1.0;
    protected double falseEasting = 0.0;
    protected double falseNorthing = 0.0;
    protected double trueScaleLatitude = 0.0;
    protected double a = 0.0;
    protected double e = 0.0;
    protected double es = 0.0;
    protected double one_es = 0.0;
    protected double rone_es = 0.0;
    protected Ellipsoid ellipsoid;
    protected boolean spherical;
    protected boolean geocentric;
    protected String name = null;
    protected double fromMetres = 1.0;
    protected double totalScale = 0.0;
    private double totalFalseEasting = 0.0;
    private double totalFalseNorthing = 0.0;
    protected Unit unit = null;
    private PrimeMeridian primeMeridian = PrimeMeridian.forName("greenwich");
    private AxisOrder axes = AxisOrder.ENU;
    protected static final double EPS10 = 1.0E-10;
    protected static final double RTD = 57.29577951308232;
    protected static final double DTR = Math.PI / 180;

    protected Projection() {
        this.setEllipsoid(Ellipsoid.SPHERE);
    }

    public Object clone() {
        try {
            Projection e = (Projection)super.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public ProjCoordinate project(ProjCoordinate src, ProjCoordinate dst) {
        double x = src.x * (Math.PI / 180);
        if (this.projectionLongitude != 0.0) {
            x = ProjectionMath.normalizeLongitude(x - this.projectionLongitude);
        }
        return this.projectRadians(x, src.y * (Math.PI / 180), dst);
    }

    public ProjCoordinate projectRadians(ProjCoordinate src, ProjCoordinate dst) {
        double x = src.x;
        if (this.projectionLongitude != 0.0) {
            x = ProjectionMath.normalizeLongitude(x - this.projectionLongitude);
        }
        return this.projectRadians(x, src.y, dst);
    }

    private ProjCoordinate projectRadians(double x, double y, ProjCoordinate dst) {
        this.project(x, y, dst);
        if (this.unit != null && this.unit.equals(Units.DEGREES)) {
            dst.x *= 57.29577951308232;
            dst.y *= 57.29577951308232;
        } else {
            dst.x = this.totalScale * dst.x + this.totalFalseEasting;
            dst.y = this.totalScale * dst.y + this.totalFalseNorthing;
        }
        return dst;
    }

    protected ProjCoordinate project(double x, double y, ProjCoordinate dst) {
        dst.x = x;
        dst.y = y;
        return dst;
    }

    public ProjCoordinate inverseProject(ProjCoordinate src, ProjCoordinate dst) {
        this.inverseProjectRadians(src, dst);
        dst.x *= 57.29577951308232;
        dst.y *= 57.29577951308232;
        return dst;
    }

    public ProjCoordinate inverseProjectRadians(ProjCoordinate src, ProjCoordinate dst) {
        double y;
        double x;
        if (this.unit != null && this.unit.equals(Units.DEGREES)) {
            x = src.x * (Math.PI / 180);
            y = src.y * (Math.PI / 180);
        } else {
            x = (src.x - this.totalFalseEasting) / this.totalScale;
            y = (src.y - this.totalFalseNorthing) / this.totalScale;
        }
        this.projectInverse(x, y, dst);
        if (dst.x < -Math.PI) {
            dst.x = -Math.PI;
        } else if (dst.x > Math.PI) {
            dst.x = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            dst.x = ProjectionMath.normalizeLongitude(dst.x + this.projectionLongitude);
        }
        return dst;
    }

    protected ProjCoordinate projectInverse(double x, double y, ProjCoordinate dst) {
        dst.x = x;
        dst.y = y;
        return dst;
    }

    public boolean isConformal() {
        return false;
    }

    public boolean isEqualArea() {
        return false;
    }

    public boolean hasInverse() {
        return false;
    }

    public boolean isRectilinear() {
        return false;
    }

    public boolean parallelsAreParallel() {
        return this.isRectilinear();
    }

    public boolean inside(double x, double y) {
        return this.minLongitude <= (x = (double)Projection.normalizeLongitude((float)(x * (Math.PI / 180) - this.projectionLongitude))) && x <= this.maxLongitude && this.minLatitude <= y && y <= this.maxLatitude;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public String getPROJ4Description() {
        AngleFormat format = new AngleFormat("DdM", false);
        StringBuffer sb = new StringBuffer();
        sb.append("+proj=" + this.getName() + " +a=" + this.a);
        if (this.es != 0.0) {
            sb.append(" +es=" + this.es);
        }
        sb.append(" +lon_0=");
        format.format(this.projectionLongitude, sb, (FieldPosition)null);
        sb.append(" +lat_0=");
        format.format(this.projectionLatitude, sb, (FieldPosition)null);
        if (this.falseEasting != 1.0) {
            sb.append(" +x_0=" + this.falseEasting);
        }
        if (this.falseNorthing != 1.0) {
            sb.append(" +y_0=" + this.falseNorthing);
        }
        if (this.scaleFactor != 1.0) {
            sb.append(" +k=" + this.scaleFactor);
        }
        if (this.fromMetres != 1.0) {
            sb.append(" +fr_meters=" + this.fromMetres);
        }
        return sb.toString();
    }

    public String toString() {
        return "None";
    }

    public void setAxisOrder(String axes) {
        this.axes = AxisOrder.fromString(axes);
    }

    public AxisOrder getAxisOrder() {
        return this.axes;
    }

    public void setPrimeMeridian(String primeMeridian) {
        this.primeMeridian = PrimeMeridian.forName(primeMeridian);
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public void setMinLatitude(double minLatitude) {
        this.minLatitude = minLatitude;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMaxLatitude(double maxLatitude) {
        this.maxLatitude = maxLatitude;
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public double getMaxLatitudeDegrees() {
        return this.maxLatitude * 57.29577951308232;
    }

    public double getMinLatitudeDegrees() {
        return this.minLatitude * 57.29577951308232;
    }

    public void setMinLongitude(double minLongitude) {
        this.minLongitude = minLongitude;
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitudeDegrees(double minLongitude) {
        this.minLongitude = Math.PI / 180 * minLongitude;
    }

    public double getMinLongitudeDegrees() {
        return this.minLongitude * 57.29577951308232;
    }

    public void setMaxLongitude(double maxLongitude) {
        this.maxLongitude = maxLongitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitudeDegrees(double maxLongitude) {
        this.maxLongitude = Math.PI / 180 * maxLongitude;
    }

    public double getMaxLongitudeDegrees() {
        return this.maxLongitude * 57.29577951308232;
    }

    public void setProjectionLatitude(double projectionLatitude) {
        this.projectionLatitude = projectionLatitude;
    }

    public double getProjectionLatitude() {
        return this.projectionLatitude;
    }

    public void setProjectionLatitudeDegrees(double projectionLatitude) {
        this.projectionLatitude = Math.PI / 180 * projectionLatitude;
    }

    public double getProjectionLatitudeDegrees() {
        return this.projectionLatitude * 57.29577951308232;
    }

    public void setProjectionLongitude(double projectionLongitude) {
        this.projectionLongitude = Projection.normalizeLongitudeRadians(projectionLongitude);
    }

    public double getProjectionLongitude() {
        return this.projectionLongitude;
    }

    public void setProjectionLongitudeDegrees(double projectionLongitude) {
        this.projectionLongitude = Math.PI / 180 * projectionLongitude;
    }

    public double getProjectionLongitudeDegrees() {
        return this.projectionLongitude * 57.29577951308232;
    }

    public void setTrueScaleLatitude(double trueScaleLatitude) {
        this.trueScaleLatitude = trueScaleLatitude;
    }

    public double getTrueScaleLatitude() {
        return this.trueScaleLatitude;
    }

    public void setTrueScaleLatitudeDegrees(double trueScaleLatitude) {
        this.trueScaleLatitude = Math.PI / 180 * trueScaleLatitude;
    }

    public double getTrueScaleLatitudeDegrees() {
        return this.trueScaleLatitude * 57.29577951308232;
    }

    public void setProjectionLatitude1(double projectionLatitude1) {
        this.projectionLatitude1 = projectionLatitude1;
    }

    public double getProjectionLatitude1() {
        return this.projectionLatitude1;
    }

    public void setProjectionLatitude1Degrees(double projectionLatitude1) {
        this.projectionLatitude1 = Math.PI / 180 * projectionLatitude1;
    }

    public double getProjectionLatitude1Degrees() {
        return this.projectionLatitude1 * 57.29577951308232;
    }

    public void setProjectionLatitude2(double projectionLatitude2) {
        this.projectionLatitude2 = projectionLatitude2;
    }

    public double getProjectionLatitude2() {
        return this.projectionLatitude2;
    }

    public void setProjectionLatitude2Degrees(double projectionLatitude2) {
        this.projectionLatitude2 = Math.PI / 180 * projectionLatitude2;
    }

    public double getProjectionLatitude2Degrees() {
        return this.projectionLatitude2 * 57.29577951308232;
    }

    public void setAlphaDegrees(double alpha) {
        this.alpha = Math.PI / 180 * alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setLonCDegrees(double lonc) {
        this.lonc = Math.PI / 180 * lonc;
    }

    public double getLonC() {
        return this.lonc;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setSouthernHemisphere(boolean isSouth) {
        throw new NoSuchElementException();
    }

    public boolean getSouthernHemisphere() {
        throw new NoSuchElementException();
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getEquatorRadius() {
        return this.a;
    }

    public void setFromMetres(double fromMetres) {
        this.fromMetres = fromMetres;
    }

    public double getFromMetres() {
        return this.fromMetres;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.a = ellipsoid.equatorRadius;
        this.e = ellipsoid.eccentricity;
        this.es = ellipsoid.eccentricity2;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public int getEPSGCode() {
        return 0;
    }

    public void setUnits(Unit unit) {
        this.unit = unit;
    }

    public Unit getUnits() {
        return this.unit != null ? this.unit : Units.METRES;
    }

    public double getHeightOfOrbit() {
        throw new NoSuchElementException();
    }

    public void setHeightOfOrbit(double h) {
        throw new NoSuchElementException();
    }

    public void initialize() {
        this.spherical = this.e == 0.0;
        this.one_es = 1.0 - this.es;
        this.rone_es = 1.0 / this.one_es;
        this.totalScale = this.a * this.fromMetres;
        this.totalFalseEasting = this.falseEasting * this.fromMetres;
        this.totalFalseNorthing = this.falseNorthing * this.fromMetres;
    }

    public static float normalizeLongitude(float angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new InvalidValueException("Infinite or NaN longitude");
        }
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static double normalizeLongitudeRadians(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new InvalidValueException("Infinite or NaN longitude");
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public void setGamma(double gamma) {
    }

    public Boolean isGeographic() {
        return false;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Projection) {
            Projection p = (Projection)that;
            return this.getClass().equals(that.getClass()) && this.ellipsoid.isEqual(p.ellipsoid) && this.falseNorthing == p.falseNorthing && this.falseEasting == p.falseEasting && this.scaleFactor == p.scaleFactor && this.fromMetres == p.fromMetres && this.trueScaleLatitude == p.trueScaleLatitude && this.projectionLatitude == p.projectionLatitude && this.projectionLongitude == p.projectionLongitude && this.projectionLatitude1 == p.projectionLatitude1 && this.projectionLatitude2 == p.projectionLatitude2 && this.minLatitude == p.minLatitude && this.maxLatitude == p.maxLatitude && this.minLongitude == p.minLongitude && this.maxLongitude == p.maxLongitude && this.axes.equals(p.axes) && this.unit.equals(p.unit) && this.primeMeridian.equals(p.primeMeridian);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.ellipsoid, this.falseNorthing, this.falseEasting, this.scaleFactor, this.fromMetres, this.trueScaleLatitude, this.projectionLatitude, this.projectionLongitude, this.projectionLatitude1, this.projectionLatitude2, this.minLatitude, this.maxLatitude, this.minLongitude, this.maxLongitude, this.axes, this.unit, this.primeMeridian);
    }
}

