/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;

@Deprecated
public class GenericFibonacciHeap<K, T> {
    private static final double ONEOVERLOGPHI = 1.0 / Math.log((1.0 + Math.sqrt(5.0)) / 2.0);
    private Node minNode;
    private int nNodes;
    private Comparator<K> comparator;

    public GenericFibonacciHeap(Comparator<K> comparator) {
        this.comparator = Objects.requireNonNull(comparator, "Key comparator cannot be null");
    }

    public boolean isEmpty() {
        return this.minNode == null;
    }

    public void clear() {
        this.minNode = null;
        this.nNodes = 0;
    }

    public Node insert(K key, T data) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Node node = new Node(key, data);
        if (this.minNode != null) {
            node.left = this.minNode;
            node.right = this.minNode.right;
            this.minNode.right = node;
            node.right.left = node;
            if (this.comparator.compare(key, this.minNode.key) < 0) {
                this.minNode = node;
            }
        } else {
            node.left = node;
            node.right = node;
            this.minNode = node;
        }
        ++this.nNodes;
        return node;
    }

    public Node min() {
        return this.minNode;
    }

    public Node removeMin() {
        Node z = this.minNode;
        if (z != null) {
            Node x = z.child;
            for (int numKids = z.degree; numKids > 0; --numKids) {
                Node tempRight = x.right;
                x.left.right = x.right;
                x.right.left = x.left;
                x.left = this.minNode;
                x.right = this.minNode.right;
                this.minNode.right = x;
                x.right.left = x;
                x.parent = null;
                x = tempRight;
            }
            z.left.right = z.right;
            z.right.left = z.left;
            if (z == z.right) {
                this.minNode = null;
            } else {
                this.minNode = z.right;
                this.consolidate();
            }
            --this.nNodes;
            z.left = null;
            z.right = null;
            z.degree = 0;
            z.child = null;
            z.mark = false;
        }
        return z;
    }

    public int size() {
        return this.nNodes;
    }

    public static <K, T> GenericFibonacciHeap<K, T> union(GenericFibonacciHeap<K, T> h1, GenericFibonacciHeap<K, T> h2) {
        if (h1 == null || h2 == null) {
            throw new IllegalArgumentException("Heaps cannot be null");
        }
        GenericFibonacciHeap<K, T> h = new GenericFibonacciHeap<K, T>(h1.comparator);
        h.minNode = h1.minNode;
        if (h.minNode != null) {
            if (h2.minNode != null) {
                h.minNode.right.left = h2.minNode.left;
                h2.minNode.left.right = h.minNode.right;
                h.minNode.right = h2.minNode;
                h2.minNode.left = h.minNode;
                if (h1.comparator.compare(h2.minNode.key, h1.minNode.key) < 0) {
                    h.minNode = h2.minNode;
                }
            }
        } else {
            h.minNode = h2.minNode;
        }
        h.nNodes = h1.nNodes + h2.nNodes;
        return h;
    }

    public String toString() {
        if (this.minNode == null) {
            return "FibonacciHeap=[]";
        }
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        stack.push(this.minNode);
        StringBuilder buf = new StringBuilder(512);
        buf.append("FibonacciHeap=[");
        while (!stack.isEmpty()) {
            Node curr = (Node)stack.pop();
            buf.append(curr);
            buf.append(", ");
            if (curr.child != null) {
                stack.push(curr.child);
            }
            Node start = curr;
            curr = curr.right;
            while (curr != start) {
                buf.append(curr);
                buf.append(", ");
                if (curr.child != null) {
                    stack.push(curr.child);
                }
                curr = curr.right;
            }
        }
        buf.append(']');
        return buf.toString();
    }

    private void cascadingCut(Node y) {
        Node z = y.parent;
        while (z != null) {
            if (!y.mark) {
                y.mark = true;
                return;
            }
            this.cut(y, z);
            y = z;
            z = z.parent;
        }
    }

    private void consolidate() {
        int arraySize = (int)Math.floor(Math.log(this.nNodes) * ONEOVERLOGPHI) + 1;
        ArrayList<Node> array = new ArrayList<Node>(arraySize);
        for (int i = 0; i < arraySize; ++i) {
            array.add(null);
        }
        int numRoots = 0;
        Node x = this.minNode;
        if (x != null) {
            ++numRoots;
            x = x.right;
            while (x != this.minNode) {
                ++numRoots;
                x = x.right;
            }
        }
        while (numRoots > 0) {
            Node y;
            int d = x.degree;
            Node next = x.right;
            while ((y = (Node)array.get(d)) != null) {
                if (this.comparator.compare(x.key, y.key) > 0) {
                    Node temp = y;
                    y = x;
                    x = temp;
                }
                this.link(y, x);
                array.set(d, null);
                ++d;
            }
            array.set(d, x);
            x = next;
            --numRoots;
        }
        this.minNode = null;
        for (int i = 0; i < arraySize; ++i) {
            Node y = (Node)array.get(i);
            if (y == null) continue;
            if (this.minNode != null) {
                y.left.right = y.right;
                y.right.left = y.left;
                y.left = this.minNode;
                y.right = this.minNode.right;
                this.minNode.right = y;
                y.right.left = y;
                if (this.comparator.compare(y.key, this.minNode.key) >= 0) continue;
                this.minNode = y;
                continue;
            }
            this.minNode = y;
        }
    }

    private void cut(Node x, Node y) {
        x.left.right = x.right;
        x.right.left = x.left;
        --y.degree;
        if (y.child == x) {
            y.child = x.right;
        }
        if (y.degree == 0) {
            y.child = null;
        }
        x.left = this.minNode;
        x.right = this.minNode.right;
        this.minNode.right = x;
        x.right.left = x;
        x.parent = null;
        x.mark = false;
    }

    private void link(Node y, Node x) {
        y.left.right = y.right;
        y.right.left = y.left;
        y.parent = x;
        if (x.child == null) {
            x.child = y;
            y.right = y;
            y.left = y;
        } else {
            y.left = x.child;
            y.right = x.child.right;
            x.child.right = y;
            y.right.left = y;
        }
        ++x.degree;
        y.mark = false;
    }

    public class Node {
        T data;
        Node child;
        Node left;
        Node parent;
        Node right;
        boolean mark;
        K key;
        int degree;

        Node(K key, T data) {
            this.key = key;
            this.data = data;
        }

        public K getKey() {
            return this.key;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public void decreaseKey(K k) {
            if (GenericFibonacciHeap.this.comparator.compare(k, this.key) > 0) {
                throw new IllegalArgumentException("decreaseKey() got larger key value. Current key: " + this.key + " new key: " + k);
            }
            if (this.right == null) {
                throw new IllegalArgumentException("Invalid heap node");
            }
            this.key = k;
            Node y = this.parent;
            if (y != null && GenericFibonacciHeap.this.comparator.compare(this.key, y.key) < 0) {
                GenericFibonacciHeap.this.cut(this, y);
                GenericFibonacciHeap.this.cascadingCut(y);
            }
            if (GenericFibonacciHeap.this.comparator.compare(this.key, ((GenericFibonacciHeap)GenericFibonacciHeap.this).minNode.key) < 0) {
                GenericFibonacciHeap.this.minNode = this;
            }
        }

        public void delete() {
            this.forceDecreaseToMinimum();
            GenericFibonacciHeap.this.removeMin();
        }

        private void forceDecreaseToMinimum() {
            if (this.right == null) {
                throw new IllegalArgumentException("Invalid heap node");
            }
            Node y = this.parent;
            if (y != null) {
                GenericFibonacciHeap.this.cut(this, y);
                GenericFibonacciHeap.this.cascadingCut(y);
            }
            GenericFibonacciHeap.this.minNode = this;
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

