/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.migrate;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.shared.uuid.JenaUUID;

public class L {
    private static ExecutorService executor = Executors.newCachedThreadPool();

    public static byte[] uuidAsBytes(UUID uuid) {
        return L.uuidAsBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static byte[] uuidAsBytes(JenaUUID uuid) {
        return L.uuidAsBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static byte[] uuidAsBytes(long mostSignificantBits, long leastSignificantBits) {
        byte[] bytes = new byte[16];
        Bytes.setLong((long)mostSignificantBits, (byte[])bytes, (int)0);
        Bytes.setLong((long)leastSignificantBits, (byte[])bytes, (int)8);
        return bytes;
    }

    public static byte[] uuidAsBytes(String str) {
        return L.uuidAsBytes(UUID.fromString(str));
    }

    public static String uuidToString(long mostSignificantBits, long leastSignificantBits) {
        return new UUID(mostSignificantBits, leastSignificantBits).toString();
    }

    public static void async(Runnable r) {
        Semaphore semaStart = new Semaphore(0, true);
        Runnable r2 = () -> {
            semaStart.release(1);
            r.run();
        };
        executor.execute(r2);
        semaStart.acquireUninterruptibly();
    }

    public static void syncOtherThread(Runnable r) {
        L.runCallable(() -> {
            r.run();
            return null;
        });
    }

    public static <T> T syncCallThread(Supplier<T> r) {
        return (T)L.runCallable(() -> {
            Object t = r.get();
            return t;
        });
    }

    private static <T> T runCallable(Callable<T> action) {
        try {
            return executor.submit(action).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void withBeforeAfter(Runnable action, Runnable before, Runnable after) {
        before.run();
        try {
            action.run();
        }
        finally {
            after.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V callWithBeforeAfter(Supplier<V> action, Runnable before, Runnable after) {
        before.run();
        try {
            V v = action.get();
            return v;
        }
        finally {
            after.run();
        }
    }

    public static void withAfter(Runnable action, Runnable after) {
        try {
            action.run();
        }
        finally {
            after.run();
        }
    }

    public static <V> V callWithAfter(Supplier<V> action, Runnable after) {
        try {
            V v = action.get();
            return v;
        }
        finally {
            after.run();
        }
    }

    public static <V> V callWithLock(Lock lock, Supplier<V> r) {
        return L.callWithBeforeAfter(r, () -> lock.lock(), () -> lock.unlock());
    }

    public static void withLock(Lock lock, Runnable r) {
        L.withBeforeAfter(r, () -> lock.lock(), () -> lock.unlock());
    }

    public static void writeStringAsUTF8(String filename, String content) throws IOException {
        try (OutputStream out = IO.openOutputFileEx((String)filename);){
            L.writeStringAsUTF8(out, content);
            out.flush();
        }
    }

    public static void writeStringAsUTF8(OutputStream out, String content) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        w.write(content);
        ((Writer)w).flush();
    }

    public static ByteBuffer stringToByteBuffer(String str) {
        byte[] b = StrUtils.asUTF8bytes((String)str);
        return ByteBuffer.wrap(b);
    }

    public static String byteBufferToString(ByteBuffer bb) {
        byte[] b = new byte[bb.remaining()];
        bb.get(b);
        return StrUtils.fromUTF8bytes((byte[])b);
    }
}

