/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.utils;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;

public abstract class TypePromoter {
    private Class targetType = null;

    public abstract AnyAtomicType doPromote(AnyAtomicType var1) throws DynamicError;

    public final AnyAtomicType promote(AnyType value) throws DynamicError {
        if (value.getClass() == this.getTargetType()) {
            return (AnyAtomicType)value;
        }
        return this.doPromote(this.atomize(value));
    }

    protected abstract Class substitute(Class var1);

    protected abstract boolean checkCombination(Class var1);

    public void considerType(Class typeToConsider) throws DynamicError {
        Class baseType = this.substitute(typeToConsider);
        String typeStrName = this.getTypeNameStr(typeToConsider);
        if (baseType == null) {
            throw DynamicError.argument_type_error(typeStrName);
        }
        if (this.targetType == null) {
            this.targetType = baseType;
        } else if (!this.checkCombination(baseType)) {
            throw DynamicError.argument_type_error(typeStrName);
        }
    }

    private String getTypeNameStr(Class typeClass) {
        String typeStrName = "";
        try {
            typeStrName = ((AnyType)typeClass.newInstance()).string_type();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return typeStrName;
    }

    public void considerTypes(Collection typesToConsider) throws DynamicError {
        Iterator iter = typesToConsider.iterator();
        while (iter.hasNext()) {
            this.considerType((Class)iter.next());
        }
    }

    public void considerSequence(ResultSequence sequenceToConsider) throws DynamicError {
        for (int i = 0; i < sequenceToConsider.size(); ++i) {
            AnyType item = sequenceToConsider.get(i);
            this.considerValue(item);
        }
    }

    public Class getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(Class class1) {
        this.targetType = class1;
    }

    public AnyAtomicType atomize(AnyType at) throws DynamicError {
        if (at instanceof NodeType) {
            return (AnyAtomicType)((NodeType)at).typed_value().first();
        }
        return (AnyAtomicType)at;
    }

    public void considerValue(AnyType at) throws DynamicError {
        this.considerType(this.atomize(at).getClass());
    }
}

