/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;

public class XSString
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_STRING = "xs:string";
    private String _value;

    public XSString(String x) {
        this._value = x;
    }

    public XSString() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_STRING;
    }

    @Override
    public String type_name() {
        return "string";
    }

    @Override
    public String string_value() {
        return this._value;
    }

    public String value() {
        return this.string_value();
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        rs.add(new XSString(aat.string_value()));
        return rs;
    }

    private int do_compare(AnyType arg, DynamicContext dc) throws DynamicError {
        if (arg == null) {
            return 666;
        }
        XSString comparand = arg instanceof XSString ? (XSString)arg : new XSString(arg.string_value());
        BigInteger result = FnCompare.compare_string(dc.default_collation_name(), this, comparand, dc);
        return result.intValue();
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp;
        if (arg instanceof XSDecimal) {
            DynamicError.invalidType();
        }
        if ((cmp = this.do_compare(arg, context)) == 666) assert (false);
        return cmp == 0;
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp = this.do_compare(arg, context);
        assert (cmp != 666);
        return cmp > 0;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp = this.do_compare(arg, context);
        assert (cmp != 666);
        return cmp < 0;
    }
}

