/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class XSGDay
extends CalendarType
implements CmpEq {
    private static final String XS_G_DAY = "xs:gDay";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSGDay(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        if (tz != null) {
            this._timezoned = true;
            this._tz = tz;
        }
    }

    public XSGDay() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    @Override
    public String type_name() {
        return "gDay";
    }

    public static XSGDay parse_gDay(String str) {
        String startdate = "1972-12-";
        String starttime = "T00:00:00";
        int index = str.lastIndexOf(43, str.length());
        if (index == -1) {
            index = str.lastIndexOf(45);
        }
        if (index == -1) {
            index = str.lastIndexOf(90, str.length());
        }
        if (index != -1) {
            int zIndex = str.lastIndexOf(90, str.length());
            if (zIndex == -1 && index > 4) {
                zIndex = index;
            }
            if (zIndex == -1) {
                zIndex = str.lastIndexOf(43);
            }
            String[] split = str.split("-");
            startdate = startdate + split[3].replaceAll("Z", "");
            if (str.indexOf(84) != -1 && split.length > 4) {
                String[] timesplit = split[4].split(":");
                if (timesplit.length < 3) {
                    starttime = "T";
                    StringBuffer buf = new StringBuffer(starttime);
                    for (int cnt = 0; cnt < timesplit.length; ++cnt) {
                        buf.append(timesplit[cnt] + ":");
                    }
                    buf.append("00");
                    starttime = buf.toString();
                } else {
                    starttime = starttime + timesplit[0] + ":" + timesplit[1] + ":" + timesplit[2];
                }
            }
            startdate = startdate.trim();
            startdate = startdate + starttime;
            if (zIndex != -1) {
                startdate = startdate + str.substring(zIndex);
            }
        } else {
            startdate = startdate + str + starttime;
        }
        XSDateTime dt = XSDateTime.parseDateTime(startdate);
        if (dt == null) {
            return null;
        }
        return new XSGDay(dt.calendar(), dt.tz());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof XSTime || this.isGDataType(aat) || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSGDay val = this.castGDay(aat);
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(val);
        return rs;
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        return aat instanceof XSDate || aat instanceof XSDateTime || aat instanceof XSGDay;
    }

    protected boolean isGDataType(AnyAtomicType aat) {
        String type = aat.string_type();
        return type.equals("xs:gMonthDay") || type.equals("xs:gMonth") || type.equals("xs:gYear") || type.equals("xs:gYearMonth");
    }

    private XSGDay castGDay(AnyAtomicType aat) {
        if (aat instanceof XSGDay) {
            XSGDay gday = (XSGDay)aat;
            return new XSGDay(gday.calendar(), gday.tz());
        }
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSGDay(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSGDay(dateTime.calendar(), dateTime.tz());
        }
        return XSGDay.parse_gDay(aat.string_value());
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    @Override
    public String string_value() {
        String ret = "---";
        Calendar adjustFortimezone = this.calendar();
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(5), 2);
        if (this.timezoned()) {
            int hrs = this.tz().hours();
            int min = this.tz().minutes();
            double secs = this.tz().seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = ret + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this.tz().negative() ? tZoneStr + "-" : tZoneStr + "+";
                tZoneStr = tZoneStr + XSDateTime.pad_int(hrs, 2);
                tZoneStr = tZoneStr + ":";
                tZoneStr = tZoneStr + XSDateTime.pad_int(min, 2);
                ret = ret + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_G_DAY;
    }

    public Calendar calendar() {
        return this._calendar;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        XSGDay val = (XSGDay)NumericType.get_single_type(arg, XSGDay.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    public XSDuration tz() {
        return this._tz;
    }
}

