/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.ScalarTypePromoter;

public class FnSum
extends Function {
    private static XSInteger ZERO = new XSInteger(BigInteger.ZERO);

    public FnSum() {
        super(new QName("sum"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        Iterator argIterator = args.iterator();
        ResultSequence argSequence = (ResultSequence)argIterator.next();
        AnyAtomicType zero = ZERO;
        if (argIterator.hasNext()) {
            ResultSequence zeroSequence = (ResultSequence)argIterator.next();
            if (zeroSequence.size() != 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            if (!(zeroSequence.first() instanceof AnyAtomicType)) {
                throw new DynamicError(TypeError.invalid_type(zeroSequence.first().string_value()));
            }
            zero = (AnyAtomicType)zeroSequence.first();
        }
        return FnSum.sum(argSequence, zero);
    }

    public static ResultSequence sum(ResultSequence arg, AnyAtomicType zero) throws DynamicError {
        if (arg.empty()) {
            return ResultSequenceFactory.create_new(zero);
        }
        MathPlus total = null;
        ResultSequence atomizedInputSeq = FnData.atomize(arg);
        if ((AnyAtomicType)atomizedInputSeq.first() instanceof XSDuration) {
            ListIterator i = atomizedInputSeq.iterator();
            while (i.hasNext()) {
                AnyAtomicType conv = (AnyAtomicType)i.next();
                if (total == null) {
                    total = (MathPlus)((Object)conv);
                    continue;
                }
                total = (MathPlus)((Object)total.plus(ResultSequenceFactory.create_new(conv)).first());
            }
        } else {
            ScalarTypePromoter tp = new ScalarTypePromoter();
            tp.considerSequence(arg);
            ListIterator i = arg.iterator();
            while (i.hasNext()) {
                AnyAtomicType conv = tp.promote((AnyType)i.next());
                if (conv instanceof XSDouble && ((XSDouble)conv).nan() || conv instanceof XSFloat && ((XSFloat)conv).nan()) {
                    return ResultSequenceFactory.create_new(tp.promote(new XSFloat(Float.NaN)));
                }
                if (total == null) {
                    total = (MathPlus)((Object)conv);
                    continue;
                }
                total = (MathPlus)((Object)total.plus(ResultSequenceFactory.create_new(conv)).first());
            }
        }
        return ResultSequenceFactory.create_new((AnyType)((Object)total));
    }
}

