/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.AbstractCollationEqualFunction;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.w3c.dom.Node;

public class FnDeepEqual
extends AbstractCollationEqualFunction {
    public FnDeepEqual() {
        super(new QName("deep-equal"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnDeepEqual.deep_equal(args, this.dynamic_context());
    }

    public static ResultSequence deep_equal(Collection args, DynamicContext context) throws DynamicError {
        Iterator citer = args.iterator();
        ResultSequence arg1 = (ResultSequence)citer.next();
        ResultSequence arg2 = (ResultSequence)citer.next();
        ResultSequence arg3 = null;
        String collationURI = context.default_collation_name();
        if (citer.hasNext() && !(arg3 = (ResultSequence)citer.next()).empty()) {
            collationURI = arg3.first().string_value();
        }
        boolean result = FnDeepEqual.deep_equal(arg1, arg2, context, collationURI);
        return ResultSequenceFactory.create_new(new XSBoolean(result));
    }

    public static boolean deep_equal(ResultSequence one, ResultSequence two, DynamicContext context, String collationURI) {
        if (one.empty() && two.empty()) {
            return true;
        }
        if (one.size() != two.size()) {
            return false;
        }
        ListIterator onei = one.iterator();
        ListIterator twoi = two.iterator();
        while (onei.hasNext()) {
            AnyType b;
            AnyType a = (AnyType)onei.next();
            if (FnDeepEqual.deep_equal(a, b = (AnyType)twoi.next(), context, collationURI)) continue;
            return false;
        }
        return true;
    }

    public static boolean deep_equal(AnyType one, AnyType two, DynamicContext context, String collationURI) {
        if (one instanceof AnyAtomicType && two instanceof AnyAtomicType) {
            return FnDeepEqual.deep_equal((AnyAtomicType)one, (AnyAtomicType)two, context, collationURI);
        }
        if (one instanceof AnyAtomicType && two instanceof NodeType || one instanceof NodeType && two instanceof AnyAtomicType) {
            return false;
        }
        if (one instanceof NodeType && two instanceof NodeType) {
            return FnDeepEqual.deep_equal((NodeType)one, (NodeType)two, context);
        }
        return false;
    }

    public static boolean deep_equal(AnyAtomicType one, AnyAtomicType two, DynamicContext context, String collationURI) {
        boolean isUntypedAtomic = false;
        if (one instanceof XSUntypedAtomic || two instanceof XSUntypedAtomic) {
            isUntypedAtomic = true;
        }
        if (!(isUntypedAtomic || one instanceof CmpEq || two instanceof CmpEq)) {
            return false;
        }
        try {
            XSString xstr2;
            XSString xstr1;
            CmpEq a;
            if (FnDeepEqual.isNumeric(one, (AnyType)two)) {
                NumericType numeric = (NumericType)one;
                if (numeric.eq(two, context)) {
                    return true;
                }
                XSString value1 = new XSString(one.string_value());
                if (value1.eq(two, context)) {
                    return true;
                }
            }
            if (!(one instanceof XSUntypedAtomic) && one instanceof CmpEq && (a = (CmpEq)((Object)one)).eq(two, context)) {
                return true;
            }
            return FnDeepEqual.needsStringComparison(one, (AnyType)two) && FnCompare.compare_string(collationURI, xstr1 = new XSString(one.string_value()), xstr2 = new XSString(two.string_value()), context).equals(BigInteger.ZERO);
        }
        catch (DynamicError err) {
            return false;
        }
    }

    public static boolean deep_equal(NodeType one, NodeType two, DynamicContext context) {
        Node b;
        Node a = one.node_value();
        return a.isEqualNode(b = two.node_value());
    }
}

