/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.utils.ScalarTypePromoter;

public class FnAvg
extends Function {
    public FnAvg() {
        super(new QName("avg"), 1);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnAvg.avg(args);
    }

    public static ResultSequence avg(Collection args) throws DynamicError {
        ResultSequence arg = (ResultSequence)args.iterator().next();
        if (arg.empty()) {
            return ResultSequenceFactory.create_new();
        }
        int elems = 0;
        MathPlus total = null;
        ScalarTypePromoter tp = new ScalarTypePromoter();
        tp.considerSequence(arg);
        ListIterator i = arg.iterator();
        while (i.hasNext()) {
            ++elems;
            AnyAtomicType conv = tp.promote((AnyType)i.next());
            if (conv instanceof XSDouble && ((XSDouble)conv).nan() || conv instanceof XSFloat && ((XSFloat)conv).nan()) {
                return ResultSequenceFactory.create_new(tp.promote(new XSFloat(Float.NaN)));
            }
            if (total == null) {
                total = (MathPlus)((Object)conv);
                continue;
            }
            total = (MathPlus)((Object)total.plus(ResultSequenceFactory.create_new(conv)).first());
        }
        if (!(total instanceof MathDiv)) {
            DynamicError.throw_type_error();
        }
        return ((MathDiv)((Object)total)).div(ResultSequenceFactory.create_new(new XSInteger(BigInteger.valueOf(elems))));
    }
}

