/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.Evaluator;
import org.eclipse.wst.xml.xpath2.processor.PsychoPathXPathTypeHelper;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.XPathException;
import org.eclipse.wst.xml.xpath2.processor.ast.XPath;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultStaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.DescendantOrSelfAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.Focus;
import org.eclipse.wst.xml.xpath2.processor.internal.ForwardAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.ParentAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.ReverseAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.SelfAxis;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.StaticTypeNameError;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AddExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AndExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AnyKindTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AttributeTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.AxisStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.BinExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CastableExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CmpExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CntxItemExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.CommentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DecimalLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DocumentTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.DoubleLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ElementTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ExceptExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.Expr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FilterExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ForwardStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.FunctionCall;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IDivExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.InstOfExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntegerLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.IntersectExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ItemType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MinusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ModExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.MulExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.NameTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.OrExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PITest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ParExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PipeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.PlusExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.QuantifiedExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.RangeExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.ReverseStep;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaAttrTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SchemaElemTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SequenceType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SingleType;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StepExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.StringLiteral;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.SubExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TextTest;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.TreatAsExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.UnionExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarExprPair;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.VarRef;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathExpr;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathNode;
import org.eclipse.wst.xml.xpath2.processor.internal.ast.XPathVisitor;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnRoot;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsGe;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsIDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsLe;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsMod;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsNe;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FsTimes;
import org.eclipse.wst.xml.xpath2.processor.internal.function.OpExcept;
import org.eclipse.wst.xml.xpath2.processor.internal.function.OpIntersect;
import org.eclipse.wst.xml.xpath2.processor.internal.function.OpTo;
import org.eclipse.wst.xml.xpath2.processor.internal.function.OpUnion;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CommentType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.PIType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.TextType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultEvaluator
implements XPathVisitor,
Evaluator {
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final QName ANY_ATOMIC_TYPE = new QName("xs", "anyAtomicType", "http://www.w3.org/2001/XMLSchema");
    private DynamicContext _dc;
    private XPathException _err;
    private Collection _g_coll;
    private XSInteger _g_xsint;
    private Object _param;
    private boolean fIsReverseStep = false;

    public DefaultEvaluator(DynamicContext dc, Document doc) {
        this._dc = dc;
        this._err = null;
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (doc != null) {
            rs.add(new DocType(doc));
        }
        this._dc.set_focus(new Focus(rs));
        this._param = null;
        this._g_coll = new ArrayList();
        this._g_xsint = new XSInteger();
    }

    public DefaultEvaluator(DynamicContext dc, Document doc, Node rootNode) {
        this._dc = dc;
        this._err = null;
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (rootNode != null && rootNode.getOwnerDocument() == doc) {
            this._dc.setRootNode(rootNode);
            if (rootNode.getNodeType() == 9) {
                rs.add(new DocType((Document)rootNode));
            } else if (rootNode.getNodeType() == 1) {
                rs.add(new ElementType((Element)rootNode));
            }
            this._dc.set_focus(new Focus(rs));
        } else {
            if (doc != null) {
                rs.add(new DocType(doc));
            }
            this._dc.set_focus(new Focus(rs));
        }
        this._param = null;
        this._g_coll = new ArrayList();
        this._g_xsint = new XSInteger();
    }

    private void report_error(DynamicError err) {
        this._err = err;
        throw new DummyError(0);
    }

    private void report_error(TypeError err) {
        this._err = err;
        throw new DummyError(1);
    }

    private void report_error(StaticNameError err) {
        throw new DummyError(666);
    }

    @Override
    public ResultSequence evaluate(XPathNode node) throws DynamicError {
        try {
            return (ResultSequence)node.accept(this);
        }
        catch (DummyError e) {
            switch (e.type()) {
                case 0: {
                    throw (DynamicError)this._err;
                }
                case 1: {
                    throw new DynamicError((TypeError)this._err);
                }
            }
            assert (false);
            return null;
        }
    }

    private ResultSequence do_expr(Iterator i) {
        ResultSequence rs = null;
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            ResultSequence result = (ResultSequence)e.accept(this);
            if (rs == null) {
                rs = result;
                continue;
            }
            rs.concat(result);
        }
        if (rs == null) {
            rs = ResultSequenceFactory.create_new();
        }
        return rs;
    }

    @Override
    public Object visit(XPath xp) {
        ResultSequence rs = this.do_expr(xp.iterator());
        return rs;
    }

    private ResultSequence do_for_quantified_expr(ListIterator iter, Expr finalexpr, int type) {
        if (iter.hasNext()) {
            boolean allocated_var = false;
            ResultSequence result = ResultSequenceFactory.create_new();
            VarExprPair ve = (VarExprPair)iter.next();
            ResultSequence rs = (ResultSequence)ve.expr().accept(this);
            if (rs.empty()) {
                iter.previous();
                return result;
            }
            QName varname = ve.varname();
            ListIterator i = rs.iterator();
            while (i.hasNext()) {
                AnyType item = (AnyType)i.next();
                this._dc.set_variable(varname, item);
                allocated_var = true;
                this._dc.new_scope();
                ResultSequence res = this.do_for_quantified_expr(iter, finalexpr, type);
                this._dc.destroy_scope();
                assert (res != null);
                XSBoolean effbool = null;
                switch (type) {
                    case 0: {
                        result.concat(res);
                        break;
                    }
                    case 1: 
                    case 2: {
                        effbool = this.effective_boolean_value(res);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (effbool == null) continue;
                if (type == 1) {
                    result = ResultSequenceFactory.create_new(effbool);
                    if (effbool.value()) continue;
                    break;
                }
                if (type == 2) {
                    result = ResultSequenceFactory.create_new(effbool);
                    if (!effbool.value()) continue;
                    break;
                }
                assert (false);
            }
            if (allocated_var) {
                boolean del = this._dc.del_variable(varname);
                assert (del);
            }
            iter.previous();
            return result;
        }
        return (ResultSequence)finalexpr.accept(this);
    }

    @Override
    public Object visit(ForExpr fex) {
        ArrayList pairs = new ArrayList(fex.ve_pairs());
        return this.do_for_quantified_expr(pairs.listIterator(), fex.expr(), 0);
    }

    @Override
    public Object visit(QuantifiedExpr qex) {
        ArrayList pairs = new ArrayList(qex.ve_pairs());
        int hack = 0;
        switch (qex.type()) {
            case 0: {
                hack = 2;
                break;
            }
            case 1: {
                hack = 1;
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        ResultSequence rs = this.do_for_quantified_expr(pairs.listIterator(), qex.expr(), hack);
        if (!rs.empty()) {
            return rs;
        }
        switch (qex.type()) {
            case 0: {
                return ResultSequenceFactory.create_new(new XSBoolean(false));
            }
            case 1: {
                return ResultSequenceFactory.create_new(new XSBoolean(true));
            }
        }
        assert (false);
        return null;
    }

    @Override
    public Object visit(IfExpr ifex) {
        ResultSequence test_res = this.do_expr(ifex.iterator());
        XSBoolean res = this.effective_boolean_value(test_res);
        if (res.value()) {
            return ifex.then_clause().accept(this);
        }
        return ifex.else_clause().accept(this);
    }

    private boolean[] do_logic_exp(BinExpr e) {
        Collection args = this.do_bin_args(e);
        Iterator argiter = args.iterator();
        ResultSequence one = (ResultSequence)argiter.next();
        ResultSequence two = (ResultSequence)argiter.next();
        boolean oneb = this.effective_boolean_value(one).value();
        boolean twob = this.effective_boolean_value(two).value();
        boolean[] res = new boolean[]{oneb, twob};
        return res;
    }

    @Override
    public Object visit(OrExpr orex) {
        boolean[] res = this.do_logic_exp(orex);
        return ResultSequenceFactory.create_new(new XSBoolean(res[0] || res[1]));
    }

    @Override
    public Object visit(AndExpr andex) {
        boolean[] res = this.do_logic_exp(andex);
        return ResultSequenceFactory.create_new(new XSBoolean(res[0] && res[1]));
    }

    private ResultSequence node_cmp(int type, Collection args) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        assert (args.size() == 2);
        Iterator argsiter = args.iterator();
        ResultSequence one = (ResultSequence)argsiter.next();
        ResultSequence two = (ResultSequence)argsiter.next();
        int size_one = one.size();
        int size_two = two.size();
        if (size_one > 1 || size_two > 1) {
            this.report_error(TypeError.invalid_type(null));
        }
        if (size_one == 0 || size_two == 0) {
            return rs;
        }
        AnyType at_one = one.first();
        AnyType at_two = two.first();
        if (!(at_one instanceof NodeType) || !(at_two instanceof NodeType)) {
            this.report_error(TypeError.invalid_type(null));
        }
        NodeType nt_one = (NodeType)at_one;
        NodeType nt_two = (NodeType)at_two;
        boolean answer = false;
        switch (type) {
            case 12: {
                answer = nt_one.node_value() == nt_two.node_value();
                break;
            }
            case 13: {
                answer = nt_one.before(nt_two);
                break;
            }
            case 14: {
                answer = nt_one.after(nt_two);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        rs.add(new XSBoolean(answer));
        return rs;
    }

    @Override
    public Object visit(CmpExpr cmpex) {
        try {
            Collection args = this.do_bin_args(cmpex);
            switch (cmpex.type()) {
                case 6: {
                    return FsEq.fs_eq_value(args, this._dc);
                }
                case 7: {
                    return FsNe.fs_ne_value(args, this._dc);
                }
                case 10: {
                    return FsGt.fs_gt_value(args, this._dc);
                }
                case 8: {
                    return FsLt.fs_lt_value(args, this._dc);
                }
                case 11: {
                    return FsGe.fs_ge_value(args, this._dc);
                }
                case 9: {
                    return FsLe.fs_le_value(args, this._dc);
                }
                case 0: {
                    return FsEq.fs_eq_general(args, this._dc);
                }
                case 1: {
                    return FsNe.fs_ne_general(args, this._dc);
                }
                case 4: {
                    return FsGt.fs_gt_general(args, this._dc);
                }
                case 2: {
                    return FsLt.fs_lt_general(args, this._dc);
                }
                case 5: {
                    return FsGe.fs_ge_general(args, this._dc);
                }
                case 3: {
                    return FsLe.fs_le_general(args, this._dc);
                }
                case 12: 
                case 13: 
                case 14: {
                    return this.node_cmp(cmpex.type(), args);
                }
            }
            assert (false);
        }
        catch (DynamicError err) {
            this.report_error(err);
        }
        return null;
    }

    @Override
    public Object visit(RangeExpr rex) {
        ResultSequence one = (ResultSequence)rex.left().accept(this);
        ResultSequence two = (ResultSequence)rex.right().accept(this);
        if (one.empty() || two.empty()) {
            return ResultSequenceFactory.create_new();
        }
        ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
        args.add(one);
        args.add(two);
        try {
            return OpTo.op_to(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    private XSBoolean effective_boolean_value(ResultSequence rs) {
        try {
            return FnBoolean.fn_boolean(rs);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(AddExpr addex) {
        try {
            Collection args = this.do_bin_args(addex);
            return FsPlus.fs_plus(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(SubExpr subex) {
        try {
            Collection args = this.do_bin_args(subex);
            return FsMinus.fs_minus(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(MulExpr mulex) {
        try {
            Collection args = this.do_bin_args(mulex);
            return FsTimes.fs_times(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(DivExpr mulex) {
        try {
            Collection args = this.do_bin_args(mulex);
            return FsDiv.fs_div(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(IDivExpr mulex) {
        try {
            Collection args = this.do_bin_args(mulex);
            return FsIDiv.fs_idiv(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(ModExpr mulex) {
        try {
            Collection args = this.do_bin_args(mulex);
            return FsMod.fs_mod(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    private Collection do_bin_args(BinExpr e) {
        ResultSequence one = (ResultSequence)e.left().accept(this);
        ResultSequence two = (ResultSequence)e.right().accept(this);
        ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
        args.add(one);
        args.add(two);
        return args;
    }

    @Override
    public Object visit(UnionExpr unex) {
        try {
            Collection args = this.do_bin_args(unex);
            return OpUnion.op_union(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(PipeExpr pipex) {
        try {
            Collection args = this.do_bin_args(pipex);
            return OpUnion.op_union(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(IntersectExpr iexpr) {
        try {
            Collection args = this.do_bin_args(iexpr);
            return OpIntersect.op_intersect(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(ExceptExpr eexpr) {
        try {
            Collection args = this.do_bin_args(eexpr);
            return OpExcept.op_except(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(InstOfExpr ioexp) {
        ResultSequence rs = (ResultSequence)ioexp.left().accept(this);
        SequenceType seqt = (SequenceType)ioexp.right();
        return ResultSequenceFactory.create_new(new XSBoolean(this.isInstanceOf(rs, seqt)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInstanceOf(ResultSequence rs, SequenceType seqt) {
        Object oldParam = this._param;
        try {
            this._param = new Pair(null, rs);
            int sequenceLength = rs.size();
            seqt.accept(this);
            int lengthAfter = rs.size();
            if (sequenceLength != lengthAfter) {
                boolean bl = false;
                return bl;
            }
            boolean bl = seqt.isLengthValid(sequenceLength);
            return bl;
        }
        finally {
            this._param = oldParam;
        }
    }

    @Override
    public Object visit(TreatAsExpr taexp) {
        ResultSequence rs = (ResultSequence)taexp.left().accept(this);
        SequenceType seqt = (SequenceType)taexp.right();
        SeqType st = new SeqType(seqt, this._dc, rs);
        try {
            st.match(rs);
        }
        catch (DynamicError err) {
            this.report_error(err);
        }
        return rs;
    }

    @Override
    public Object visit(CastableExpr cexp) {
        boolean castable = false;
        try {
            CastExpr ce = new CastExpr((Expr)cexp.left(), (SingleType)cexp.right());
            this.visit(ce);
            castable = true;
        }
        catch (Throwable t) {
            castable = false;
        }
        return ResultSequenceFactory.create_new(new XSBoolean(castable));
    }

    @Override
    public Object visit(CastExpr cexp) {
        AnyType at;
        ResultSequence rs = (ResultSequence)cexp.left().accept(this);
        SingleType st = (SingleType)cexp.right();
        try {
            rs = FnData.atomize(rs);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
        if (rs.size() > 1) {
            this.report_error(TypeError.invalid_type(null));
        }
        if (rs.empty()) {
            if (st.qmark()) {
                return rs;
            }
            this.report_error(TypeError.invalid_type(null));
        }
        if (!((at = rs.first()) instanceof AnyAtomicType)) {
            this.report_error(TypeError.invalid_type(null));
        }
        AnyAtomicType aat = (AnyAtomicType)at;
        QName type = st.type();
        if (this._dc.function_exists(type, 1)) {
            ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
            args.add(ResultSequenceFactory.create_new(aat));
            try {
                return this._dc.evaluate_function(type, args);
            }
            catch (DynamicError err) {
                this.report_error(err);
                return null;
            }
        }
        XSTypeDefinition inScopeTypeDefn = ((DefaultStaticContext)((Object)this._dc)).getInScopeTypeDefinition(type);
        if (inScopeTypeDefn == null || inScopeTypeDefn instanceof XSComplexTypeDefinition || ((XSSimpleTypeDefinition)inScopeTypeDefn).getVariety() != 1) {
            throw new DummyError(1);
        }
        if (PsychoPathXPathTypeHelper.isValueValidForSimpleType(at.string_value(), (XSSimpleType)inScopeTypeDefn)) {
            return true;
        }
        throw new DummyError(0);
    }

    @Override
    public Object visit(MinusExpr e) {
        ResultSequence rs = (ResultSequence)e.arg().accept(this);
        ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
        args.add(rs);
        try {
            return FsMinus.fs_minus_unary(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(PlusExpr e) {
        ResultSequence rs = (ResultSequence)e.arg().accept(this);
        ArrayList<ResultSequence> args = new ArrayList<ResultSequence>();
        args.add(rs);
        try {
            return FsPlus.fs_plus_unary(args);
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    private ResultSequence do_step(StepExpr se) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        ArrayList<Object> results = new ArrayList<Object>();
        int type = 0;
        Focus focus = this._dc.focus();
        int original_pos = focus.position();
        do {
            results.add(se.accept(this));
        } while (focus.advance_cp());
        focus.set_position(original_pos);
        boolean node_types = false;
        for (ResultSequence resultSequence : results) {
            ListIterator j = resultSequence.iterator();
            block6: while (j.hasNext()) {
                AnyType item = (AnyType)j.next();
                if (type == 0) {
                    if (item instanceof AnyAtomicType) {
                        type = 1;
                    } else if (item instanceof NodeType) {
                        type = 2;
                    } else assert (false);
                }
                switch (type) {
                    case 1: {
                        if (!(item instanceof AnyAtomicType)) {
                            this.report_error(TypeError.mixed_vals(null));
                        }
                        rs.add(item);
                        continue block6;
                    }
                    case 2: {
                        node_types = true;
                        if (!(item instanceof NodeType)) {
                            this.report_error(TypeError.mixed_vals(null));
                        }
                        rs.add(item);
                        continue block6;
                    }
                }
                assert (false);
            }
        }
        if (node_types) {
            rs = NodeType.linearize(rs);
        }
        return rs;
    }

    private ResultSequence root_self_node() {
        SelfAxis axis = new SelfAxis();
        ResultSequence rs = axis.iterate((NodeType)this._dc.context_item(), this._dc);
        rs = this.kind_test(rs, NodeType.class);
        try {
            ArrayList<ResultSequence> records = new ArrayList<ResultSequence>();
            records.add(rs);
            rs = FnRoot.fn_root(records, this._dc);
        }
        catch (DynamicError err) {
            this.report_error(err);
        }
        return rs;
    }

    private ResultSequence descendant_or_self_node(ResultSequence rs) {
        ResultSequence res = ResultSequenceFactory.create_new();
        DescendantOrSelfAxis axis = new DescendantOrSelfAxis();
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType item = (NodeType)i.next();
            ResultSequence nodes = axis.iterate(item, this._dc);
            nodes = this.kind_test(nodes, NodeType.class);
            res.concat(nodes);
        }
        return res;
    }

    @Override
    public Object visit(XPathExpr e) {
        ResultSequence rs = null;
        Focus original_focus = this._dc.focus();
        for (XPathExpr xp = e; xp != null; xp = xp.next()) {
            StepExpr se = xp.expr();
            if (se != null) {
                if (rs != null) {
                    if (rs.size() == 0) break;
                    ListIterator i = rs.iterator();
                    while (i.hasNext()) {
                        AnyType item = (AnyType)i.next();
                        if (item instanceof NodeType) continue;
                        this.report_error(TypeError.step_conatins_atoms(null));
                        return null;
                    }
                    if (xp.slashes() == 2 && (rs = this.descendant_or_self_node(rs)).size() == 0) break;
                    this._dc.set_focus(new Focus(rs));
                    rs = this.do_step(se);
                    continue;
                }
                if (xp.slashes() == 1) {
                    rs = this.root_self_node();
                    this._dc.set_focus(new Focus(rs));
                    rs = this.do_step(se);
                    continue;
                }
                if (xp.slashes() == 2) {
                    ResultSequence res = ResultSequenceFactory.create_new();
                    rs = this.root_self_node();
                    rs = this.descendant_or_self_node(rs);
                    this._dc.set_focus(new Focus(rs));
                    rs = this.do_step(se);
                    continue;
                }
                rs = (ResultSequence)se.accept(this);
                continue;
            }
            assert (xp.slashes() == 1);
            rs = this.root_self_node();
        }
        this._dc.set_focus(original_focus);
        return rs;
    }

    @Override
    public Object visit(ForwardStep e) {
        AnyType ci = this._dc.context_item();
        if (ci == null) {
            this.report_error(DynamicError.contextUndefined());
        }
        if (!(ci instanceof NodeType)) {
            this.report_error(TypeError.ci_not_node(ci.string_type()));
        }
        NodeType cn = (NodeType)ci;
        ForwardAxis axis = e.iterator();
        ResultSequence nodes = axis.iterate(cn, this._dc);
        Pair arg = new Pair(axis.principal_node_kind().string_type(), nodes);
        this._param = arg;
        ResultSequence rs = (ResultSequence)e.node_test().accept(this);
        if (this._dc.getRootNode() != null) {
            rs = this.removeInvalidNodesFromResultSet(rs, this._dc.getRootNode());
        }
        return rs;
    }

    @Override
    public Object visit(ReverseStep e) {
        this.fIsReverseStep = true;
        AnyType ci = this._dc.context_item();
        if (!(ci instanceof NodeType)) {
            this.report_error(TypeError.ci_not_node(ci.string_type()));
        }
        NodeType cn = (NodeType)ci;
        ReverseAxis axis = e.iterator();
        if (e.axis() == 5) {
            axis = new ParentAxis();
            ResultSequence nodes = this.kind_test(axis.iterate(cn, this._dc), NodeType.class);
            if (this._dc.getRootNode() != null) {
                nodes = this.removeInvalidNodesFromResultSet(nodes, this._dc.getRootNode());
            }
            return nodes;
        }
        assert (axis != null);
        ResultSequence nodes = axis.iterate(cn, this._dc);
        Pair arg = new Pair(axis.principal_node_kind().string_type(), nodes);
        this._param = arg;
        ResultSequence rs = (ResultSequence)e.node_test().accept(this);
        if (this._dc.getRootNode() != null) {
            rs = this.removeInvalidNodesFromResultSet(rs, this._dc.getRootNode());
        }
        return rs;
    }

    private ResultSequence removeInvalidNodesFromResultSet(ResultSequence resultNodes, Node rootNode) {
        ResultSequence validResultNodes = ResultSequenceFactory.create_new();
        ListIterator iter = resultNodes.iterator();
        while (iter.hasNext()) {
            AnyType resultNode = (AnyType)iter.next();
            Node resultNodeVal = null;
            if (resultNode instanceof DocType) {
                resultNodeVal = ((DocType)resultNode).node_value();
            } else if (resultNode instanceof ElementType) {
                resultNodeVal = ((ElementType)resultNode).node_value();
            }
            if (resultNodeVal != null && rootNode.compareDocumentPosition(resultNodeVal) == 10) continue;
            validResultNodes.add(resultNode);
        }
        return validResultNodes;
    }

    private boolean name_test(NodeType node, QName name, String type) {
        if (node == null) {
            return false;
        }
        if (!type.equals(node.string_type())) {
            return false;
        }
        String test_prefix = name.prefix();
        if (test_prefix == null && type.equals("element")) {
            name = new QName(null, name.local());
            name.set_namespace(this._dc.default_namespace());
            if (name.namespace() != null) {
                test_prefix = "";
            }
        }
        QName node_name = node.node_name();
        assert (node_name != null);
        String node_namespace = node_name.namespace();
        String test_namespace = null;
        if (name.expanded()) {
            test_namespace = name.namespace();
        }
        if (test_prefix == null) {
            if (node_namespace != null) {
                return false;
            }
        } else if (!test_namespace.equals("*")) {
            if (node_namespace == null) {
                return false;
            }
            if (!node_namespace.equals(test_namespace)) {
                return false;
            }
        }
        if (name.local().equals("*")) {
            return true;
        }
        return name.local().equals(node_name.local());
    }

    @Override
    public Object visit(NameTest e) {
        QName name = e.name();
        Pair arg = (Pair)this._param;
        String type = (String)arg._one;
        ResultSequence rs = (ResultSequence)arg._two;
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType nt = (NodeType)i.next();
            if (this.name_test(nt, name, type)) continue;
            i.remove();
        }
        return rs;
    }

    @Override
    public Object visit(VarRef e) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        Object var = this._dc.get_variable(e.name());
        assert (var != null);
        if (var instanceof AnyType) {
            rs.add((AnyType)var);
        } else if (var instanceof ResultSequence) {
            rs.concat((ResultSequence)var);
        }
        return rs;
    }

    @Override
    public Object visit(StringLiteral e) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add(e.value());
        return rs;
    }

    @Override
    public Object visit(IntegerLiteral e) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add(e.value());
        return rs;
    }

    @Override
    public Object visit(DoubleLiteral e) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add(e.value());
        return rs;
    }

    @Override
    public Object visit(DecimalLiteral e) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add(e.value());
        return rs;
    }

    @Override
    public Object visit(ParExpr e) {
        return this.do_expr(e.iterator());
    }

    @Override
    public Object visit(CntxItemExpr e) {
        ResultSequence rs = ResultSequenceFactory.create_new();
        AnyType contextItem = this._dc.context_item();
        if (contextItem == null) {
            this.report_error(DynamicError.contextUndefined());
        }
        rs.add(contextItem);
        return rs;
    }

    @Override
    public Object visit(FunctionCall e) {
        ArrayList<Object> args = new ArrayList<Object>();
        Iterator i = e.iterator();
        while (i.hasNext()) {
            Expr arg = (Expr)i.next();
            args.add(arg.accept(this));
        }
        try {
            ResultSequence rs = this._dc.evaluate_function(e.name(), args);
            return rs;
        }
        catch (DynamicError err) {
            this.report_error(err);
            return null;
        }
    }

    @Override
    public Object visit(SingleType e) {
        return null;
    }

    @Override
    public Object visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return null;
    }

    @Override
    public Object visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                if (!this._dc.type_defined(e.qname()) && !this._dc.function_exists(e.qname(), 1)) {
                    this.report_error(new StaticTypeNameError("Type not defined: " + e.qname().string()));
                }
                ResultSequence arg = (ResultSequence)((Pair)this._param)._two;
                this.item_test(arg, e.qname());
                break;
            }
            case 2: {
                e.kind_test().accept(this);
            }
        }
        return null;
    }

    private ResultSequence item_test(ResultSequence rs, QName qname) {
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            AnyAtomicType aat;
            AnyType item = (AnyType)i.next();
            if (item instanceof NodeType) {
                i.remove();
                continue;
            }
            if (qname.equals(ANY_ATOMIC_TYPE) || (aat = this._dc.make_atomic(qname)).getClass().isInstance(item)) continue;
            i.remove();
        }
        return rs;
    }

    private ResultSequence kind_test(ResultSequence rs, Class kind) {
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            if (kind.isInstance(i.next())) continue;
            i.remove();
        }
        return rs;
    }

    @Override
    public Object visit(AnyKindTest e) {
        ResultSequence arg = (ResultSequence)((Pair)this._param)._two;
        return this.kind_test(arg, NodeType.class);
    }

    @Override
    public Object visit(DocumentTest e) {
        ResultSequence arg = (ResultSequence)((Pair)this._param)._two;
        int type = e.type();
        ResultSequence rs = this.kind_test(arg, DocType.class);
        if (type == 0) {
            return rs;
        }
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            DocType doc = (DocType)i.next();
            int elem_count = 0;
            ElementType elem = null;
            NodeList children = doc.node_value().getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                if (++elem_count > 1) break;
                elem = new ElementType((Element)child);
            }
            if (elem_count != 1) {
                i.remove();
                continue;
            }
            assert (elem != null);
            ResultSequence res = ResultSequenceFactory.create_new();
            res.add(elem);
            this._param = new Pair("element", res);
            res = null;
            if (type == 1) {
                res = (ResultSequence)e.elem_test().accept(this);
            } else if (type == 2) {
                res = (ResultSequence)e.schema_elem_test().accept(this);
            } else assert (false);
            if (res.size() == 1) continue;
            i.remove();
        }
        return rs;
    }

    @Override
    public Object visit(TextTest e) {
        ResultSequence arg = (ResultSequence)((Pair)this._param)._two;
        return this.kind_test(arg, TextType.class);
    }

    @Override
    public Object visit(CommentTest e) {
        ResultSequence arg = (ResultSequence)((Pair)this._param)._two;
        return this.kind_test(arg, CommentType.class);
    }

    @Override
    public Object visit(PITest e) {
        ResultSequence arg = (ResultSequence)((Pair)this._param)._two;
        String pit_arg = e.arg();
        if (pit_arg == null) {
            return this.kind_test(arg, PIType.class);
        }
        ListIterator i = arg.iterator();
        while (i.hasNext()) {
            AnyType item = (AnyType)i.next();
            if (item instanceof PIType) {
                PIType pi = (PIType)item;
                if (pit_arg.equals(pi.value().getTarget())) continue;
                i.remove();
                continue;
            }
            i.remove();
        }
        return arg;
    }

    @Override
    public Object visit(AttributeTest e) {
        QName type;
        ResultSequence rs = this.kind_test((ResultSequence)((Pair)this._param)._two, AttrType.class);
        QName name = e.name();
        if (name != null && !e.wild()) {
            ListIterator i = rs.iterator();
            while (i.hasNext()) {
                if (this.name_test((NodeType)i.next(), name, "attribute")) continue;
                i.remove();
            }
        }
        if ((type = e.type()) != null) {
            ListIterator i = rs.iterator();
            while (i.hasNext()) {
                NodeType node = (NodeType)i.next();
                if (this._dc.derives_from(node, type)) continue;
                i.remove();
            }
        }
        return rs;
    }

    @Override
    public Object visit(SchemaAttrTest e) {
        ResultSequence rs = this.kind_test((ResultSequence)((Pair)this._param)._two, AttrType.class);
        QName name = e.arg();
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            if (this.name_test((NodeType)i.next(), name, "attribute")) continue;
            i.remove();
        }
        XSTypeDefinition et = this._dc.attribute_type_definition(name);
        ListIterator i2 = rs.iterator();
        while (i2.hasNext()) {
            NodeType node = (NodeType)i2.next();
            if (this._dc.derives_from(node, et)) continue;
            i2.remove();
        }
        return rs;
    }

    @Override
    public Object visit(ElementTest e) {
        QName type;
        ResultSequence rs = this.kind_test((ResultSequence)((Pair)this._param)._two, ElementType.class);
        QName name = e.name();
        if (name != null && !e.wild()) {
            ListIterator i = rs.iterator();
            while (i.hasNext()) {
                if (this.name_test((ElementType)i.next(), name, "element")) continue;
                i.remove();
            }
        }
        if ((type = e.type()) != null) {
            ListIterator i = rs.iterator();
            while (i.hasNext()) {
                NodeType node = (NodeType)i.next();
                if (this._dc.derives_from(node, type)) {
                    XSBoolean nilled;
                    if (e.qmark() || !(nilled = (XSBoolean)node.nilled().first()).value()) continue;
                    i.remove();
                    continue;
                }
                i.remove();
            }
        }
        return rs;
    }

    @Override
    public Object visit(SchemaElemTest e) {
        ResultSequence rs = this.kind_test((ResultSequence)((Pair)this._param)._two, ElementType.class);
        QName name = e.name();
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            if (this.name_test((ElementType)i.next(), name, "element")) continue;
            i.remove();
        }
        XSTypeDefinition et = this._dc.element_type_definition(name);
        ListIterator i2 = rs.iterator();
        while (i2.hasNext()) {
            NodeType node = (NodeType)i2.next();
            if (!this._dc.derives_from(node, et)) {
                i2.remove();
                continue;
            }
            XSBoolean nilled = (XSBoolean)node.nilled().first();
            if (!nilled.value()) continue;
            i2.remove();
        }
        return rs;
    }

    private boolean predicate_truth(ResultSequence rs) {
        AnyType at;
        if (rs.size() == 1 && (at = rs.get(0)) instanceof NumericType) {
            try {
                this._g_xsint.set_int(BigInteger.valueOf(this._dc.context_position()));
                return FsEq.fs_eq_fast(at, this._g_xsint, this._dc);
            }
            catch (DynamicError err) {
                this.report_error(err);
                assert (false);
                return false;
            }
        }
        XSBoolean ret = this.effective_boolean_value(rs);
        return ret.value();
    }

    private ResultSequence do_predicate(Collection exprs) {
        FilterExpr fex;
        XPathExpr xpe;
        Expr expr;
        ResultSequence rs = ResultSequenceFactory.create_new();
        Focus focus = this._dc.focus();
        int original_cp = focus.position();
        if (exprs.size() == 1 && (expr = (Expr)exprs.iterator().next()) instanceof XPathExpr && (xpe = (XPathExpr)expr).next() == null && xpe.slashes() == 0 && xpe.expr() instanceof FilterExpr && (fex = (FilterExpr)xpe.expr()).primary() instanceof IntegerLiteral) {
            int pos = ((IntegerLiteral)fex.primary()).value().int_value().intValue();
            if (pos <= focus.last() && pos > 0) {
                if (this.fIsReverseStep) {
                    pos = focus.last() - pos + 1;
                    this.fIsReverseStep = false;
                }
                focus.set_position(pos);
                rs.add(focus.context_item());
            }
            focus.set_position(original_cp);
            return rs;
        }
        do {
            ResultSequence res;
            if (this.predicate_truth(res = this.do_expr(exprs.iterator()))) {
                rs.add(this._dc.context_item());
            }
            res.release();
        } while (focus.advance_cp());
        focus.set_position(original_cp);
        return rs;
    }

    @Override
    public Object visit(AxisStep e) {
        ResultSequence rs = (ResultSequence)e.step().accept(this);
        if (e.predicate_count() == 0) {
            return rs;
        }
        Focus original_focus = this._dc.focus();
        Iterator i = e.iterator();
        while (i.hasNext() && rs.size() != 0) {
            this._dc.set_focus(new Focus(rs));
            rs = this.do_predicate((Collection)i.next());
        }
        this._dc.set_focus(original_focus);
        return rs;
    }

    @Override
    public Object visit(FilterExpr e) {
        ResultSequence rs = (ResultSequence)e.primary().accept(this);
        if (e.predicate_count() == 0) {
            return rs;
        }
        Focus original_focus = this._dc.focus();
        Iterator i = e.iterator();
        while (i.hasNext() && rs.size() != 0) {
            this._dc.set_focus(new Focus(rs));
            rs = this.do_predicate((Collection)i.next());
        }
        this._dc.set_focus(original_focus);
        return rs;
    }

    static class Pair {
        public Object _one;
        public Object _two;

        public Pair(Object o, Object t) {
            this._one = o;
            this._two = t;
        }
    }

    static class DummyError
    extends Error {
        private static final long serialVersionUID = 3161644790881405403L;
        private int _type;

        public DummyError(int type) {
            this._type = type;
        }

        public int type() {
            return this._type;
        }
    }
}

