/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.Date;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.DateConverter;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.ContentValues;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserColumns;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;

public abstract class UserRow<TColumn extends UserColumn, TTable extends UserTable<TColumn>>
extends UserCoreRow<TColumn, TTable> {
    protected UserRow(TTable table, UserColumns<TColumn> columns, int[] columnTypes, Object[] values) {
        super(table, columns, columnTypes, values);
    }

    protected UserRow(TTable table) {
        super(table);
    }

    protected UserRow(UserRow<TColumn, TTable> userRow) {
        super(userRow);
    }

    public ContentValues toContentValues() {
        ContentValues contentValues = new ContentValues();
        for (UserColumn column : this.columns.getColumns()) {
            if (column.isPrimaryKey()) continue;
            Object value = this.values[column.getIndex()];
            String columnName = column.getName();
            if (value == null) {
                contentValues.putNull(columnName);
                continue;
            }
            this.columnToContentValue(contentValues, column, value);
        }
        return contentValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void columnToContentValue(ContentValues contentValues, TColumn column, Object value) {
        String columnName = column.getName();
        if (value instanceof Number) {
            if (value instanceof Byte) {
                this.validateValue((UserColumn)column, value, new Class[]{Byte.class, Short.class, Integer.class, Long.class});
                contentValues.put(columnName, (Byte)value);
                return;
            } else if (value instanceof Short) {
                this.validateValue((UserColumn)column, value, new Class[]{Short.class, Integer.class, Long.class});
                contentValues.put(columnName, (Short)value);
                return;
            } else if (value instanceof Integer) {
                this.validateValue((UserColumn)column, value, new Class[]{Integer.class, Long.class});
                contentValues.put(columnName, (Integer)value);
                return;
            } else if (value instanceof Long) {
                this.validateValue((UserColumn)column, value, new Class[]{Long.class, Double.class});
                contentValues.put(columnName, (Long)value);
                return;
            } else if (value instanceof Float) {
                this.validateValue((UserColumn)column, value, new Class[]{Float.class});
                contentValues.put(columnName, (Float)value);
                return;
            } else {
                if (!(value instanceof Double)) throw new GeoPackageException("Unsupported Number type: " + value.getClass().getSimpleName());
                this.validateValue((UserColumn)column, value, new Class[]{Double.class});
                contentValues.put(columnName, (Double)value);
            }
            return;
        } else if (value instanceof String) {
            this.validateValue((UserColumn)column, value, new Class[]{String.class});
            String stringValue = (String)value;
            if (column.getMax() != null && (long)stringValue.length() > column.getMax()) {
                throw new GeoPackageException("String is larger than the column max. Size: " + stringValue.length() + ", Max: " + column.getMax() + ", Column: " + columnName);
            }
            contentValues.put(columnName, stringValue);
            return;
        } else if (value instanceof byte[]) {
            this.validateValue((UserColumn)column, value, new Class[]{byte[].class});
            byte[] byteValue = (byte[])value;
            if (column.getMax() != null && (long)byteValue.length > column.getMax()) {
                throw new GeoPackageException("Byte array is larger than the column max. Size: " + byteValue.length + ", Max: " + column.getMax() + ", Column: " + columnName);
            }
            contentValues.put(columnName, byteValue);
            return;
        } else if (value instanceof Boolean) {
            this.validateValue((UserColumn)column, value, new Class[]{Boolean.class});
            Boolean booleanValue = (Boolean)value;
            short shortBoolean = booleanValue != false ? (short)1 : 0;
            contentValues.put(columnName, shortBoolean);
            return;
        } else {
            if (!(value instanceof Date)) throw new GeoPackageException("Unsupported update column value. column: " + columnName + ", value: " + value);
            this.validateValue((UserColumn)column, value, new Class[]{Date.class, String.class});
            Date dateValue = (Date)value;
            DateConverter converter = DateConverter.converter((GeoPackageDataType)column.getDataType());
            String dateString = converter.stringValue(dateValue);
            contentValues.put(columnName, dateString);
        }
    }
}

