/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.ResultSetResult;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserColumns;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserRow;
import mil.nga.geopackage.user.UserTable;

public abstract class UserResultSet<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserRow<TColumn, TTable>>
extends ResultSetResult
implements UserCoreResult<TColumn, TTable, TRow> {
    private final TTable table;
    private final UserColumns<TColumn> columns;
    private int count;

    protected UserResultSet(TTable table, ResultSet resultSet, int count) {
        this(table, table.getUserColumns(), resultSet, count);
    }

    protected UserResultSet(TTable table, String[] columns, ResultSet resultSet, int count) {
        super(resultSet);
        UserColumns userColumns = null;
        userColumns = columns != null ? table.createUserColumns(columns) : table.getUserColumns();
        this.table = table;
        this.columns = userColumns;
        this.count = count;
    }

    protected UserResultSet(TTable table, UserColumns<TColumn> columns, ResultSet resultSet, int count) {
        super(resultSet);
        this.table = table;
        this.columns = columns;
        this.count = count;
    }

    public Object getValue(TColumn column) {
        return this.getValue(this.columns.getColumnIndex(column.getName()), column.getDataType());
    }

    @Override
    public Object getValue(int index) {
        return this.getValue(index, this.columns.getColumn(index).getDataType());
    }

    public Object getValue(String columnName) {
        return this.getValue(this.columns.getColumnIndex(columnName));
    }

    public long getId() {
        long id = -1L;
        UserColumn pkColumn = this.columns.getPkColumn();
        if (pkColumn == null) {
            StringBuilder error = new StringBuilder("No primary key column in ");
            if (this.columns.isCustom()) {
                error.append("custom specified table columns. ");
            }
            error.append("table: " + this.columns.getTableName());
            if (this.columns.isCustom()) {
                error.append(", columns: " + this.columns.getColumnNames());
            }
            throw new GeoPackageException(error.toString());
        }
        Object objectValue = this.getValue(pkColumn);
        if (!(objectValue instanceof Number)) {
            throw new GeoPackageException("Primary Key value was not a number. table: " + this.columns.getTableName() + ", index: " + pkColumn.getIndex() + ", name: " + pkColumn.getName() + ", value: " + objectValue);
        }
        id = ((Number)objectValue).longValue();
        return id;
    }

    public TTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.table.getTableName();
    }

    public UserColumns<TColumn> getColumns() {
        return this.columns;
    }

    public TRow getRow() {
        int[] columnTypes = new int[this.columns.columnCount()];
        Object[] values = new Object[this.columns.columnCount()];
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            for (int index = 0; index < this.columns.columnCount(); ++index) {
                int columnType;
                Object value;
                UserColumn column = this.columns.getColumn(index);
                values[index] = value = this.getValue(column);
                if (value == null) {
                    columnType = 0;
                } else {
                    int metadataColumnType = metaData.getColumnType(this.resultIndexToResultSetIndex(index));
                    columnType = UserResultSet.resultSetTypeToSqlLite(metadataColumnType);
                }
                columnTypes[index] = columnType;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve the row", (Throwable)e);
        }
        UserRow row = (UserRow)this.getRow(columnTypes, values);
        return (TRow)((Object)row);
    }

    public int getCount() {
        return this.count;
    }
}

