/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.sql.Connection;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.SQLUtils;
import mil.nga.geopackage.user.ContentValues;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserConnection;
import mil.nga.geopackage.user.UserCoreDao;
import mil.nga.geopackage.user.UserResultSet;
import mil.nga.geopackage.user.UserRow;
import mil.nga.geopackage.user.UserTable;

public abstract class UserDao<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserRow<TColumn, TTable>, TResult extends UserResultSet<TColumn, TTable, TRow>>
extends UserCoreDao<TColumn, TTable, TRow, TResult> {
    private final Connection connection;
    private Boolean autoCommit = null;

    protected UserDao(String database, GeoPackageConnection db, UserConnection<TColumn, TTable, TRow, TResult> userDb, TTable table) {
        super(database, (GeoPackageCoreConnection)db, userDb, table);
        this.connection = db.getConnection();
        userDb.setTable(table);
    }

    public GeoPackageConnection getDb() {
        return (GeoPackageConnection)super.getDb();
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected TResult prepareResult(TResult result) {
        return result;
    }

    public void beginTransaction() {
        if (this.autoCommit != null) {
            throw new GeoPackageException("Failed to begin transaction, previous transaction was not ended");
        }
        this.autoCommit = SQLUtils.beginTransaction(this.connection);
    }

    public void endTransaction(boolean successful) {
        SQLUtils.endTransaction(this.connection, successful, this.autoCommit);
        this.autoCommit = null;
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to commit connection", (Throwable)e);
        }
    }

    public boolean inTransaction() {
        return this.autoCommit != null;
    }

    public int update(TRow row) {
        ContentValues contentValues = ((UserRow)((Object)row)).toContentValues();
        int updated = 0;
        if (contentValues.size() > 0) {
            updated = SQLUtils.update(this.connection, this.getTableName(), contentValues, this.getPkWhere(row.getId()), this.getPkWhereArgs(row.getId()));
        }
        return updated;
    }

    public int update(ContentValues values, String whereClause, String[] whereArgs) {
        return SQLUtils.update(this.connection, this.getTableName(), values, whereClause, whereArgs);
    }

    public long insert(TRow row) {
        long id = SQLUtils.insertOrThrow(this.connection, this.getTableName(), ((UserRow)((Object)row)).toContentValues());
        if (row.hasIdColumn()) {
            row.setId(id);
        }
        return id;
    }

    public long insert(ContentValues values) {
        return SQLUtils.insert(this.connection, this.getTableName(), values);
    }

    public long insertOrThrow(ContentValues values) {
        return SQLUtils.insertOrThrow(this.connection, this.getTableName(), values);
    }
}

