/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features.custom;

import com.j256.ormlite.dao.CloseableIterator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.property.GeoPackageJavaProperties;
import mil.nga.geopackage.tiles.features.CustomFeaturesTile;

public class NumberFeaturesTile
implements CustomFeaturesTile {
    protected int textSize = GeoPackageJavaProperties.getIntegerProperty("geopackage.number_features_tile.text", "size");
    protected String textFont = GeoPackageJavaProperties.getProperty("geopackage.number_features_tile.text", "font");
    protected Color textColor = GeoPackageJavaProperties.getColorProperty("geopackage.number_features_tile.text", "color");
    protected float circleStrokeWidth;
    protected Color circleColor;
    protected Color circleFillColor;
    protected float tileBorderStrokeWidth;
    protected Color tileBorderColor;
    protected Color tileFillColor;
    private float circlePaddingPercentage;
    private boolean drawUnindexedTiles;

    public NumberFeaturesTile() {
        if (GeoPackageJavaProperties.getBooleanProperty("geopackage.number_features_tile.circle_draw")) {
            this.circleStrokeWidth = GeoPackageJavaProperties.getFloatProperty("geopackage.number_features_tile.circle_draw", "stroke_width");
            this.circleColor = GeoPackageJavaProperties.getColorProperty("geopackage.number_features_tile.circle_draw", "color");
        }
        if (GeoPackageJavaProperties.getBooleanProperty("geopackage.number_features_tile.circle_fill")) {
            this.circleFillColor = GeoPackageJavaProperties.getColorProperty("geopackage.number_features_tile.circle_fill", "color");
        }
        if (GeoPackageJavaProperties.getBooleanProperty("geopackage.number_features_tile.tile_border")) {
            this.tileBorderStrokeWidth = GeoPackageJavaProperties.getFloatProperty("geopackage.number_features_tile.tile_border", "stroke_width");
            this.tileBorderColor = GeoPackageJavaProperties.getColorProperty("geopackage.number_features_tile.tile_border", "color");
        }
        if (GeoPackageJavaProperties.getBooleanProperty("geopackage.number_features_tile.tile_fill")) {
            this.tileFillColor = GeoPackageJavaProperties.getColorProperty("geopackage.number_features_tile.tile_fill", "color");
        }
        this.circlePaddingPercentage = GeoPackageJavaProperties.getFloatProperty("geopackage.number_features_tile", "circle_padding_percentage");
        this.drawUnindexedTiles = GeoPackageJavaProperties.getBooleanProperty("geopackage.number_features_tile", "tile_unindexed_draw");
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public float getCircleStrokeWidth() {
        return this.circleStrokeWidth;
    }

    public void setCircleStrokeWidth(float circleStrokeWidth) {
        this.circleStrokeWidth = circleStrokeWidth;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getCircleFillColor() {
        return this.circleFillColor;
    }

    public void setCircleFillColor(Color circleFillColor) {
        this.circleFillColor = circleFillColor;
    }

    public float getCirclePaddingPercentage() {
        return this.circlePaddingPercentage;
    }

    public void setCirclePaddingPercentage(float circlePaddingPercentage) {
        if ((double)circlePaddingPercentage < 0.0 || (double)circlePaddingPercentage > 1.0) {
            throw new GeoPackageException("Circle padding percentage must be between 0.0 and 1.0: " + circlePaddingPercentage);
        }
        this.circlePaddingPercentage = circlePaddingPercentage;
    }

    public float getTileBorderStrokeWidth() {
        return this.tileBorderStrokeWidth;
    }

    public void setTileBorderStrokeWidth(float tileBorderStrokeWidth) {
        this.tileBorderStrokeWidth = tileBorderStrokeWidth;
    }

    public Color getTileBorderColor() {
        return this.tileBorderColor;
    }

    public void setTileBorderColor(Color tileBorderColor) {
        this.tileBorderColor = tileBorderColor;
    }

    public Color getTileFillColor() {
        return this.tileFillColor;
    }

    public void setTileFillColor(Color tileFillColor) {
        this.tileFillColor = tileFillColor;
    }

    public boolean isDrawUnindexedTiles() {
        return this.drawUnindexedTiles;
    }

    public void setDrawUnindexedTiles(boolean drawUnindexedTiles) {
        this.drawUnindexedTiles = drawUnindexedTiles;
    }

    @Override
    public BufferedImage drawTile(int tileWidth, int tileHeight, long tileFeatureCount, CloseableIterator<GeometryIndex> geometryIndexResults) {
        String featureText = String.valueOf(tileFeatureCount);
        BufferedImage image = this.drawTile(tileWidth, tileHeight, featureText);
        return image;
    }

    @Override
    public BufferedImage drawUnindexedTile(int tileWidth, int tileHeight, long totalFeatureCount, FeatureResultSet allFeatureResults) {
        BufferedImage image = null;
        if (this.drawUnindexedTiles) {
            image = this.drawTile(tileWidth, tileHeight, "?");
        }
        return image;
    }

    private BufferedImage drawTile(int tileWidth, int tileHeight, String text) {
        BufferedImage image = new BufferedImage(tileWidth, tileHeight, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.tileFillColor != null) {
            graphics.setColor(this.tileFillColor);
            graphics.fillRect(0, 0, tileWidth, tileHeight);
        }
        if (this.tileBorderColor != null) {
            graphics.setColor(this.tileBorderColor);
            graphics.setStroke(new BasicStroke(this.tileBorderStrokeWidth));
            graphics.drawRect(0, 0, tileWidth, tileHeight);
        }
        graphics.setFont(new Font(this.textFont, 0, this.textSize));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(text);
        int textHeight = fontMetrics.getAscent();
        int centerX = (int)((float)image.getWidth() / 2.0f);
        int centerY = (int)((float)image.getHeight() / 2.0f);
        if (this.circleColor != null || this.circleFillColor != null) {
            int diameter = Math.max(textWidth, textHeight);
            float radius = (float)diameter / 2.0f;
            int paddedDiameter = Math.round((radius += (float)diameter * this.circlePaddingPercentage) * 2.0f);
            int circleX = Math.round((float)centerX - radius);
            int circleY = Math.round((float)centerY - radius);
            if (this.circleFillColor != null) {
                graphics.setColor(this.circleFillColor);
                graphics.setStroke(new BasicStroke(this.circleStrokeWidth));
                graphics.fillOval(circleX, circleY, paddedDiameter, paddedDiameter);
            }
            if (this.circleColor != null) {
                graphics.setColor(this.circleColor);
                graphics.setStroke(new BasicStroke(this.circleStrokeWidth));
                graphics.drawOval(circleX, circleY, paddedDiameter, paddedDiameter);
            }
        }
        float textX = (float)centerX - (float)textWidth / 2.0f;
        float textY = (float)centerY + (float)textHeight / 2.0f;
        graphics.setColor(this.textColor);
        graphics.drawString(text, textX, textY);
        return image;
    }
}

