/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.extension.link.FeatureTileTableLinker;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGenerator;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.features.FeatureTiles;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;

public class FeatureTileGenerator
extends TileGenerator {
    private final FeatureTiles featureTiles;
    private boolean linkTables = true;

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int minZoom, int maxZoom, BoundingBox boundingBox, Projection projection) {
        this(geoPackage, tableName, featureTiles, geoPackage, minZoom, maxZoom, boundingBox, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int minZoom, int maxZoom, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, minZoom, maxZoom, FeatureTileGenerator.getBoundingBox(featureGeoPackage, featureTiles, boundingBox, projection), projection);
        this.featureTiles = featureTiles;
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int minZoom, int maxZoom, Projection projection) {
        this(geoPackage, tableName, featureTiles, minZoom, maxZoom, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int minZoom, int maxZoom, Projection projection) {
        this(geoPackage, tableName, featureTiles, featureGeoPackage, minZoom, maxZoom, null, projection);
    }

    private static BoundingBox getBoundingBox(GeoPackage geoPackage, FeatureTiles featureTiles, BoundingBox boundingBox, Projection projection) {
        boolean manualQuery;
        String tableName = featureTiles.getFeatureDao().getTableName();
        BoundingBox featureBoundingBox = geoPackage.getBoundingBox(projection, tableName, manualQuery = boundingBox == null);
        if (featureBoundingBox != null) {
            boundingBox = boundingBox == null ? featureBoundingBox : boundingBox.overlap(featureBoundingBox);
        }
        if (boundingBox != null) {
            boundingBox = featureTiles.expandBoundingBox(boundingBox, projection);
        }
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(int zoom) {
        ProjectionTransform projectionToWebMercator = this.projection.getTransformation(3857L);
        BoundingBox webMercatorBoundingBox = this.boundingBox.transform(projectionToWebMercator);
        TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)webMercatorBoundingBox, (int)zoom);
        BoundingBox tileBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)tileGrid.getMinX(), (long)tileGrid.getMinY(), (int)zoom);
        BoundingBox expandedBoundingBox = this.featureTiles.expandBoundingBox(webMercatorBoundingBox, tileBoundingBox);
        BoundingBox zoomBoundingBox = expandedBoundingBox.transform(projectionToWebMercator.getInverseTransformation());
        return zoomBoundingBox;
    }

    public boolean isLinkTables() {
        return this.linkTables;
    }

    public void setLinkTables(boolean linkTables) {
        this.linkTables = linkTables;
    }

    @Override
    protected void preTileGeneration() {
        GeoPackage geoPackage = this.getGeoPackage();
        String featureTable = this.featureTiles.getFeatureDao().getTableName();
        String tileTable = this.getTableName();
        if (this.linkTables && geoPackage.isFeatureTable(featureTable) && geoPackage.isTileTable(tileTable)) {
            FeatureTileTableLinker linker = new FeatureTileTableLinker(geoPackage);
            linker.link(featureTable, tileTable);
        }
    }

    @Override
    protected byte[] createTile(int z, long x, long y) {
        byte[] tileData = this.featureTiles.drawTileBytes((int)x, (int)y, z);
        return tileData;
    }
}

