/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.features.DefaultFeatureTiles;
import mil.nga.geopackage.tiles.features.FeatureTiles;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionFactory;

public class FeaturePreview {
    private final GeoPackage geoPackage;
    private final FeatureTiles featureTiles;
    private boolean manual = false;
    private double bufferPercentage = 0.0;
    private Set<String> columns = new LinkedHashSet<String>();
    private String where;
    private String[] whereArgs = null;
    private Integer limit = null;

    public FeaturePreview(GeoPackage geoPackage, String featureTable) {
        this(geoPackage, geoPackage.getFeatureDao(featureTable));
    }

    public FeaturePreview(GeoPackage geoPackage, FeatureDao featureDao) {
        this(geoPackage, new DefaultFeatureTiles(geoPackage, featureDao));
    }

    public FeaturePreview(GeoPackage geoPackage, FeatureTiles featureTiles) {
        this.geoPackage = geoPackage;
        this.featureTiles = featureTiles;
        FeatureDao featureDao = featureTiles.getFeatureDao();
        this.columns.add(featureDao.getIdColumnName());
        this.columns.add(featureDao.getGeometryColumnName());
        this.where = CoreSQLUtils.quoteWrap((String)featureDao.getGeometryColumnName()) + " IS NOT NULL";
    }

    public GeoPackage getGeoPackage() {
        return this.geoPackage;
    }

    public FeatureTiles getFeatureTiles() {
        return this.featureTiles;
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    public double getBufferPercentage() {
        return this.bufferPercentage;
    }

    public void setBufferPercentage(double bufferPercentage) {
        if (bufferPercentage < 0.0 || bufferPercentage >= 0.5) {
            throw new GeoPackageException("Buffer percentage must be in the range: 0.0 <= bufferPercentage < 0.5. invalid value: " + bufferPercentage);
        }
        this.bufferPercentage = bufferPercentage;
    }

    public Set<String> getColumns() {
        return Collections.unmodifiableSet(this.columns);
    }

    public void addColumns(Collection<String> columns) {
        this.columns.addAll(columns);
    }

    public void addColumns(String[] columns) {
        for (String column : columns) {
            this.addColumn(column);
        }
    }

    public void addColumn(String column) {
        this.columns.add(column);
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void appendWhere(String where) {
        this.where = (this.where != null ? this.where + " AND " : "") + where;
    }

    public String[] getWhereArgs() {
        return this.whereArgs;
    }

    public void setWhereArgs(String[] whereArgs) {
        this.whereArgs = whereArgs;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public BufferedImage draw() {
        BufferedImage image = null;
        FeatureDao featureDao = this.featureTiles.getFeatureDao();
        String table = featureDao.getTableName();
        Projection webMercator = ProjectionFactory.getProjection((long)3857L);
        BoundingBox boundingBox = this.geoPackage.getFeatureBoundingBox(webMercator, table, false);
        if (boundingBox == null) {
            boundingBox = this.geoPackage.getContentsBoundingBox(webMercator, table);
        }
        if (boundingBox == null && this.manual) {
            boundingBox = this.geoPackage.getFeatureBoundingBox(webMercator, table, this.manual);
        }
        if (boundingBox != null) {
            boundingBox = TileBoundingBoxUtils.boundWebMercatorBoundingBox((BoundingBox)boundingBox);
            BoundingBox expandedBoundingBox = boundingBox.squareExpand(this.bufferPercentage);
            expandedBoundingBox = TileBoundingBoxUtils.boundWebMercatorBoundingBox((BoundingBox)expandedBoundingBox);
            int zoom = TileBoundingBoxUtils.getZoomLevel((BoundingBox)expandedBoundingBox);
            FeatureResultSet results = (FeatureResultSet)featureDao.query(this.columns.toArray(new String[0]), this.where, this.whereArgs, null, null, null, this.limit != null ? this.limit.toString() : null);
            image = this.featureTiles.drawTile(zoom, expandedBoundingBox, results);
        }
        return image;
    }
}

