/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import mil.nga.geopackage.extension.style.StyleRow;
import mil.nga.geopackage.tiles.features.FeatureDrawType;
import mil.nga.geopackage.tiles.features.FeaturePaint;
import mil.nga.geopackage.tiles.features.Paint;

public class FeaturePaintCache {
    public static final int DEFAULT_STYLE_PAINT_CACHE_SIZE = 100;
    private final Map<Long, FeaturePaint> paintCache;
    private int cacheSize;

    public FeaturePaintCache() {
        this(100);
    }

    public FeaturePaintCache(int size) {
        this.cacheSize = size;
        this.paintCache = new LinkedHashMap<Long, FeaturePaint>(size, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, FeaturePaint> eldest) {
                return this.size() > FeaturePaintCache.this.cacheSize;
            }
        };
    }

    public void clear() {
        this.paintCache.clear();
    }

    public void resize(int maxSize) {
        this.cacheSize = maxSize;
        if (this.paintCache.size() > maxSize) {
            int count = 0;
            Iterator<Long> rowIds = this.paintCache.keySet().iterator();
            while (rowIds.hasNext()) {
                rowIds.next();
                if (++count <= maxSize) continue;
                rowIds.remove();
            }
        }
    }

    public FeaturePaint getFeaturePaint(StyleRow styleRow) {
        return this.getFeaturePaint(styleRow.getId());
    }

    public FeaturePaint getFeaturePaint(long styleId) {
        return this.paintCache.get(styleId);
    }

    public Paint getPaint(StyleRow styleRow, FeatureDrawType type) {
        return this.getPaint(styleRow.getId(), type);
    }

    public Paint getPaint(long styleId, FeatureDrawType type) {
        Paint paint = null;
        FeaturePaint featurePaint = this.getFeaturePaint(styleId);
        if (featurePaint != null) {
            paint = featurePaint.getPaint(type);
        }
        return paint;
    }

    public void setPaint(StyleRow styleRow, FeatureDrawType type, Paint paint) {
        this.setPaint(styleRow.getId(), type, paint);
    }

    public void setPaint(long styleId, FeatureDrawType type, Paint paint) {
        FeaturePaint featurePaint = this.getFeaturePaint(styleId);
        if (featurePaint == null) {
            featurePaint = new FeaturePaint();
            this.paintCache.put(styleId, featurePaint);
        }
        featurePaint.setPaint(type, paint);
    }
}

