/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import com.j256.ormlite.dao.CloseableIterator;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.style.FeatureStyle;
import mil.nga.geopackage.extension.style.IconRow;
import mil.nga.geopackage.extension.style.StyleRow;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.features.FeatureTileGraphics;
import mil.nga.geopackage.tiles.features.FeatureTiles;
import mil.nga.geopackage.tiles.features.Paint;
import mil.nga.sf.CircularString;
import mil.nga.sf.CompoundCurve;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.GeometryType;
import mil.nga.sf.LineString;
import mil.nga.sf.MultiLineString;
import mil.nga.sf.MultiPoint;
import mil.nga.sf.MultiPolygon;
import mil.nga.sf.Point;
import mil.nga.sf.Polygon;
import mil.nga.sf.PolyhedralSurface;
import mil.nga.sf.TIN;
import mil.nga.sf.Triangle;
import mil.nga.sf.proj.ProjectionTransform;

public class DefaultFeatureTiles
extends FeatureTiles {
    private static final Logger log = Logger.getLogger(DefaultFeatureTiles.class.getName());
    public static final int DEFAULT_GEOMETRY_CACHE_SIZE = 1000;
    protected int geometryCacheSize = 1000;
    protected final Map<Long, GeoPackageGeometryData> geometryCache = new LinkedHashMap<Long, GeoPackageGeometryData>(this.geometryCacheSize, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, GeoPackageGeometryData> eldest) {
            return this.size() > DefaultFeatureTiles.this.geometryCacheSize;
        }
    };
    protected boolean cacheGeometries = true;

    public DefaultFeatureTiles(FeatureDao featureDao) {
        super(featureDao);
    }

    public DefaultFeatureTiles(FeatureDao featureDao, float scale) {
        super(featureDao, scale);
    }

    public DefaultFeatureTiles(FeatureDao featureDao, int width, int height) {
        super(featureDao, width, height);
    }

    public DefaultFeatureTiles(GeoPackage geoPackage, FeatureDao featureDao) {
        super(geoPackage, featureDao);
    }

    public DefaultFeatureTiles(GeoPackage geoPackage, FeatureDao featureDao, float scale) {
        super(geoPackage, featureDao, scale);
    }

    public DefaultFeatureTiles(GeoPackage geoPackage, FeatureDao featureDao, int width, int height) {
        super(geoPackage, featureDao, width, height);
    }

    public DefaultFeatureTiles(GeoPackage geoPackage, FeatureDao featureDao, float scale, int width, int height) {
        super(geoPackage, featureDao, scale, width, height);
    }

    public boolean isCacheGeometries() {
        return this.cacheGeometries;
    }

    public void setCacheGeometries(boolean cacheGeometries) {
        this.cacheGeometries = cacheGeometries;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.clearGeometryCache();
    }

    public void clearGeometryCache() {
        this.geometryCache.clear();
    }

    public void setGeometryCacheSize(int size) {
        this.geometryCacheSize = size;
        if (this.geometryCache.size() > size) {
            int count = 0;
            Iterator<Long> rowIds = this.geometryCache.keySet().iterator();
            while (rowIds.hasNext()) {
                rowIds.next();
                if (++count <= size) continue;
                rowIds.remove();
            }
        }
    }

    @Override
    public BufferedImage drawTile(int zoom, BoundingBox boundingBox, CloseableIterator<GeometryIndex> results) {
        FeatureTileGraphics graphics = new FeatureTileGraphics(this.tileWidth, this.tileHeight);
        ProjectionTransform webMercatorTransform = this.getWebMercatorTransform();
        BoundingBox expandedBoundingBox = this.expandBoundingBox(boundingBox);
        boolean drawn = false;
        while (results.hasNext()) {
            GeometryIndex geometryIndex = (GeometryIndex)results.next();
            FeatureRow featureRow = this.getFeatureIndex().getFeatureRow(geometryIndex);
            if (!this.drawFeature(zoom, boundingBox, expandedBoundingBox, webMercatorTransform, graphics, featureRow)) continue;
            drawn = true;
        }
        try {
            results.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to close geometry index results", e);
        }
        BufferedImage image = null;
        if (drawn) {
            image = graphics.createImage();
            image = this.checkIfDrawn(image);
        } else {
            graphics.dispose();
        }
        return image;
    }

    @Override
    public BufferedImage drawTile(int zoom, BoundingBox boundingBox, FeatureResultSet resultSet) {
        FeatureTileGraphics graphics = new FeatureTileGraphics(this.tileWidth, this.tileHeight);
        ProjectionTransform webMercatorTransform = this.getWebMercatorTransform();
        BoundingBox expandedBoundingBox = this.expandBoundingBox(boundingBox);
        boolean drawn = false;
        while (resultSet.moveToNext()) {
            FeatureRow row = (FeatureRow)resultSet.getRow();
            if (!this.drawFeature(zoom, boundingBox, expandedBoundingBox, webMercatorTransform, graphics, row)) continue;
            drawn = true;
        }
        resultSet.close();
        BufferedImage image = null;
        if (drawn) {
            image = graphics.createImage();
            image = this.checkIfDrawn(image);
        } else {
            graphics.dispose();
        }
        return image;
    }

    @Override
    public BufferedImage drawTile(int zoom, BoundingBox boundingBox, List<FeatureRow> featureRow) {
        FeatureTileGraphics graphics = new FeatureTileGraphics(this.tileWidth, this.tileHeight);
        ProjectionTransform webMercatorTransform = this.getWebMercatorTransform();
        BoundingBox expandedBoundingBox = this.expandBoundingBox(boundingBox);
        boolean drawn = false;
        for (FeatureRow row : featureRow) {
            if (!this.drawFeature(zoom, boundingBox, expandedBoundingBox, webMercatorTransform, graphics, row)) continue;
            drawn = true;
        }
        BufferedImage image = null;
        if (drawn) {
            image = graphics.createImage();
            image = this.checkIfDrawn(image);
        } else {
            graphics.dispose();
        }
        return image;
    }

    private boolean drawFeature(int zoom, BoundingBox boundingBox, BoundingBox expandedBoundingBox, ProjectionTransform transform, FeatureTileGraphics graphics, FeatureRow row) {
        boolean drawn = false;
        try {
            Geometry geometry;
            GeoPackageGeometryData geomData = null;
            BoundingBox transformedBoundingBox = null;
            long rowId = -1L;
            if (this.cacheGeometries && (geomData = this.geometryCache.get(rowId = row.getId())) != null) {
                transformedBoundingBox = new BoundingBox(geomData.getEnvelope());
            }
            if (geomData == null) {
                geomData = row.getGeometry();
            }
            if (geomData != null && (geometry = geomData.getGeometry()) != null) {
                if (transformedBoundingBox == null) {
                    GeometryEnvelope envelope = geomData.getOrBuildEnvelope();
                    BoundingBox geometryBoundingBox = new BoundingBox(envelope);
                    transformedBoundingBox = geometryBoundingBox.transform(transform);
                    if (this.cacheGeometries) {
                        geomData.setEnvelope(transformedBoundingBox.buildEnvelope());
                    }
                }
                if (this.cacheGeometries) {
                    this.geometryCache.put(rowId, geomData);
                }
                if (expandedBoundingBox.intersects(transformedBoundingBox, true)) {
                    double simplifyTolerance = TileBoundingBoxUtils.toleranceDistance((int)zoom, (int)this.tileWidth, (int)this.tileHeight);
                    drawn = this.drawGeometry(simplifyTolerance, boundingBox, transform, graphics, row, geometry);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to draw feature in tile. Table: " + this.featureDao.getTableName(), e);
        }
        return drawn;
    }

    private boolean drawGeometry(double simplifyTolerance, BoundingBox boundingBox, ProjectionTransform transform, FeatureTileGraphics graphics, FeatureRow featureRow, Geometry geometry) {
        boolean drawn = false;
        GeometryType geometryType = geometry.getGeometryType();
        FeatureStyle featureStyle = this.getFeatureStyle(featureRow, geometryType);
        switch (geometryType) {
            case POINT: {
                Point point = (Point)geometry;
                drawn = this.drawPoint(boundingBox, transform, graphics, point, featureStyle);
                break;
            }
            case LINESTRING: {
                LineString lineString = (LineString)geometry;
                drawn = this.drawLineString(simplifyTolerance, boundingBox, transform, graphics, lineString, featureStyle);
                break;
            }
            case POLYGON: {
                Polygon polygon = (Polygon)geometry;
                drawn = this.drawPolygon(simplifyTolerance, boundingBox, transform, graphics, polygon, featureStyle);
                break;
            }
            case MULTIPOINT: {
                MultiPoint multiPoint = (MultiPoint)geometry;
                for (Point p : multiPoint.getPoints()) {
                    drawn = this.drawPoint(boundingBox, transform, graphics, p, featureStyle) || drawn;
                }
                break;
            }
            case MULTILINESTRING: {
                MultiLineString multiLineString = (MultiLineString)geometry;
                for (LineString ls : multiLineString.getLineStrings()) {
                    drawn = this.drawLineString(simplifyTolerance, boundingBox, transform, graphics, ls, featureStyle) || drawn;
                }
                break;
            }
            case MULTIPOLYGON: {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                for (Polygon p : multiPolygon.getPolygons()) {
                    drawn = this.drawPolygon(simplifyTolerance, boundingBox, transform, graphics, p, featureStyle) || drawn;
                }
                break;
            }
            case CIRCULARSTRING: {
                CircularString circularString = (CircularString)geometry;
                drawn = this.drawLineString(simplifyTolerance, boundingBox, transform, graphics, (LineString)circularString, featureStyle);
                break;
            }
            case COMPOUNDCURVE: {
                CompoundCurve compoundCurve = (CompoundCurve)geometry;
                for (LineString ls : compoundCurve.getLineStrings()) {
                    drawn = this.drawLineString(simplifyTolerance, boundingBox, transform, graphics, ls, featureStyle) || drawn;
                }
                break;
            }
            case POLYHEDRALSURFACE: {
                PolyhedralSurface polyhedralSurface = (PolyhedralSurface)geometry;
                for (Polygon p : polyhedralSurface.getPolygons()) {
                    drawn = this.drawPolygon(simplifyTolerance, boundingBox, transform, graphics, p, featureStyle) || drawn;
                }
                break;
            }
            case TIN: {
                TIN tin = (TIN)geometry;
                for (Polygon p : tin.getPolygons()) {
                    drawn = this.drawPolygon(simplifyTolerance, boundingBox, transform, graphics, p, featureStyle) || drawn;
                }
                break;
            }
            case TRIANGLE: {
                Triangle triangle = (Triangle)geometry;
                drawn = this.drawPolygon(simplifyTolerance, boundingBox, transform, graphics, (Polygon)triangle, featureStyle);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                for (Geometry g : geometryCollection.getGeometries()) {
                    drawn = this.drawGeometry(simplifyTolerance, boundingBox, transform, graphics, featureRow, g) || drawn;
                }
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported Geometry Type: " + geometry.getGeometryType().getName());
            }
        }
        return drawn;
    }

    private boolean drawLineString(double simplifyTolerance, BoundingBox boundingBox, ProjectionTransform transform, FeatureTileGraphics graphics, LineString lineString, FeatureStyle featureStyle) {
        Path2D path = this.getPath(simplifyTolerance, boundingBox, transform, lineString);
        return this.drawLine(graphics, path, featureStyle);
    }

    private boolean drawPolygon(double simplifyTolerance, BoundingBox boundingBox, ProjectionTransform transform, FeatureTileGraphics graphics, Polygon polygon, FeatureStyle featureStyle) {
        Area polygonArea = this.getArea(simplifyTolerance, boundingBox, transform, polygon);
        return this.drawPolygon(graphics, polygonArea, featureStyle);
    }

    private Path2D getPath(double simplifyTolerance, BoundingBox boundingBox, ProjectionTransform transform, LineString lineString) {
        Path2D.Double path = null;
        List<Point> lineStringPoints = this.simplifyPoints(simplifyTolerance, lineString.getPoints());
        for (Point point : lineStringPoints) {
            Point projectedPoint = transform.transform(point);
            float x = TileBoundingBoxUtils.getXPixel((long)this.tileWidth, (BoundingBox)boundingBox, (double)projectedPoint.getX());
            float y = TileBoundingBoxUtils.getYPixel((long)this.tileHeight, (BoundingBox)boundingBox, (double)projectedPoint.getY());
            if (path == null) {
                path = new Path2D.Double();
                ((Path2D)path).moveTo(x, y);
                continue;
            }
            ((Path2D)path).lineTo(x, y);
        }
        return path;
    }

    private boolean drawLine(FeatureTileGraphics graphics, Path2D line, FeatureStyle featureStyle) {
        Graphics2D lineGraphics = graphics.getLineGraphics();
        Paint paint = this.getLinePaint(featureStyle);
        lineGraphics.setColor(paint.getColor());
        lineGraphics.setStroke(paint.getStroke());
        boolean drawn = lineGraphics.hit(new Rectangle(this.tileWidth, this.tileHeight), line, true);
        if (drawn) {
            lineGraphics.draw(line);
        }
        return drawn;
    }

    private Area getArea(double simplifyTolerance, BoundingBox boundingBox, ProjectionTransform transform, Polygon polygon) {
        Area area = null;
        for (LineString ring : polygon.getRings()) {
            Path2D path = this.getPath(simplifyTolerance, boundingBox, transform, ring);
            Area ringArea = new Area(path);
            if (area == null) {
                area = ringArea;
                continue;
            }
            area.subtract(ringArea);
        }
        return area;
    }

    private boolean drawPolygon(FeatureTileGraphics graphics, Area polygon, FeatureStyle featureStyle) {
        Graphics2D polygonGraphics = graphics.getPolygonGraphics();
        Paint fillPaint = this.getPolygonFillPaint(featureStyle);
        if (fillPaint != null) {
            polygonGraphics.setColor(fillPaint.getColor());
            polygonGraphics.fill(polygon);
        }
        Paint paint = this.getPolygonPaint(featureStyle);
        polygonGraphics.setColor(paint.getColor());
        polygonGraphics.setStroke(paint.getStroke());
        boolean drawn = polygonGraphics.hit(new Rectangle(this.tileWidth, this.tileHeight), polygon, true);
        if (drawn) {
            polygonGraphics.draw(polygon);
        }
        return drawn;
    }

    private boolean drawPoint(BoundingBox boundingBox, ProjectionTransform transform, FeatureTileGraphics graphics, Point point, FeatureStyle featureStyle) {
        boolean drawn = false;
        Point projectedPoint = transform.transform(point);
        float x = TileBoundingBoxUtils.getXPixel((long)this.tileWidth, (BoundingBox)boundingBox, (double)projectedPoint.getX());
        float y = TileBoundingBoxUtils.getYPixel((long)this.tileHeight, (BoundingBox)boundingBox, (double)projectedPoint.getY());
        if (featureStyle != null && featureStyle.useIcon()) {
            IconRow iconRow = featureStyle.getIcon();
            BufferedImage icon = this.getIcon(iconRow);
            int width = icon.getWidth();
            int height = icon.getHeight();
            if (x >= (float)(0 - width) && x <= (float)(this.tileWidth + width) && y >= (float)(0 - height) && y <= (float)(this.tileHeight + height)) {
                float anchorU = (float)iconRow.getAnchorUOrDefault();
                float anchorV = (float)iconRow.getAnchorVOrDefault();
                int iconX = Math.round(x - anchorU * (float)width);
                int iconY = Math.round(y - anchorV * (float)height);
                Graphics2D iconGraphics = graphics.getIconGraphics();
                iconGraphics.drawImage((Image)icon, iconX, iconY, null);
                drawn = true;
            }
        } else if (this.pointIcon != null) {
            int width = Math.round(this.scale * (float)this.pointIcon.getWidth());
            int height = Math.round(this.scale * (float)this.pointIcon.getHeight());
            if (x >= (float)(0 - width) && x <= (float)(this.tileWidth + width) && y >= (float)(0 - height) && y <= (float)(this.tileHeight + height)) {
                int iconX = Math.round(x - this.scale * this.pointIcon.getXOffset());
                int iconY = Math.round(y - this.scale * this.pointIcon.getYOffset());
                Graphics2D iconGraphics = graphics.getIconGraphics();
                iconGraphics.drawImage(this.pointIcon.getIcon(), iconX, iconY, width, height, null);
                drawn = true;
            }
        } else {
            StyleRow styleRow;
            Float radius = null;
            if (featureStyle != null && (styleRow = featureStyle.getStyle()) != null) {
                radius = Float.valueOf(this.scale * (float)(styleRow.getWidthOrDefault() / 2.0));
            }
            if (radius == null) {
                radius = Float.valueOf(this.scale * this.pointRadius);
            }
            if (x >= 0.0f - radius.floatValue() && x <= (float)this.tileWidth + radius.floatValue() && y >= 0.0f - radius.floatValue() && y <= (float)this.tileHeight + radius.floatValue()) {
                Graphics2D pointGraphics = graphics.getPointGraphics();
                Paint pointPaint = this.getPointPaint(featureStyle);
                pointGraphics.setColor(pointPaint.getColor());
                int circleX = Math.round(x - radius.floatValue());
                int circleY = Math.round(y - radius.floatValue());
                int diameter = Math.round(radius.floatValue() * 2.0f);
                pointGraphics.fillOval(circleX, circleY, diameter, diameter);
                drawn = true;
            }
        }
        return drawn;
    }
}

