/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.io.GeoPackageIOUtils;
import mil.nga.geopackage.io.TileFormatType;
import mil.nga.geopackage.property.GeoPackageJavaProperties;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGenerator;
import mil.nga.sf.proj.Projection;

public class UrlTileGenerator
extends TileGenerator {
    private static final Logger LOGGER = Logger.getLogger(UrlTileGenerator.class.getName());
    private static final String Z_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "z");
    private static final String X_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "x");
    private static final String Y_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "y");
    private static final String MIN_LAT_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "min_lat");
    private static final String MAX_LAT_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "max_lat");
    private static final String MIN_LON_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "min_lon");
    private static final String MAX_LON_VARIABLE = GeoPackageJavaProperties.getProperty("geopackage.tile_generator.variable", "max_lon");
    private final String tileUrl;
    private final boolean urlHasXYZ;
    private final boolean urlHasBoundingBox;
    private TileFormatType tileFormat = TileFormatType.XYZ;
    private int downloadAttempts = GeoPackageJavaProperties.getIntegerProperty("geopackage.tile_generator", "downloadAttempts");

    public UrlTileGenerator(GeoPackage geoPackage, String tableName, String tileUrl, int minZoom, int maxZoom, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, minZoom, maxZoom, boundingBox, projection);
        try {
            this.tileUrl = URLDecoder.decode(tileUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GeoPackageException("Failed to decode tile url: " + tileUrl, (Throwable)e);
        }
        this.urlHasXYZ = this.hasXYZ(tileUrl);
        this.urlHasBoundingBox = this.hasBoundingBox(tileUrl);
        if (!this.urlHasXYZ && !this.urlHasBoundingBox) {
            throw new GeoPackageException("URL does not contain x,y,z or bounding box variables: " + tileUrl);
        }
    }

    public TileFormatType getTileFormat() {
        return this.tileFormat;
    }

    public void setTileFormat(TileFormatType tileFormat) {
        if (tileFormat == null) {
            this.tileFormat = TileFormatType.XYZ;
        } else {
            switch (tileFormat) {
                case XYZ: 
                case TMS: {
                    this.tileFormat = tileFormat;
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported Tile Format Type for URL Tile Generation: " + (Object)((Object)tileFormat));
                }
            }
        }
    }

    public int getDownloadAttempts() {
        return this.downloadAttempts;
    }

    public void setDownloadAttempts(int downloadAttempts) {
        this.downloadAttempts = downloadAttempts;
    }

    private boolean hasBoundingBox(String url) {
        String replacedUrl = this.replaceBoundingBox(url, this.boundingBox);
        boolean hasBoundingBox = !replacedUrl.equals(url);
        return hasBoundingBox;
    }

    private String replaceXYZ(String url, int z, long x, long y) {
        url = url.replaceAll(Z_VARIABLE, String.valueOf(z));
        url = url.replaceAll(X_VARIABLE, String.valueOf(x));
        url = url.replaceAll(Y_VARIABLE, String.valueOf(y));
        return url;
    }

    private boolean hasXYZ(String url) {
        String replacedUrl = this.replaceXYZ(url, 0, 0L, 0L);
        boolean hasXYZ = !replacedUrl.equals(url);
        return hasXYZ;
    }

    private String replaceBoundingBox(String url, int z, long x, long y) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getProjectedBoundingBox((Projection)this.projection, (long)x, (long)y, (int)z);
        url = this.replaceBoundingBox(url, boundingBox);
        return url;
    }

    private String replaceBoundingBox(String url, BoundingBox boundingBox) {
        url = url.replaceAll(MIN_LAT_VARIABLE, String.valueOf(boundingBox.getMinLatitude()));
        url = url.replaceAll(MAX_LAT_VARIABLE, String.valueOf(boundingBox.getMaxLatitude()));
        url = url.replaceAll(MIN_LON_VARIABLE, String.valueOf(boundingBox.getMinLongitude()));
        url = url.replaceAll(MAX_LON_VARIABLE, String.valueOf(boundingBox.getMaxLongitude()));
        return url;
    }

    @Override
    protected void preTileGeneration() {
    }

    @Override
    protected byte[] createTile(int z, long x, long y) {
        URL url;
        byte[] bytes = null;
        String zoomUrl = this.tileUrl;
        if (this.urlHasXYZ) {
            long yRequest = y;
            if (this.tileFormat == TileFormatType.TMS) {
                yRequest = TileBoundingBoxUtils.getYAsOppositeTileFormat((int)z, (int)((int)y));
            }
            zoomUrl = this.replaceXYZ(zoomUrl, z, x, yRequest);
        }
        if (this.urlHasBoundingBox) {
            zoomUrl = this.replaceBoundingBox(zoomUrl, z, x, y);
        }
        try {
            url = new URL(zoomUrl);
        }
        catch (MalformedURLException e) {
            throw new GeoPackageException("Failed to download tile. URL: " + zoomUrl + ", z=" + z + ", x=" + x + ", y=" + y, (Throwable)e);
        }
        int attempt = 1;
        while (true) {
            try {
                bytes = this.downloadTile(zoomUrl, url, z, x, y);
            }
            catch (Exception e) {
                if (attempt < this.downloadAttempts) {
                    LOGGER.log(Level.WARNING, "Failed to download tile after attempt " + attempt + " of " + this.downloadAttempts + ". URL: " + zoomUrl + ", z=" + z + ", x=" + x + ", y=" + y, e);
                    ++attempt;
                    continue;
                }
                throw new GeoPackageException("Failed to download tile after " + this.downloadAttempts + " attempts. URL: " + zoomUrl + ", z=" + z + ", x=" + x + ", y=" + y, (Throwable)e);
            }
            break;
        }
        return bytes;
    }

    private byte[] downloadTile(String zoomUrl, URL url, int z, long x, long y) {
        byte[] bytes = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                String redirect = connection.getHeaderField("Location");
                connection.disconnect();
                url = new URL(redirect);
                connection = (HttpURLConnection)url.openConnection();
                connection.connect();
            }
            if (connection.getResponseCode() != 200) {
                throw new GeoPackageException("Failed to download tile. URL: " + zoomUrl + ", z=" + z + ", x=" + x + ", y=" + y + ", Response Code: " + connection.getResponseCode() + ", Response Message: " + connection.getResponseMessage());
            }
            InputStream geoPackageStream = connection.getInputStream();
            bytes = GeoPackageIOUtils.streamBytes((InputStream)geoPackageStream);
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to download tile. URL: " + zoomUrl + ", z=" + z + ", x=" + x + ", y=" + y, (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return bytes;
    }
}

