/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.extension.scale.TileScaling;
import mil.nga.geopackage.extension.scale.TileTableScaling;
import mil.nga.geopackage.io.GeoPackageZoomLevelProgress;
import mil.nga.geopackage.tiles.ImageUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrix.TileMatrixKey;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileResultSet;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionConstants;
import mil.nga.sf.proj.ProjectionFactory;
import mil.nga.sf.proj.ProjectionTransform;
import org.locationtech.proj4j.units.Units;

public abstract class TileGenerator {
    private static final Logger LOGGER = Logger.getLogger(TileGenerator.class.getName());
    private final GeoPackage geoPackage;
    private final String tableName;
    private final int minZoom;
    private final int maxZoom;
    protected Projection projection;
    private Integer tileCount;
    private final Map<Integer, TileGrid> tileGrids = new HashMap<Integer, TileGrid>();
    private final Map<Integer, BoundingBox> tileBounds = new HashMap<Integer, BoundingBox>();
    protected BoundingBox boundingBox;
    private String compressFormat;
    private Float compressQuality = null;
    private GeoPackageZoomLevelProgress progress;
    private boolean xyzTiles = false;
    private BoundingBox tileGridBoundingBox;
    private long matrixHeight = 0L;
    private long matrixWidth = 0L;
    private TileScaling scaling = null;
    private boolean skipExisting = false;

    public TileGenerator(GeoPackage geoPackage, String tableName, int minZoom, int maxZoom, BoundingBox boundingBox, Projection projection) {
        geoPackage.verifyWritable();
        this.geoPackage = geoPackage;
        this.tableName = tableName;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.boundingBox = boundingBox;
        this.projection = projection;
    }

    public GeoPackage getGeoPackage() {
        return this.geoPackage;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public BoundingBox getBoundingBox(int zoom) {
        return this.boundingBox;
    }

    public void setCompressFormat(String compressFormat) {
        this.compressFormat = compressFormat;
    }

    public String getCompressFormat() {
        return this.compressFormat;
    }

    public void setCompressQuality(Float compressQuality) {
        if (compressQuality != null && ((double)compressQuality.floatValue() < 0.0 || (double)compressQuality.floatValue() > 1.0)) {
            throw new GeoPackageException("Compress quality must be between 0.0 and 1.0, not: " + compressQuality);
        }
        this.compressQuality = compressQuality;
    }

    public Float getCompressQuality() {
        return this.compressQuality;
    }

    public void setProgress(GeoPackageZoomLevelProgress progress) {
        this.progress = progress;
    }

    public GeoPackageZoomLevelProgress getProgress() {
        return this.progress;
    }

    public void setXYZTiles(boolean xyzTiles) {
        this.xyzTiles = xyzTiles;
    }

    public boolean isXYZTiles() {
        return this.xyzTiles;
    }

    public TileScaling getScaling() {
        return this.scaling;
    }

    public void setScaling(TileScaling scaling) {
        this.scaling = scaling;
    }

    public boolean isSkipExisting() {
        return this.skipExisting;
    }

    public void setSkipExisting(boolean skipExisting) {
        this.skipExisting = skipExisting;
    }

    public int getTileCount() {
        if (this.tileCount == null) {
            int count = 0;
            boolean degrees = this.projection.isUnit(Units.DEGREES);
            ProjectionTransform transformToWebMercator = null;
            if (!degrees) {
                transformToWebMercator = this.projection.getTransformation(3857L);
            }
            for (int zoom = this.minZoom; zoom <= this.maxZoom; ++zoom) {
                BoundingBox expandedBoundingBox = this.getBoundingBox(zoom);
                TileGrid tileGrid = null;
                tileGrid = degrees ? TileBoundingBoxUtils.getTileGridWGS84((BoundingBox)expandedBoundingBox, (int)zoom) : TileBoundingBoxUtils.getTileGrid((BoundingBox)expandedBoundingBox.transform(transformToWebMercator), (int)zoom);
                count = (int)((long)count + tileGrid.count());
                this.tileGrids.put(zoom, tileGrid);
                this.tileBounds.put(zoom, expandedBoundingBox);
            }
            this.tileCount = count;
        }
        return this.tileCount;
    }

    public int generateTiles() throws SQLException, IOException {
        int totalCount = this.getTileCount();
        if (this.progress != null) {
            this.progress.setMax(totalCount);
            for (Map.Entry<Integer, TileGrid> zoomGrid : this.tileGrids.entrySet()) {
                this.progress.setZoomLevelMax(zoomGrid.getKey(), (int)zoomGrid.getValue().count());
            }
        }
        int count = 0;
        boolean update = false;
        BoundingBox minZoomBoundingBox = this.tileBounds.get(this.minZoom);
        this.adjustBounds(minZoomBoundingBox, this.minZoom);
        TileMatrixSetDao tileMatrixSetDao = this.geoPackage.getTileMatrixSetDao();
        TileMatrixSet tileMatrixSet = null;
        if (!tileMatrixSetDao.isTableExists() || !tileMatrixSetDao.idExists((Object)this.tableName)) {
            SpatialReferenceSystemDao srsDao = this.geoPackage.getSpatialReferenceSystemDao();
            SpatialReferenceSystem srs = srsDao.getOrCreateCode(this.projection.getAuthority(), Long.parseLong(this.projection.getCode()));
            tileMatrixSet = this.geoPackage.createTileTableWithMetadata(this.tableName, this.boundingBox, srs.getSrsId(), this.tileGridBoundingBox, srs.getSrsId());
        } else {
            update = true;
            tileMatrixSet = (TileMatrixSet)tileMatrixSetDao.queryForId((Object)this.tableName);
            this.updateTileBounds(tileMatrixSet);
        }
        this.preTileGeneration();
        if (this.scaling != null) {
            TileTableScaling tileTableScaling = new TileTableScaling((GeoPackageCore)this.geoPackage, tileMatrixSet);
            tileTableScaling.createOrUpdate(this.scaling);
        }
        try {
            Contents contents = tileMatrixSet.getContents();
            TileMatrixDao tileMatrixDao = this.geoPackage.getTileMatrixDao();
            TileDao tileDao = this.geoPackage.getTileDao(tileMatrixSet);
            for (int zoom = this.minZoom; zoom <= this.maxZoom && (this.progress == null || this.progress.isActive()); ++zoom) {
                TileGrid localTileGrid = null;
                if (this.xyzTiles) {
                    this.matrixHeight = this.matrixWidth = (long)TileBoundingBoxUtils.tilesPerSide((int)zoom);
                } else {
                    BoundingBox zoomBoundingBox = this.tileBounds.get(zoom);
                    localTileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)this.tileGridBoundingBox, (long)this.matrixWidth, (long)this.matrixHeight, (BoundingBox)zoomBoundingBox);
                }
                TileGrid tileGrid = this.tileGrids.get(zoom);
                count += this.generateTiles(tileMatrixDao, tileDao, contents, zoom, tileGrid, localTileGrid, this.matrixWidth, this.matrixHeight, update);
                if (this.xyzTiles) continue;
                this.matrixWidth *= 2L;
                this.matrixHeight *= 2L;
            }
            if (this.progress != null && !this.progress.isActive() && this.progress.cleanupOnCancel()) {
                this.geoPackage.deleteTableQuietly(this.tableName);
                count = 0;
            } else {
                contents.setLastChange(new Date());
                ContentsDao contentsDao = this.geoPackage.getContentsDao();
                contentsDao.update((Object)contents);
            }
        }
        catch (RuntimeException e) {
            this.geoPackage.deleteTableQuietly(this.tableName);
            throw e;
        }
        catch (SQLException e) {
            this.geoPackage.deleteTableQuietly(this.tableName);
            throw e;
        }
        catch (IOException e) {
            this.geoPackage.deleteTableQuietly(this.tableName);
            throw e;
        }
        return count;
    }

    private void adjustBounds(BoundingBox boundingBox, int zoom) {
        if (this.xyzTiles) {
            this.adjustXYZBounds();
        } else if (this.projection.isUnit(Units.DEGREES)) {
            this.adjustGeoPackageBoundsWGS84(boundingBox, zoom);
        } else {
            this.adjustGeoPackageBounds(boundingBox, zoom);
        }
    }

    private void adjustXYZBounds() {
        BoundingBox standardWgs84Box = new BoundingBox(-ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, -85.05112877980659, ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, 85.0511287798066);
        ProjectionTransform wgs84ToWebMercatorTransform = ProjectionFactory.getProjection((long)4326L).getTransformation(3857L);
        this.tileGridBoundingBox = standardWgs84Box.transform(wgs84ToWebMercatorTransform);
    }

    private void adjustGeoPackageBoundsWGS84(BoundingBox boundingBox, int zoom) {
        TileGrid tileGrid = TileBoundingBoxUtils.getTileGridWGS84((BoundingBox)boundingBox, (int)zoom);
        this.tileGridBoundingBox = TileBoundingBoxUtils.getWGS84BoundingBox((TileGrid)tileGrid, (int)zoom);
        this.matrixWidth = tileGrid.getMaxX() + 1L - tileGrid.getMinX();
        this.matrixHeight = tileGrid.getMaxY() + 1L - tileGrid.getMinY();
    }

    private void adjustGeoPackageBounds(BoundingBox requestWebMercatorBoundingBox, int zoom) {
        TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)requestWebMercatorBoundingBox, (int)zoom);
        this.tileGridBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((TileGrid)tileGrid, (int)zoom);
        this.matrixWidth = tileGrid.getMaxX() + 1L - tileGrid.getMinX();
        this.matrixHeight = tileGrid.getMaxY() + 1L - tileGrid.getMinY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTileBounds(TileMatrixSet tileMatrixSet) throws SQLException {
        Projection tileMatrixProjection;
        TileDao tileDao = this.geoPackage.getTileDao(tileMatrixSet);
        if (tileDao.isXYZTiles()) {
            if (!this.xyzTiles) {
                this.xyzTiles = true;
                this.adjustXYZBounds();
            }
        } else if (this.xyzTiles) {
            throw new GeoPackageException("Can not add XYZ formatted tiles to " + this.tableName + " which already contains GeoPackage formatted tiles");
        }
        if (!(tileMatrixProjection = tileMatrixSet.getSrs().getProjection()).equals((Object)this.projection)) {
            throw new GeoPackageException("Can not update tiles projected at " + tileMatrixProjection.getCode() + " with tiles projected at " + this.projection.getCode());
        }
        Contents contents = tileMatrixSet.getContents();
        BoundingBox previousContentsBoundingBox = contents.getBoundingBox();
        if (previousContentsBoundingBox != null) {
            ProjectionTransform transformProjectionToContents = this.projection.getTransformation(contents.getProjection());
            BoundingBox contentsBoundingBox = this.boundingBox;
            if (!transformProjectionToContents.isSameProjection()) {
                contentsBoundingBox = contentsBoundingBox.transform(transformProjectionToContents);
            }
            if (!(contentsBoundingBox = contentsBoundingBox.union(previousContentsBoundingBox)).equals((Object)previousContentsBoundingBox)) {
                contents.setBoundingBox(contentsBoundingBox);
                ContentsDao contentsDao = this.geoPackage.getContentsDao();
                contentsDao.update((Object)contents);
            }
        }
        if (!this.xyzTiles) {
            BoundingBox previousTileMatrixSetBoundingBox = tileMatrixSet.getBoundingBox();
            ProjectionTransform transformProjectionToTileMatrixSet = this.projection.getTransformation(tileMatrixProjection);
            boolean sameProjection = transformProjectionToTileMatrixSet.isSameProjection();
            BoundingBox updateBoundingBox = this.tileBounds.get(this.minZoom);
            if (!sameProjection) {
                updateBoundingBox = updateBoundingBox.transform(transformProjectionToTileMatrixSet);
            }
            int minNewOrUpdateZoom = Math.min(this.minZoom, (int)tileDao.getMinZoom());
            this.adjustBounds(updateBoundingBox, minNewOrUpdateZoom);
            BoundingBox updateTileGridBoundingBox = this.tileGridBoundingBox;
            if (!sameProjection) {
                updateTileGridBoundingBox = updateTileGridBoundingBox.transform(transformProjectionToTileMatrixSet);
            }
            if (!previousTileMatrixSetBoundingBox.equals((Object)updateTileGridBoundingBox)) {
                updateTileGridBoundingBox = updateTileGridBoundingBox.union(previousTileMatrixSetBoundingBox);
                this.adjustBounds(updateTileGridBoundingBox, minNewOrUpdateZoom);
                updateTileGridBoundingBox = this.tileGridBoundingBox;
                if (!sameProjection) {
                    updateTileGridBoundingBox = updateTileGridBoundingBox.transform(transformProjectionToTileMatrixSet);
                }
                tileMatrixSet.setBoundingBox(updateTileGridBoundingBox);
                TileMatrixSetDao tileMatrixSetDao = this.geoPackage.getTileMatrixSetDao();
                tileMatrixSetDao.update((Object)tileMatrixSet);
            }
            TileMatrixDao tileMatrixDao = this.geoPackage.getTileMatrixDao();
            for (long zoom = tileDao.getMinZoom(); zoom <= tileDao.getMaxZoom(); ++zoom) {
                TileMatrix tileMatrix = tileDao.getTileMatrix(zoom);
                if (tileMatrix == null) continue;
                long adjustment = (long)Math.pow(2.0, zoom - (long)minNewOrUpdateZoom);
                long zoomMatrixWidth = this.matrixWidth * adjustment;
                long zoomMatrixHeight = this.matrixHeight * adjustment;
                try (TileResultSet tileResultSet = tileDao.queryForTileDescending(zoom);){
                    while (tileResultSet.moveToNext()) {
                        TileRow tileRow = (TileRow)tileResultSet.getRow();
                        BoundingBox tileBoundingBox = TileBoundingBoxUtils.getBoundingBox((BoundingBox)previousTileMatrixSetBoundingBox, (TileMatrix)tileMatrix, (long)tileRow.getTileColumn(), (long)tileRow.getTileRow());
                        double midLatitude = tileBoundingBox.getMinLatitude() + (tileBoundingBox.getMaxLatitude() - tileBoundingBox.getMinLatitude()) / 2.0;
                        double midLongitude = tileBoundingBox.getMinLongitude() + (tileBoundingBox.getMaxLongitude() - tileBoundingBox.getMinLongitude()) / 2.0;
                        long newTileRow = TileBoundingBoxUtils.getTileRow((BoundingBox)this.tileGridBoundingBox, (long)zoomMatrixHeight, (double)midLatitude);
                        long newTileColumn = TileBoundingBoxUtils.getTileColumn((BoundingBox)this.tileGridBoundingBox, (long)zoomMatrixWidth, (double)midLongitude);
                        if (tileRow.getTileRow() == newTileRow && tileRow.getTileColumn() == newTileColumn) continue;
                        tileRow.setTileRow(newTileRow);
                        tileRow.setTileColumn(newTileColumn);
                        tileDao.update(tileRow);
                    }
                }
                double pixelXSize = (this.tileGridBoundingBox.getMaxLongitude() - this.tileGridBoundingBox.getMinLongitude()) / (double)zoomMatrixWidth / (double)tileMatrix.getTileWidth();
                double pixelYSize = (this.tileGridBoundingBox.getMaxLatitude() - this.tileGridBoundingBox.getMinLatitude()) / (double)zoomMatrixHeight / (double)tileMatrix.getTileHeight();
                tileMatrix.setMatrixWidth(zoomMatrixWidth);
                tileMatrix.setMatrixHeight(zoomMatrixHeight);
                tileMatrix.setPixelXSize(pixelXSize);
                tileMatrix.setPixelYSize(pixelYSize);
                tileMatrixDao.update(tileMatrix);
            }
            if (minNewOrUpdateZoom < this.minZoom) {
                long adjustment = (long)Math.pow(2.0, this.minZoom - minNewOrUpdateZoom);
                this.matrixWidth *= adjustment;
                this.matrixHeight *= adjustment;
            }
        }
    }

    public void close() {
        if (this.geoPackage != null) {
            this.geoPackage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateTiles(TileMatrixDao tileMatrixDao, TileDao tileDao, Contents contents, int zoomLevel, TileGrid tileGrid, TileGrid localTileGrid, long matrixWidth, long matrixHeight, boolean update) throws SQLException, IOException {
        int count = 0;
        Integer tileWidth = null;
        Integer tileHeight = null;
        HashMap<Long, HashSet<Long>> existingTiles = null;
        if (update && this.skipExisting) {
            existingTiles = new HashMap<Long, HashSet<Long>>();
            try (TileResultSet tileResultSet = tileDao.queryForTile(zoomLevel);){
                while (tileResultSet.moveToNext()) {
                    long column = ((Number)tileResultSet.getValue("tile_column")).longValue();
                    long row = ((Number)tileResultSet.getValue("tile_row")).longValue();
                    HashSet<Long> columnRows = (HashSet<Long>)existingTiles.get(column);
                    if (columnRows == null) {
                        columnRows = new HashSet<Long>();
                        existingTiles.put(column, columnRows);
                    }
                    columnRows.add(row);
                }
            }
            if (existingTiles.isEmpty()) {
                existingTiles = null;
            }
        }
        for (long x = tileGrid.getMinX(); x <= tileGrid.getMaxX() && (this.progress == null || this.progress.isActive()); ++x) {
            long tileColumn = x;
            if (localTileGrid != null) {
                tileColumn = x - tileGrid.getMinX() + localTileGrid.getMinX();
            }
            Set existingColumnRows = null;
            if (existingTiles != null) {
                existingColumnRows = (Set)existingTiles.get(tileColumn);
            }
            for (long y = tileGrid.getMinY(); y <= tileGrid.getMaxY() && (this.progress == null || this.progress.isActive()); ++y) {
                long tileRow = y;
                if (localTileGrid != null) {
                    tileRow = y - tileGrid.getMinY() + localTileGrid.getMinY();
                }
                boolean createTile = true;
                if (existingColumnRows != null) {
                    boolean bl = createTile = !existingColumnRows.contains(tileRow);
                }
                if (createTile) {
                    try {
                        byte[] tileBytes = this.createTile(zoomLevel, x, y);
                        if (tileBytes != null) {
                            BufferedImage image = null;
                            if (this.compressFormat != null && (image = ImageUtils.getImage(tileBytes)) != null) {
                                tileBytes = ImageUtils.writeImageToBytes(image, this.compressFormat, this.compressQuality);
                            }
                            TileRow newRow = tileDao.newRow();
                            newRow.setZoomLevel(zoomLevel);
                            if (update) {
                                tileDao.deleteTile(tileColumn, tileRow, zoomLevel);
                            }
                            newRow.setTileColumn(tileColumn);
                            newRow.setTileRow(tileRow);
                            newRow.setTileData(tileBytes);
                            tileDao.create(newRow);
                            ++count;
                            if (tileWidth == null) {
                                if (image == null) {
                                    image = ImageUtils.getImage(tileBytes);
                                }
                                if (image != null) {
                                    tileWidth = image.getWidth();
                                    tileHeight = image.getHeight();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to create tile. Zoom: " + zoomLevel + ", x: " + x + ", y: " + y, e);
                    }
                }
                if (this.progress == null) continue;
                this.progress.addZoomLevelProgress(zoomLevel, 1);
                this.progress.addProgress(1);
            }
        }
        if ((tileWidth == null || tileHeight == null) && existingTiles == null) {
            count = 0;
            StringBuilder where = new StringBuilder();
            where.append(tileDao.buildWhere("zoom_level", zoomLevel));
            where.append(" AND ");
            where.append(tileDao.buildWhere("tile_column", tileGrid.getMinX(), ">="));
            where.append(" AND ");
            where.append(tileDao.buildWhere("tile_column", tileGrid.getMaxX(), "<="));
            where.append(" AND ");
            where.append(tileDao.buildWhere("tile_row", tileGrid.getMinY(), ">="));
            where.append(" AND ");
            where.append(tileDao.buildWhere("tile_row", tileGrid.getMaxY(), "<="));
            String[] whereArgs = tileDao.buildWhereArgs(new Object[]{zoomLevel, tileGrid.getMinX(), tileGrid.getMaxX(), tileGrid.getMinY(), tileGrid.getMaxY()});
            tileDao.delete(where.toString(), whereArgs);
        } else {
            boolean create = true;
            if (update) {
                boolean bl = create = !tileMatrixDao.idExists(new TileMatrixKey(this.tableName, (long)zoomLevel));
            }
            if (create) {
                double pixelXSize = (this.tileGridBoundingBox.getMaxLongitude() - this.tileGridBoundingBox.getMinLongitude()) / (double)matrixWidth / (double)tileWidth.intValue();
                double pixelYSize = (this.tileGridBoundingBox.getMaxLatitude() - this.tileGridBoundingBox.getMinLatitude()) / (double)matrixHeight / (double)tileHeight.intValue();
                TileMatrix tileMatrix = new TileMatrix();
                tileMatrix.setContents(contents);
                tileMatrix.setZoomLevel((long)zoomLevel);
                tileMatrix.setMatrixWidth(matrixWidth);
                tileMatrix.setMatrixHeight(matrixHeight);
                tileMatrix.setTileWidth((long)tileWidth.intValue());
                tileMatrix.setTileHeight((long)tileHeight.intValue());
                tileMatrix.setPixelXSize(pixelXSize);
                tileMatrix.setPixelYSize(pixelYSize);
                tileMatrixDao.create((Object)tileMatrix);
            }
        }
        return count;
    }

    protected abstract void preTileGeneration();

    protected abstract byte[] createTile(int var1, long var2, long var4);
}

