/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.scale.TileScaling;
import mil.nga.geopackage.extension.scale.TileScalingType;
import mil.nga.geopackage.tiles.GeoPackageTile;
import mil.nga.geopackage.tiles.ImageRectangle;
import mil.nga.geopackage.tiles.ImageUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxJavaUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileResultSet;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;
import org.locationtech.proj4j.ProjCoordinate;

public class TileCreator {
    private final TileDao tileDao;
    private final Integer width;
    private final Integer height;
    private final TileMatrixSet tileMatrixSet;
    private final Projection requestProjection;
    private final Projection tilesProjection;
    private final BoundingBox tileSetBoundingBox;
    private final boolean sameProjection;
    private TileScaling scaling;
    private final String imageFormat;

    public TileCreator(TileDao tileDao, Integer width, Integer height, Projection requestProjection, String imageFormat) {
        this.tileDao = tileDao;
        this.width = width;
        this.height = height;
        this.requestProjection = requestProjection;
        this.imageFormat = imageFormat;
        if (imageFormat == null && (width != null || height != null)) {
            throw new GeoPackageException("The width and height request size can not be specified when requesting raw tiles (no image format specified)");
        }
        this.tileMatrixSet = tileDao.getTileMatrixSet();
        this.tilesProjection = tileDao.getTileMatrixSet().getProjection();
        this.tileSetBoundingBox = this.tileMatrixSet.getBoundingBox();
        this.sameProjection = requestProjection.getUnit().name.equals(this.tilesProjection.getUnit().name);
        if (imageFormat == null && !this.sameProjection) {
            throw new GeoPackageException("The requested projection must be the same as the stored tiles when requesting raw tiles (no image format specified)");
        }
    }

    public TileCreator(TileDao tileDao, String imageFormat) {
        this(tileDao, null, null, tileDao.getProjection(), imageFormat);
    }

    public TileCreator(TileDao tileDao, Projection requestProjection, String imageFormat) {
        this(tileDao, null, null, requestProjection, imageFormat);
    }

    public TileCreator(TileDao tileDao) {
        this(tileDao, null, null, tileDao.getProjection(), null);
    }

    public TileDao getTileDao() {
        return this.tileDao;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public Projection getRequestProjection() {
        return this.requestProjection;
    }

    public Projection getTilesProjection() {
        return this.tilesProjection;
    }

    public BoundingBox getTileSetBoundingBox() {
        return this.tileSetBoundingBox;
    }

    public boolean isSameProjection() {
        return this.sameProjection;
    }

    public TileScaling getScaling() {
        return this.scaling;
    }

    public void setScaling(TileScaling scaling) {
        this.scaling = scaling;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTile(BoundingBox requestBoundingBox) {
        boolean hasTile = false;
        ProjectionTransform transformRequestToTiles = this.requestProjection.getTransformation(this.tilesProjection);
        BoundingBox tilesBoundingBox = requestBoundingBox.transform(transformRequestToTiles);
        List<TileMatrix> tileMatrices = this.getTileMatrices(tilesBoundingBox);
        for (int i = 0; !hasTile && i < tileMatrices.size(); ++i) {
            TileMatrix tileMatrix = tileMatrices.get(i);
            TileResultSet tileResults = this.retrieveTileResults(tilesBoundingBox, tileMatrix);
            if (tileResults == null) continue;
            try {
                hasTile = tileResults.getCount() > 0;
                continue;
            }
            finally {
                tileResults.close();
            }
        }
        return hasTile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoPackageTile getTile(BoundingBox requestBoundingBox) {
        GeoPackageTile tile = null;
        ProjectionTransform transformRequestToTiles = this.requestProjection.getTransformation(this.tilesProjection);
        BoundingBox tilesBoundingBox = requestBoundingBox.transform(transformRequestToTiles);
        List<TileMatrix> tileMatrices = this.getTileMatrices(tilesBoundingBox);
        for (int i = 0; tile == null && i < tileMatrices.size(); ++i) {
            TileMatrix tileMatrix = tileMatrices.get(i);
            TileResultSet tileResults = this.retrieveTileResults(tilesBoundingBox, tileMatrix);
            if (tileResults == null) continue;
            try {
                GeoPackageTile geoPackageTile;
                if (tileResults.getCount() <= 0) continue;
                BoundingBox requestProjectedBoundingBox = requestBoundingBox.transform(transformRequestToTiles);
                int requestedTileWidth = this.width != null ? this.width : (int)tileMatrix.getTileWidth();
                int requestedTileHeight = this.height != null ? this.height : (int)tileMatrix.getTileHeight();
                int tileWidth = requestedTileWidth;
                int tileHeight = requestedTileHeight;
                if (!this.sameProjection) {
                    tileWidth = (int)Math.round((requestProjectedBoundingBox.getMaxLongitude() - requestProjectedBoundingBox.getMinLongitude()) / tileMatrix.getPixelXSize());
                    tileHeight = (int)Math.round((requestProjectedBoundingBox.getMaxLatitude() - requestProjectedBoundingBox.getMinLatitude()) / tileMatrix.getPixelYSize());
                }
                if ((geoPackageTile = this.drawTile(tileMatrix, tileResults, requestProjectedBoundingBox, tileWidth, tileHeight)) == null) continue;
                if (!this.sameProjection && geoPackageTile.getImage() != null) {
                    BufferedImage reprojectTile = this.reprojectTile(geoPackageTile.getImage(), requestedTileWidth, requestedTileHeight, requestBoundingBox, transformRequestToTiles, tilesBoundingBox);
                    geoPackageTile = new GeoPackageTile(requestedTileWidth, requestedTileHeight, reprojectTile);
                }
                tile = geoPackageTile;
                continue;
            }
            finally {
                tileResults.close();
            }
        }
        return tile;
    }

    private GeoPackageTile drawTile(TileMatrix tileMatrix, TileResultSet tileResults, BoundingBox requestProjectedBoundingBox, int tileWidth, int tileHeight) {
        GeoPackageTile geoPackageTile = null;
        Graphics graphics = null;
        while (tileResults.moveToNext()) {
            BufferedImage tileDataImage;
            TileRow tileRow = (TileRow)tileResults.getRow();
            try {
                tileDataImage = tileRow.getTileDataImage();
            }
            catch (IOException e) {
                throw new GeoPackageException("Failed to read the tile row image data", (Throwable)e);
            }
            BoundingBox tileBoundingBox = TileBoundingBoxUtils.getBoundingBox((BoundingBox)this.tileSetBoundingBox, (TileMatrix)tileMatrix, (long)tileRow.getTileColumn(), (long)tileRow.getTileRow());
            BoundingBox overlap = requestProjectedBoundingBox.overlap(tileBoundingBox);
            if (overlap == null) continue;
            ImageRectangle src = TileBoundingBoxJavaUtils.getRectangle(tileMatrix.getTileWidth(), tileMatrix.getTileHeight(), tileBoundingBox, overlap);
            ImageRectangle dest = TileBoundingBoxJavaUtils.getRectangle(tileWidth, tileHeight, requestProjectedBoundingBox, overlap);
            if (!src.isValid() || !dest.isValid()) continue;
            if (this.imageFormat != null) {
                if (geoPackageTile == null) {
                    BufferedImage bufferedImage = ImageUtils.createBufferedImage(tileWidth, tileHeight, this.imageFormat);
                    graphics = bufferedImage.getGraphics();
                    geoPackageTile = new GeoPackageTile(tileWidth, tileHeight, bufferedImage);
                }
                graphics.drawImage(tileDataImage, dest.getLeft(), dest.getTop(), dest.getRight(), dest.getBottom(), src.getLeft(), src.getTop(), src.getRight(), src.getBottom(), null);
                continue;
            }
            if (geoPackageTile != null || !src.equals(dest)) {
                throw new GeoPackageException("Raw image only supported when the images are aligned with the tile format requiring no combining and cropping");
            }
            geoPackageTile = new GeoPackageTile(tileWidth, tileHeight, tileRow.getTileData());
        }
        if (geoPackageTile != null && geoPackageTile.getImage() != null && ImageUtils.isFullyTransparent(geoPackageTile.getImage())) {
            geoPackageTile = null;
        }
        return geoPackageTile;
    }

    private BufferedImage reprojectTile(BufferedImage tile, int requestedTileWidth, int requestedTileHeight, BoundingBox requestBoundingBox, ProjectionTransform transformRequestToTiles, BoundingBox tilesBoundingBox) {
        double requestedWidthUnitsPerPixel = (requestBoundingBox.getMaxLongitude() - requestBoundingBox.getMinLongitude()) / (double)requestedTileWidth;
        double requestedHeightUnitsPerPixel = (requestBoundingBox.getMaxLatitude() - requestBoundingBox.getMinLatitude()) / (double)requestedTileHeight;
        double tilesDistanceWidth = tilesBoundingBox.getMaxLongitude() - tilesBoundingBox.getMinLongitude();
        double tilesDistanceHeight = tilesBoundingBox.getMaxLatitude() - tilesBoundingBox.getMinLatitude();
        int width = tile.getWidth();
        int height = tile.getHeight();
        int[] pixels = new int[width * height];
        tile.getRGB(0, 0, width, height, pixels, 0, width);
        int[] projectedPixels = new int[requestedTileWidth * requestedTileHeight];
        for (int y = 0; y < requestedTileHeight; ++y) {
            for (int x = 0; x < requestedTileWidth; ++x) {
                int color;
                double longitude = requestBoundingBox.getMinLongitude() + (double)x * requestedWidthUnitsPerPixel;
                double latitude = requestBoundingBox.getMaxLatitude() - (double)y * requestedHeightUnitsPerPixel;
                ProjCoordinate fromCoord = new ProjCoordinate(longitude, latitude);
                ProjCoordinate toCoord = transformRequestToTiles.transform(fromCoord);
                double projectedLongitude = toCoord.x;
                double projectedLatitude = toCoord.y;
                int xPixel = (int)Math.round((projectedLongitude - tilesBoundingBox.getMinLongitude()) / tilesDistanceWidth * (double)width);
                int yPixel = (int)Math.round((tilesBoundingBox.getMaxLatitude() - projectedLatitude) / tilesDistanceHeight * (double)height);
                xPixel = Math.max(0, xPixel);
                xPixel = Math.min(width - 1, xPixel);
                yPixel = Math.max(0, yPixel);
                yPixel = Math.min(height - 1, yPixel);
                projectedPixels[y * requestedTileWidth + x] = color = pixels[yPixel * width + xPixel];
            }
        }
        BufferedImage projectedTileImage = new BufferedImage(requestedTileWidth, requestedTileHeight, tile.getType());
        projectedTileImage.setRGB(0, 0, requestedTileWidth, requestedTileHeight, projectedPixels, 0, requestedTileWidth);
        return projectedTileImage;
    }

    private List<TileMatrix> getTileMatrices(BoundingBox projectedRequestBoundingBox) {
        ArrayList<TileMatrix> tileMatrices;
        block14: {
            ArrayList zoomLevels;
            Long requestZoomLevel;
            block17: {
                block15: {
                    ArrayList<Long> zoomOutLevels;
                    ArrayList<Long> zoomInLevels;
                    block18: {
                        block16: {
                            tileMatrices = new ArrayList<TileMatrix>();
                            if (this.tileDao.getTileMatrices().isEmpty() || !projectedRequestBoundingBox.intersects(this.tileSetBoundingBox)) break block14;
                            double distanceWidth = projectedRequestBoundingBox.getMaxLongitude() - projectedRequestBoundingBox.getMinLongitude();
                            double distanceHeight = projectedRequestBoundingBox.getMaxLatitude() - projectedRequestBoundingBox.getMinLatitude();
                            requestZoomLevel = null;
                            requestZoomLevel = this.scaling != null ? this.tileDao.getApproximateZoomLevel(distanceWidth, distanceHeight) : this.tileDao.getZoomLevel(distanceWidth, distanceHeight);
                            if (requestZoomLevel == null) break block14;
                            zoomLevels = null;
                            if (this.scaling == null || this.scaling.getScalingType() == null) break block15;
                            zoomInLevels = new ArrayList<Long>();
                            if (this.scaling.isZoomIn()) {
                                long zoomIn = this.scaling.getZoomIn() != null ? requestZoomLevel + this.scaling.getZoomIn() : this.tileDao.getMaxZoom();
                                for (long zoomLevel = requestZoomLevel + 1L; zoomLevel <= zoomIn; ++zoomLevel) {
                                    zoomInLevels.add(zoomLevel);
                                }
                            }
                            zoomOutLevels = new ArrayList<Long>();
                            if (this.scaling.isZoomOut()) {
                                long zoomOut = this.scaling.getZoomOut() != null ? requestZoomLevel - this.scaling.getZoomOut() : this.tileDao.getMinZoom();
                                for (long zoomLevel = requestZoomLevel - 1L; zoomLevel >= zoomOut; --zoomLevel) {
                                    zoomOutLevels.add(zoomLevel);
                                }
                            }
                            if (!zoomInLevels.isEmpty()) break block16;
                            zoomLevels = zoomOutLevels;
                            break block17;
                        }
                        if (!zoomOutLevels.isEmpty()) break block18;
                        zoomLevels = zoomInLevels;
                        break block17;
                    }
                    TileScalingType type = this.scaling.getScalingType();
                    switch (type) {
                        case IN: 
                        case IN_OUT: {
                            zoomLevels = zoomInLevels;
                            zoomLevels.addAll(zoomOutLevels);
                            break;
                        }
                        case OUT: 
                        case OUT_IN: {
                            zoomLevels = zoomOutLevels;
                            zoomLevels.addAll(zoomInLevels);
                            break;
                        }
                        case CLOSEST_IN_OUT: 
                        case CLOSEST_OUT_IN: {
                            ArrayList<Long> secondLevels;
                            ArrayList<Long> firstLevels;
                            if (type == TileScalingType.CLOSEST_IN_OUT) {
                                firstLevels = zoomInLevels;
                                secondLevels = zoomOutLevels;
                            } else {
                                firstLevels = zoomOutLevels;
                                secondLevels = zoomInLevels;
                            }
                            zoomLevels = new ArrayList();
                            int maxLevels = Math.max(firstLevels.size(), secondLevels.size());
                            for (int i = 0; i < maxLevels; ++i) {
                                if (i < firstLevels.size()) {
                                    zoomLevels.add(firstLevels.get(i));
                                }
                                if (i >= secondLevels.size()) continue;
                                zoomLevels.add(secondLevels.get(i));
                            }
                            break block17;
                        }
                        default: {
                            throw new GeoPackageException("Unsupported " + TileScalingType.class.getSimpleName() + ": " + type);
                        }
                    }
                    break block17;
                }
                zoomLevels = new ArrayList();
            }
            zoomLevels.add(0, requestZoomLevel);
            Iterator iterator = zoomLevels.iterator();
            while (iterator.hasNext()) {
                long zoomLevel = (Long)iterator.next();
                TileMatrix tileMatrix = this.tileDao.getTileMatrix(zoomLevel);
                if (tileMatrix == null) continue;
                tileMatrices.add(tileMatrix);
            }
        }
        return tileMatrices;
    }

    private TileResultSet retrieveTileResults(BoundingBox projectedRequestBoundingBox, TileMatrix tileMatrix) {
        TileResultSet tileResults = null;
        if (tileMatrix != null) {
            TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)this.tileSetBoundingBox, (long)tileMatrix.getMatrixWidth(), (long)tileMatrix.getMatrixHeight(), (BoundingBox)projectedRequestBoundingBox);
            tileResults = this.tileDao.queryByTileGrid(tileGrid, tileMatrix.getZoomLevel());
        }
        return tileResults;
    }
}

