/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import mil.nga.geopackage.tiles.ImageRectangle;

public class ImageRectangleF {
    private float left;
    private float right;
    private float top;
    private float bottom;

    public ImageRectangleF(float left, float top, float right, float bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public ImageRectangleF(ImageRectangleF rectangle) {
        this(rectangle.getLeft(), rectangle.getTop(), rectangle.getRight(), rectangle.getBottom());
    }

    public ImageRectangleF(ImageRectangle rectangle) {
        this(rectangle.getLeft(), rectangle.getTop(), rectangle.getRight(), rectangle.getBottom());
    }

    public float getLeft() {
        return this.left;
    }

    public float getRight() {
        return this.right;
    }

    public float getTop() {
        return this.top;
    }

    public float getBottom() {
        return this.bottom;
    }

    public ImageRectangle round() {
        return new ImageRectangle(Math.round(this.left), Math.round(this.top), Math.round(this.right), Math.round(this.bottom));
    }

    public boolean isValid() {
        return this.left < this.right && this.top < this.bottom;
    }

    public boolean isValidAllowEmpty() {
        return this.left <= this.right && this.top <= this.bottom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.bottom);
        result = 31 * result + Float.floatToIntBits(this.left);
        result = 31 * result + Float.floatToIntBits(this.right);
        result = 31 * result + Float.floatToIntBits(this.top);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageRectangleF other = (ImageRectangleF)obj;
        if (Float.floatToIntBits(this.bottom) != Float.floatToIntBits(other.bottom)) {
            return false;
        }
        if (Float.floatToIntBits(this.left) != Float.floatToIntBits(other.left)) {
            return false;
        }
        if (Float.floatToIntBits(this.right) != Float.floatToIntBits(other.right)) {
            return false;
        }
        return Float.floatToIntBits(this.top) == Float.floatToIntBits(other.top);
    }
}

