/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.extension.scale.TileScaling;
import mil.nga.geopackage.tiles.GeoPackageTile;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileCreator;
import mil.nga.geopackage.tiles.TileRetriever;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionFactory;

public class GeoPackageTileRetriever
implements TileRetriever {
    private final TileCreator tileCreator;

    public GeoPackageTileRetriever(TileDao tileDao) {
        this(tileDao, null);
    }

    public GeoPackageTileRetriever(TileDao tileDao, String imageFormat) {
        this(tileDao, null, null, imageFormat);
    }

    public GeoPackageTileRetriever(TileDao tileDao, Integer width, Integer height, String imageFormat) {
        tileDao.adjustTileMatrixLengths();
        Projection webMercator = ProjectionFactory.getProjection((long)3857L);
        this.tileCreator = new TileCreator(tileDao, width, height, webMercator, imageFormat);
    }

    @Override
    public boolean hasTile(int x, int y, int zoom) {
        BoundingBox webMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (int)zoom);
        boolean hasTile = this.tileCreator.hasTile(webMercatorBoundingBox);
        return hasTile;
    }

    @Override
    public GeoPackageTile getTile(int x, int y, int zoom) {
        BoundingBox webMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (int)zoom);
        GeoPackageTile tile = this.tileCreator.getTile(webMercatorBoundingBox);
        return tile;
    }

    public TileScaling getScaling() {
        return this.tileCreator.getScaling();
    }

    public void setScaling(TileScaling scaling) {
        this.tileCreator.setScaling(scaling);
    }
}

