/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.manager;

import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.io.GeoPackageIOUtils;
import mil.nga.geopackage.manager.GeoPackageImpl;
import mil.nga.geopackage.validate.GeoPackageValidate;

public class GeoPackageManager {
    public static boolean create(File file) {
        boolean created = false;
        if (GeoPackageIOUtils.hasFileExtension((File)file)) {
            GeoPackageValidate.validateGeoPackageExtension((File)file);
        } else {
            file = GeoPackageIOUtils.addFileExtension((File)file, (String)"gpkg");
        }
        if (file.exists()) {
            throw new GeoPackageException("GeoPackage already exists: " + file.getAbsolutePath());
        }
        GeoPackageConnection connection = GeoPackageManager.connect(file);
        connection.setApplicationId();
        connection.setUserVersion();
        GeoPackageTableCreator tableCreator = new GeoPackageTableCreator((GeoPackageCoreConnection)connection);
        tableCreator.createRequired();
        connection.close();
        created = true;
        return created;
    }

    public static GeoPackage open(File file) {
        return GeoPackageManager.open(file, true);
    }

    public static GeoPackage open(File file, boolean validate) {
        return GeoPackageManager.open(file.getName(), file, validate);
    }

    public static GeoPackage open(String name, File file) {
        return GeoPackageManager.open(name, file, true);
    }

    public static GeoPackage open(String name, File file, boolean validate) {
        if (validate) {
            if (GeoPackageIOUtils.hasFileExtension((File)file)) {
                GeoPackageValidate.validateGeoPackageExtension((File)file);
            } else {
                file = GeoPackageIOUtils.addFileExtension((File)file, (String)"gpkg");
            }
        }
        GeoPackageConnection connection = GeoPackageManager.connect(file);
        GeoPackageTableCreator tableCreator = new GeoPackageTableCreator((GeoPackageCoreConnection)connection);
        GeoPackageImpl geoPackage = new GeoPackageImpl(name, file, connection, tableCreator);
        if (validate) {
            try {
                GeoPackageValidate.validateMinimumTables((GeoPackageCore)geoPackage);
            }
            catch (RuntimeException e) {
                geoPackage.close();
                throw e;
            }
        }
        return geoPackage;
    }

    private static GeoPackageConnection connect(File file) {
        JdbcConnectionSource connectionSource;
        Connection databaseConnection;
        String databaseUrl = "jdbc:sqlite:" + file.getPath();
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new GeoPackageException("Failed to load the SQLite JDBC driver", (Throwable)e);
        }
        try {
            databaseConnection = DriverManager.getConnection(databaseUrl);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get connection to the SQLite file: " + file.getAbsolutePath(), (Throwable)e);
        }
        try {
            connectionSource = new JdbcConnectionSource(databaseUrl);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get connection source to the SQLite file: " + file.getAbsolutePath(), (Throwable)e);
        }
        GeoPackageConnection connection = new GeoPackageConnection(file, databaseConnection, (ConnectionSource)connectionSource);
        connection.enableForeignKeys();
        return connection;
    }

    static {
        System.setProperty("com.j256.ormlite.logger.level", "INFO");
    }
}

