/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.manager;

import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesDao;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.attributes.AttributesTableReader;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.extension.RTreeIndexExtension;
import mil.nga.geopackage.factory.GeoPackageCoreImpl;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.index.FeatureIndexManager;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.features.user.FeatureTableReader;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.tiles.user.TileTableReader;
import mil.nga.geopackage.user.custom.UserCustomDao;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;
import mil.nga.sf.proj.Projection;

public class GeoPackageImpl
extends GeoPackageCoreImpl
implements GeoPackage {
    private final GeoPackageConnection database;

    GeoPackageImpl(String name, File file, GeoPackageConnection database, GeoPackageTableCreator tableCreator) {
        super(name, file.getAbsolutePath(), (GeoPackageCoreConnection)database, tableCreator, true);
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoundingBox getFeatureBoundingBox(Projection projection, String table, boolean manual) {
        BoundingBox boundingBox = null;
        try (FeatureIndexManager indexManager = new FeatureIndexManager((GeoPackage)this, table);){
            if (manual || indexManager.isIndexed()) {
                boundingBox = indexManager.getBoundingBox(projection);
            }
        }
        return boundingBox;
    }

    @Override
    public FeatureDao getFeatureDao(GeometryColumns geometryColumns) {
        if (geometryColumns == null) {
            throw new GeoPackageException("Non null " + GeometryColumns.class.getSimpleName() + " is required to create " + FeatureDao.class.getSimpleName());
        }
        FeatureTableReader tableReader = new FeatureTableReader(geometryColumns);
        FeatureTable featureTable = (FeatureTable)tableReader.readTable((GeoPackageCoreConnection)this.database);
        featureTable.setContents(geometryColumns.getContents());
        FeatureDao dao = new FeatureDao(this.getName(), this.database, geometryColumns, featureTable);
        if (this.writable) {
            RTreeIndexExtension rtree = new RTreeIndexExtension(this);
            rtree.createFunctions(featureTable);
        }
        return dao;
    }

    @Override
    public FeatureDao getFeatureDao(Contents contents) {
        if (contents == null) {
            throw new GeoPackageException("Non null " + Contents.class.getSimpleName() + " is required to create " + FeatureDao.class.getSimpleName());
        }
        GeometryColumns geometryColumns = null;
        try {
            geometryColumns = this.getGeometryColumnsDao().queryForTableName(contents.getTableName());
        }
        catch (SQLException e) {
            throw new GeoPackageException("No " + GeometryColumns.class.getSimpleName() + " could be retrieved for " + Contents.class.getSimpleName() + " " + contents.getId());
        }
        if (geometryColumns == null) {
            throw new GeoPackageException("No " + GeometryColumns.class.getSimpleName() + " exists for " + Contents.class.getSimpleName() + " " + contents.getId());
        }
        return this.getFeatureDao(geometryColumns);
    }

    @Override
    public FeatureDao getFeatureDao(String tableName) {
        List geometryColumnsList;
        GeometryColumnsDao dao = this.getGeometryColumnsDao();
        try {
            geometryColumnsList = dao.queryForEq("table_name", (Object)tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + FeatureDao.class.getSimpleName() + " for table name: " + tableName + ". Exception retrieving " + GeometryColumns.class.getSimpleName() + ".", (Throwable)e);
        }
        if (geometryColumnsList.isEmpty()) {
            throw new GeoPackageException("No Feature Table exists for table name: " + tableName);
        }
        if (geometryColumnsList.size() > 1) {
            throw new GeoPackageException("Unexpected state. More than one " + GeometryColumns.class.getSimpleName() + " matched for table name: " + tableName + ", count: " + geometryColumnsList.size());
        }
        return this.getFeatureDao((GeometryColumns)geometryColumnsList.get(0));
    }

    @Override
    public TileDao getTileDao(TileMatrixSet tileMatrixSet) {
        List tileMatrices;
        if (tileMatrixSet == null) {
            throw new GeoPackageException("Non null " + TileMatrixSet.class.getSimpleName() + " is required to create " + TileDao.class.getSimpleName());
        }
        try {
            TileMatrixDao tileMatrixDao = this.getTileMatrixDao();
            QueryBuilder qb = tileMatrixDao.queryBuilder();
            qb.where().eq("table_name", (Object)tileMatrixSet.getTableName());
            qb.orderBy("zoom_level", true);
            qb.orderBy("pixel_x_size", false);
            qb.orderBy("pixel_y_size", false);
            PreparedQuery query = qb.prepare();
            tileMatrices = tileMatrixDao.query(query);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + TileDao.class.getSimpleName() + " for table name: " + tileMatrixSet.getTableName() + ". Exception retrieving " + TileMatrix.class.getSimpleName() + " collection.", (Throwable)e);
        }
        TileTableReader tableReader = new TileTableReader(tileMatrixSet.getTableName());
        TileTable tileTable = (TileTable)tableReader.readTable((GeoPackageCoreConnection)this.database);
        tileTable.setContents(tileMatrixSet.getContents());
        TileDao dao = new TileDao(this.getName(), this.database, tileMatrixSet, tileMatrices, tileTable);
        return dao;
    }

    @Override
    public TileDao getTileDao(Contents contents) {
        if (contents == null) {
            throw new GeoPackageException("Non null " + Contents.class.getSimpleName() + " is required to create " + TileDao.class.getSimpleName());
        }
        TileMatrixSet tileMatrixSet = null;
        try {
            tileMatrixSet = (TileMatrixSet)this.getTileMatrixSetDao().queryForId((Object)contents.getTableName());
        }
        catch (SQLException e) {
            throw new GeoPackageException("No " + TileMatrixSet.class.getSimpleName() + " could be retrieved for " + Contents.class.getSimpleName() + " " + contents.getId());
        }
        if (tileMatrixSet == null) {
            throw new GeoPackageException("No " + TileMatrixSet.class.getSimpleName() + " exists for " + Contents.class.getSimpleName() + " " + contents.getId());
        }
        return this.getTileDao(tileMatrixSet);
    }

    @Override
    public TileDao getTileDao(String tableName) {
        List tileMatrixSetList;
        TileMatrixSetDao dao = this.getTileMatrixSetDao();
        try {
            tileMatrixSetList = dao.queryForEq("table_name", (Object)tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + TileDao.class.getSimpleName() + " for table name: " + tableName + ". Exception retrieving " + TileMatrixSet.class.getSimpleName() + ".", (Throwable)e);
        }
        if (tileMatrixSetList.isEmpty()) {
            throw new GeoPackageException("No Tile Table exists for table name: " + tableName + ", Tile Tables: " + this.getTileTables());
        }
        if (tileMatrixSetList.size() > 1) {
            throw new GeoPackageException("Unexpected state. More than one " + TileMatrixSet.class.getSimpleName() + " matched for table name: " + tableName + ", count: " + tileMatrixSetList.size());
        }
        return this.getTileDao((TileMatrixSet)tileMatrixSetList.get(0));
    }

    @Override
    public AttributesDao getAttributesDao(Contents contents) {
        if (contents == null) {
            throw new GeoPackageException("Non null " + Contents.class.getSimpleName() + " is required to create " + AttributesDao.class.getSimpleName());
        }
        if (contents.getDataType() != ContentsDataType.ATTRIBUTES) {
            throw new GeoPackageException(Contents.class.getSimpleName() + " is required to be of type " + ContentsDataType.ATTRIBUTES + ". Actual: " + contents.getDataTypeString());
        }
        AttributesTableReader tableReader = new AttributesTableReader(contents.getTableName());
        AttributesTable attributesTable = (AttributesTable)tableReader.readTable((GeoPackageCoreConnection)this.database);
        attributesTable.setContents(contents);
        AttributesDao dao = new AttributesDao(this.getName(), this.database, attributesTable);
        return dao;
    }

    @Override
    public AttributesDao getAttributesDao(String tableName) {
        ContentsDao dao = this.getContentsDao();
        Contents contents = null;
        try {
            contents = (Contents)dao.queryForId((Object)tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + Contents.class.getSimpleName() + " for table name: " + tableName, (Throwable)e);
        }
        if (contents == null) {
            throw new GeoPackageException("No Contents Table exists for table name: " + tableName);
        }
        return this.getAttributesDao(contents);
    }

    @Override
    public UserCustomDao getUserCustomDao(String tableName) {
        UserCustomTable table = UserCustomTableReader.readTable((GeoPackageCoreConnection)this.database, (String)tableName);
        return this.getUserCustomDao(table);
    }

    @Override
    public UserCustomDao getUserCustomDao(UserCustomTable table) {
        return new UserCustomDao(this.getName(), this.database, table);
    }

    public void execSQL(String sql) {
        this.database.execSQL(sql);
    }

    public void beginTransaction() {
        this.database.beginTransaction();
    }

    public void endTransaction(boolean successful) {
        this.database.endTransaction(successful);
    }

    public void commit() {
        this.database.commit();
    }

    public boolean inTransaction() {
        return this.database.inTransaction();
    }

    @Override
    public ResultSet query(String sql, String[] args) {
        return this.database.query(sql, args);
    }

    @Override
    public GeoPackageConnection getConnection() {
        return this.database;
    }

    @Override
    public ResultSet foreignKeyCheck() {
        return this.foreignKeyCheck(null);
    }

    @Override
    public ResultSet foreignKeyCheck(String tableName) {
        ResultSet resultSet = this.query(CoreSQLUtils.foreignKeyCheckSQL((String)tableName), null);
        try {
            if (!resultSet.next()) {
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Foreign key check failed on database: " + this.getName(), (Throwable)e);
        }
        return resultSet;
    }

    @Override
    public ResultSet integrityCheck() {
        return this.integrityCheck(this.query(CoreSQLUtils.integrityCheckSQL(), null));
    }

    @Override
    public ResultSet quickCheck() {
        return this.integrityCheck(this.query(CoreSQLUtils.quickCheckSQL(), null));
    }

    private ResultSet integrityCheck(ResultSet resultSet) {
        try {
            String value;
            if (resultSet.next() && (value = resultSet.getString(1)).equals("ok")) {
                resultSet.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Integrity check failed on database: " + this.getName(), (Throwable)e);
        }
        return resultSet;
    }
}

