/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.io.GeoPackageZoomLevelProgress;
import mil.nga.geopackage.io.Progress;

public class ZoomLevelProgress
extends Progress
implements GeoPackageZoomLevelProgress {
    private static final Logger LOGGER = Logger.getLogger(ZoomLevelProgress.class.getName());
    private Map<Integer, Integer> zoomLevelMax = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> zoomLevelProgress = new HashMap<Integer, Integer>();
    private int currentZoom = -1;

    public ZoomLevelProgress(String title, int countFrequency, int timeFrequency) {
        super(title, countFrequency, timeFrequency);
    }

    public ZoomLevelProgress(String title, String unit, int countFrequency, int timeFrequency) {
        super(title, unit, countFrequency, timeFrequency);
    }

    @Override
    public void setZoomLevelMax(int zoomLevel, int max) {
        this.zoomLevelMax.put(zoomLevel, max);
    }

    @Override
    protected void logProgress() {
        int zoomCount = this.getZoomLevelProgress(this.currentZoom);
        int zoomTotal = this.getZoomLevelMax(this.currentZoom);
        LOGGER.log(Level.INFO, this.title + " - " + this.progress + " of " + this.max + this.unit + " (" + this.getPercentage(this.progress, this.max) + "), Zoom " + this.currentZoom + " - " + zoomCount + " of " + zoomTotal + this.unit + " (" + this.getPercentage(zoomCount, zoomTotal) + ")");
    }

    @Override
    public void addZoomLevelProgress(int zoomLevel, int progress) {
        Integer zoomProgress = this.getZoomLevelProgress(zoomLevel);
        zoomProgress = zoomProgress + progress;
        this.zoomLevelProgress.put(zoomLevel, zoomProgress);
        if (this.currentZoom > -1 && this.currentZoom != zoomLevel) {
            LOGGER.log(Level.INFO, this.title + " - Finished Zoom Level " + this.currentZoom + ", Tiles: " + this.getZoomLevelProgress(this.currentZoom));
        }
        this.currentZoom = zoomLevel;
    }

    public Integer getZoomLevelMax(int zoomLevel) {
        Integer zoomMax = this.zoomLevelMax.get(zoomLevel);
        if (zoomMax == null) {
            zoomMax = 0;
        }
        return zoomMax;
    }

    public int getZoomLevelProgress(int zoomLevel) {
        Integer zoomProgress = this.zoomLevelProgress.get(zoomLevel);
        if (zoomProgress == null) {
            zoomProgress = 0;
        }
        return zoomProgress;
    }
}

