/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.io.GeoPackageIOUtils;
import mil.nga.geopackage.io.TileDirectory;
import mil.nga.geopackage.io.TileFormatType;
import mil.nga.geopackage.io.TileProperties;
import mil.nga.geopackage.manager.GeoPackageManager;
import mil.nga.geopackage.tiles.ImageRectangle;
import mil.nga.geopackage.tiles.ImageUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxJavaUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.geopackage.tiles.user.TileTable;

public class TileReader {
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_IMAGE_FORMAT = "i";
    public static final String ARGUMENT_RAW_IMAGE = "r";
    public static final TileFormatType DEFAULT_TILE_TYPE = TileFormatType.XYZ;
    public static final String DEFAULT_IMAGE_FORMAT = "png";
    private static final Logger LOGGER = Logger.getLogger(TileReader.class.getName());
    private static final int ZOOM_PROGRESS_FREQUENCY = 100;

    public static void main(String[] args) throws Exception {
        boolean valid = true;
        boolean requiredArguments = false;
        String imageFormat = null;
        boolean rawImage = false;
        File inputDirectory = null;
        TileFormatType tileType = null;
        File geoPackageFile = null;
        String tileTable = null;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "i": {
                        if (i < args.length) {
                            imageFormat = args[++i];
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Image Format argument '" + arg + "' must be followed by a image format");
                        break;
                    }
                    case "r": {
                        rawImage = true;
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (inputDirectory == null) {
                inputDirectory = new File(arg);
                continue;
            }
            if (tileType == null) {
                tileType = TileFormatType.valueOf(arg.toUpperCase());
                continue;
            }
            if (geoPackageFile == null) {
                geoPackageFile = new File(arg);
                continue;
            }
            if (tileTable == null) {
                tileTable = arg;
                requiredArguments = true;
                continue;
            }
            valid = false;
            System.out.println("Error: Unsupported extra argument: " + arg);
        }
        if (!valid || !requiredArguments) {
            TileReader.printUsage();
        } else {
            try {
                TileReader.readTiles(geoPackageFile, tileTable, inputDirectory, imageFormat, tileType, rawImage);
            }
            catch (Exception e) {
                TileReader.printUsage();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readTiles(File geoPackageFile, String tileTable, File directory, String imageFormat, TileFormatType tileType, boolean rawImage) throws IOException, SQLException {
        if (!geoPackageFile.exists() && !GeoPackageManager.create(geoPackageFile)) {
            throw new GeoPackageException("Failed to create GeoPackage file: " + geoPackageFile.getAbsolutePath());
        }
        try (GeoPackage geoPackage = GeoPackageManager.open(geoPackageFile);){
            TileReader.readTiles(geoPackage, tileTable, directory, imageFormat, tileType, rawImage);
        }
    }

    public static void readTiles(GeoPackage geoPackage, String tileTable, File directory, String imageFormat, TileFormatType tileType, boolean rawImage) throws IOException, SQLException {
        if (imageFormat == null) {
            imageFormat = DEFAULT_IMAGE_FORMAT;
        } else if (rawImage) {
            throw new GeoPackageException("Image format is not used when raw images are used. Choose either image format or raw images.");
        }
        TileDirectory tileDirectory = TileReader.buildTileDirectory(directory);
        LOGGER.log(Level.INFO, "GeoPackage: " + geoPackage.getName() + ", Tile Table: " + tileTable + ", Input Directory: " + directory + (rawImage ? ", Raw Images" : ", Image Format: " + imageFormat) + ", Tiles Type: " + (Object)((Object)tileType) + ", Zoom Range: " + tileDirectory.minZoom + " - " + tileDirectory.maxZoom);
        int totalCount = 0;
        switch (tileType) {
            case GEOPACKAGE: {
                totalCount = TileReader.readGeoPackageFormatTiles(geoPackage, tileTable, imageFormat, rawImage, tileDirectory);
                break;
            }
            case XYZ: 
            case TMS: {
                totalCount = TileReader.readFormatTiles(geoPackage, tileTable, imageFormat, tileType, rawImage, tileDirectory);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Tile Type Not Supported: " + (Object)((Object)tileType));
            }
        }
        LOGGER.log(Level.INFO, "Total Tiles: " + totalCount);
    }

    private static int readGeoPackageFormatTiles(GeoPackage geoPackage, String tileTable, String imageFormat, boolean rawImage, TileDirectory tileDirectory) throws SQLException, IOException {
        int created = 0;
        TileProperties properties = new TileProperties(tileDirectory.directory);
        properties.load();
        int epsg = properties.getIntegerProperty("epsg", true);
        double minX = properties.getDoubleProperty("min_x", true);
        double maxX = properties.getDoubleProperty("max_x", true);
        double minY = properties.getDoubleProperty("min_y", true);
        double maxY = properties.getDoubleProperty("max_y", true);
        List columns = TileTable.createRequiredColumns();
        TileTable table = new TileTable(tileTable, columns);
        geoPackage.createTileTable(table);
        SpatialReferenceSystemDao srsDao = geoPackage.getSpatialReferenceSystemDao();
        SpatialReferenceSystem srs = srsDao.getOrCreateFromEpsg((long)epsg);
        geoPackage.createTileMatrixSetTable();
        geoPackage.createTileMatrixTable();
        ContentsDao contentsDao = geoPackage.getContentsDao();
        Contents contents = new Contents();
        contents.setTableName(tileTable);
        contents.setDataType(ContentsDataType.TILES);
        contents.setIdentifier(tileTable);
        contents.setMinX(Double.valueOf(minX));
        contents.setMinY(Double.valueOf(minY));
        contents.setMaxX(Double.valueOf(maxX));
        contents.setMaxY(Double.valueOf(maxY));
        contents.setSrs(srs);
        contentsDao.create(contents);
        table.setContents(contents);
        TileMatrixSetDao tileMatrixSetDao = geoPackage.getTileMatrixSetDao();
        TileMatrixSet tileMatrixSet = new TileMatrixSet();
        tileMatrixSet.setContents(contents);
        tileMatrixSet.setSrs(srs);
        tileMatrixSet.setMinX(minX);
        tileMatrixSet.setMinY(minY);
        tileMatrixSet.setMaxX(maxX);
        tileMatrixSet.setMaxY(maxY);
        tileMatrixSetDao.create((Object)tileMatrixSet);
        TileMatrixDao tileMatrixDao = geoPackage.getTileMatrixDao();
        TileDao tileDao = geoPackage.getTileDao(tileMatrixSet);
        Integer lastZoom = null;
        Integer lastMatrixWidth = null;
        Integer lastMatrixHeight = null;
        for (TileDirectory.ZoomDirectory zoomDirectory : tileDirectory.zooms.values()) {
            int i;
            int zoomCount = 0;
            Integer tileWidth = null;
            Integer tileHeight = null;
            Integer matrixWidth = properties.getIntegerProperty(TileProperties.getMatrixWidthProperty(zoomDirectory.zoom), false);
            Integer matrixHeight = properties.getIntegerProperty(TileProperties.getMatrixHeightProperty(zoomDirectory.zoom), false);
            if (matrixWidth == null) {
                if (lastZoom != null) {
                    matrixWidth = lastMatrixWidth;
                    for (i = lastZoom.intValue(); i < zoomDirectory.zoom; ++i) {
                        matrixWidth = matrixWidth * 2;
                    }
                } else {
                    matrixWidth = zoomDirectory.maxX + 1;
                }
            }
            if (matrixHeight == null) {
                if (lastZoom != null) {
                    matrixHeight = lastMatrixHeight;
                    for (i = lastZoom.intValue(); i < zoomDirectory.zoom; ++i) {
                        matrixHeight = matrixHeight * 2;
                    }
                } else {
                    matrixHeight = zoomDirectory.maxY + 1;
                }
            }
            lastZoom = zoomDirectory.zoom;
            lastMatrixWidth = matrixWidth;
            lastMatrixHeight = matrixHeight;
            LOGGER.log(Level.INFO, "Zoom Level: " + zoomDirectory.zoom + ", Width: " + matrixWidth + ", Height: " + matrixHeight + ", Max Tiles: " + matrixWidth * matrixHeight);
            for (TileDirectory.XDirectory xDirectory : zoomDirectory.xValues.values()) {
                for (TileDirectory.YFile yFile : xDirectory.yValues.values()) {
                    BufferedImage image = null;
                    if (tileWidth == null || tileHeight == null) {
                        image = ImageIO.read(yFile.file);
                        tileWidth = image.getWidth();
                        tileHeight = image.getHeight();
                    }
                    TileRow newRow = tileDao.newRow();
                    newRow.setZoomLevel(zoomDirectory.zoom);
                    newRow.setTileColumn(xDirectory.x);
                    newRow.setTileRow(yFile.y);
                    if (rawImage) {
                        byte[] rawImageBytes = GeoPackageIOUtils.fileBytes((File)yFile.file);
                        newRow.setTileData(rawImageBytes);
                    } else {
                        if (image == null) {
                            image = ImageIO.read(yFile.file);
                        }
                        newRow.setTileData(image, imageFormat);
                    }
                    tileDao.create(newRow);
                    if (++zoomCount % 100 != 0) continue;
                    LOGGER.log(Level.INFO, "Zoom " + zoomDirectory.zoom + " Tile Progress... " + zoomCount);
                }
            }
            LOGGER.log(Level.INFO, "Zoom " + zoomDirectory.zoom + " Tiles: " + zoomCount);
            if (zoomCount <= 0) continue;
            double pixelXSize = (maxX - minX) / (double)matrixWidth.intValue() / (double)tileWidth.intValue();
            double pixelYSize = (maxY - minY) / (double)matrixHeight.intValue() / (double)tileHeight.intValue();
            TileMatrix tileMatrix = new TileMatrix();
            tileMatrix.setContents(contents);
            tileMatrix.setZoomLevel((long)zoomDirectory.zoom);
            tileMatrix.setMatrixWidth((long)matrixWidth.intValue());
            tileMatrix.setMatrixHeight((long)matrixHeight.intValue());
            tileMatrix.setTileWidth((long)tileWidth.intValue());
            tileMatrix.setTileHeight((long)tileHeight.intValue());
            tileMatrix.setPixelXSize(pixelXSize);
            tileMatrix.setPixelYSize(pixelYSize);
            tileMatrixDao.create((Object)tileMatrix);
            created += zoomCount;
        }
        return created;
    }

    private static int readFormatTiles(GeoPackage geoPackage, String tileTable, String imageFormat, TileFormatType tileType, boolean rawImage, TileDirectory tileDirectory) throws IOException, SQLException {
        int created = 0;
        BoundingBox webMercatorBoundingBox = null;
        for (TileDirectory.ZoomDirectory zoomDirectory : tileDirectory.zooms.values()) {
            int minY = zoomDirectory.minY;
            int maxY = zoomDirectory.maxY;
            if (tileType == TileFormatType.TMS) {
                int tempMaxY = TileBoundingBoxUtils.getYAsOppositeTileFormat((int)zoomDirectory.zoom, (int)minY);
                minY = TileBoundingBoxUtils.getYAsOppositeTileFormat((int)zoomDirectory.zoom, (int)maxY);
                maxY = tempMaxY;
            }
            TileGrid tileGrid = new TileGrid((long)zoomDirectory.minX, (long)minY, (long)zoomDirectory.maxX, (long)maxY);
            BoundingBox zoomBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((TileGrid)tileGrid, (int)zoomDirectory.zoom);
            if (webMercatorBoundingBox == null) {
                webMercatorBoundingBox = zoomBoundingBox;
                continue;
            }
            webMercatorBoundingBox = webMercatorBoundingBox.union(zoomBoundingBox);
        }
        TileGrid totalTileGrid = TileBoundingBoxUtils.getTileGrid(webMercatorBoundingBox, (int)tileDirectory.minZoom);
        BoundingBox totalWebMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((TileGrid)totalTileGrid, (int)tileDirectory.minZoom);
        List columns = TileTable.createRequiredColumns();
        TileTable table = new TileTable(tileTable, columns);
        geoPackage.createTileTable(table);
        SpatialReferenceSystemDao srsDao = geoPackage.getSpatialReferenceSystemDao();
        SpatialReferenceSystem srsWebMercator = srsDao.getOrCreateFromEpsg(3857L);
        geoPackage.createTileMatrixSetTable();
        geoPackage.createTileMatrixTable();
        ContentsDao contentsDao = geoPackage.getContentsDao();
        Contents contents = new Contents();
        contents.setTableName(tileTable);
        contents.setDataType(ContentsDataType.TILES);
        contents.setIdentifier(tileTable);
        contents.setMinX(Double.valueOf(totalWebMercatorBoundingBox.getMinLongitude()));
        contents.setMinY(Double.valueOf(totalWebMercatorBoundingBox.getMinLatitude()));
        contents.setMaxX(Double.valueOf(totalWebMercatorBoundingBox.getMaxLongitude()));
        contents.setMaxY(Double.valueOf(totalWebMercatorBoundingBox.getMaxLatitude()));
        contents.setSrs(srsWebMercator);
        contentsDao.create(contents);
        table.setContents(contents);
        TileMatrixSetDao tileMatrixSetDao = geoPackage.getTileMatrixSetDao();
        TileMatrixSet tileMatrixSet = new TileMatrixSet();
        tileMatrixSet.setContents(contents);
        tileMatrixSet.setSrs(srsWebMercator);
        tileMatrixSet.setMinX(totalWebMercatorBoundingBox.getMinLongitude());
        tileMatrixSet.setMinY(totalWebMercatorBoundingBox.getMinLatitude());
        tileMatrixSet.setMaxX(totalWebMercatorBoundingBox.getMaxLongitude());
        tileMatrixSet.setMaxY(totalWebMercatorBoundingBox.getMaxLatitude());
        tileMatrixSetDao.create((Object)tileMatrixSet);
        TileMatrixDao tileMatrixDao = geoPackage.getTileMatrixDao();
        TileDao tileDao = geoPackage.getTileDao(tileMatrixSet);
        for (TileDirectory.ZoomDirectory zoomDirectory : tileDirectory.zooms.values()) {
            int maxRow;
            int minRow;
            int maxColumn;
            int minColumn;
            int zoomCount = 0;
            Integer tileWidth = null;
            Integer tileHeight = null;
            TileGrid zoomTotalTileGrid = TileBoundingBoxUtils.tileGridZoom((TileGrid)totalTileGrid, (int)tileDirectory.minZoom, (int)zoomDirectory.zoom);
            long matrixWidth = zoomTotalTileGrid.getMaxX() - zoomTotalTileGrid.getMinX() + 1L;
            long matrixHeight = zoomTotalTileGrid.getMaxY() - zoomTotalTileGrid.getMinY() + 1L;
            LOGGER.log(Level.INFO, "Zoom Level: " + zoomDirectory.zoom + ", Width: " + matrixWidth + ", Height: " + matrixHeight + ", Max Tiles: " + matrixWidth * matrixHeight);
            if (rawImage) {
                minColumn = zoomDirectory.minX - (int)zoomTotalTileGrid.getMinX();
                maxColumn = zoomDirectory.maxX - (int)zoomTotalTileGrid.getMinX();
                minRow = zoomDirectory.minY - (int)zoomTotalTileGrid.getMinY();
                maxRow = zoomDirectory.maxY - (int)zoomTotalTileGrid.getMinY();
            } else {
                minColumn = 0;
                maxColumn = (int)matrixWidth - 1;
                minRow = 0;
                maxRow = (int)matrixHeight - 1;
            }
            for (int column = minColumn; column <= maxColumn; ++column) {
                for (int row = minRow; row <= maxRow; ++row) {
                    BufferedImage image = null;
                    Graphics graphics = null;
                    byte[] rawImageBytes = null;
                    BoundingBox tileMatrixBoundingBox = TileBoundingBoxUtils.getBoundingBox((BoundingBox)totalWebMercatorBoundingBox, (long)matrixWidth, (long)matrixHeight, (long)column, (long)row);
                    TileGrid tileMatrixGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)tileMatrixBoundingBox, (int)zoomDirectory.zoom);
                    int x = (int)tileMatrixGrid.getMinX();
                    while ((long)x <= tileMatrixGrid.getMaxX()) {
                        TileDirectory.XDirectory xDirectory = zoomDirectory.xValues.get(x);
                        if (xDirectory != null) {
                            int y = (int)tileMatrixGrid.getMinY();
                            while ((long)y <= tileMatrixGrid.getMaxY()) {
                                BoundingBox imageBoundingBox;
                                BoundingBox overlap;
                                TileDirectory.YFile yFile;
                                int yLocation = y;
                                if (tileType == TileFormatType.TMS) {
                                    yLocation = TileBoundingBoxUtils.getYAsOppositeTileFormat((int)zoomDirectory.zoom, (int)yLocation);
                                }
                                if ((yFile = xDirectory.yValues.get(yLocation)) != null && (overlap = tileMatrixBoundingBox.overlap(imageBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (int)zoomDirectory.zoom))) != null) {
                                    BufferedImage zxyImage = null;
                                    if (tileWidth == null || tileHeight == null) {
                                        zxyImage = ImageIO.read(yFile.file);
                                        tileWidth = zxyImage.getWidth();
                                        tileHeight = zxyImage.getHeight();
                                    }
                                    ImageRectangle src = TileBoundingBoxJavaUtils.getRectangle(tileWidth.intValue(), tileHeight.intValue(), imageBoundingBox, overlap);
                                    ImageRectangle dest = TileBoundingBoxJavaUtils.getRectangle(tileWidth.intValue(), tileHeight.intValue(), tileMatrixBoundingBox, overlap);
                                    if (src.isValid() && dest.isValid()) {
                                        if (rawImage) {
                                            if (rawImageBytes != null || !src.equals(dest)) {
                                                throw new GeoPackageException("Raw image only supported when the images are aligned with the tile format requiring no combining and cropping");
                                            }
                                            rawImageBytes = GeoPackageIOUtils.fileBytes((File)yFile.file);
                                        } else {
                                            if (image == null) {
                                                image = ImageUtils.createBufferedImage(tileWidth, tileHeight, imageFormat);
                                                graphics = image.getGraphics();
                                            }
                                            if (zxyImage == null) {
                                                zxyImage = ImageIO.read(yFile.file);
                                            }
                                            graphics.drawImage(zxyImage, dest.getLeft(), dest.getTop(), dest.getRight(), dest.getBottom(), src.getLeft(), src.getTop(), src.getRight(), src.getBottom(), null);
                                        }
                                    }
                                }
                                ++y;
                            }
                        }
                        ++x;
                    }
                    if ((image == null || ImageUtils.isFullyTransparent(image)) && rawImageBytes == null) continue;
                    TileRow newRow = tileDao.newRow();
                    newRow.setZoomLevel(zoomDirectory.zoom);
                    newRow.setTileColumn(column);
                    newRow.setTileRow(row);
                    if (rawImage) {
                        newRow.setTileData(rawImageBytes);
                    } else {
                        newRow.setTileData(image, imageFormat);
                    }
                    tileDao.create(newRow);
                    if (++zoomCount % 100 != 0) continue;
                    LOGGER.log(Level.INFO, "Zoom " + zoomDirectory.zoom + " Tile Progress... " + zoomCount);
                }
            }
            LOGGER.log(Level.INFO, "Zoom " + zoomDirectory.zoom + " Tiles: " + zoomCount);
            if (zoomCount <= 0) continue;
            double pixelXSize = TileBoundingBoxUtils.getPixelXSize((BoundingBox)totalWebMercatorBoundingBox, (long)matrixWidth, (int)tileWidth);
            double pixelYSize = TileBoundingBoxUtils.getPixelYSize((BoundingBox)totalWebMercatorBoundingBox, (long)matrixHeight, (int)tileHeight);
            TileMatrix tileMatrix = new TileMatrix();
            tileMatrix.setContents(contents);
            tileMatrix.setZoomLevel((long)zoomDirectory.zoom);
            tileMatrix.setMatrixWidth(matrixWidth);
            tileMatrix.setMatrixHeight(matrixHeight);
            tileMatrix.setTileWidth((long)tileWidth.intValue());
            tileMatrix.setTileHeight((long)tileHeight.intValue());
            tileMatrix.setPixelXSize(pixelXSize);
            tileMatrix.setPixelYSize(pixelYSize);
            tileMatrixDao.create((Object)tileMatrix);
            created += zoomCount;
        }
        return created;
    }

    private static TileDirectory buildTileDirectory(File directory) {
        TileDirectory tileDirectory = new TileDirectory();
        tileDirectory.directory = directory;
        for (File zoomDirectory : directory.listFiles()) {
            if (zoomDirectory.isDirectory()) {
                try {
                    Integer zoomLevel = Integer.valueOf(zoomDirectory.getName());
                    TileDirectory.ZoomDirectory zoom = new TileDirectory.ZoomDirectory(tileDirectory);
                    zoom.directory = new File(tileDirectory.directory, zoomDirectory.getName());
                    zoom.zoom = zoomLevel;
                    tileDirectory.zooms.put(zoomLevel, zoom);
                    tileDirectory.minZoom = Math.min(tileDirectory.minZoom, zoomLevel);
                    tileDirectory.maxZoom = Math.max(tileDirectory.maxZoom, zoomLevel);
                    for (File xDirectory : zoomDirectory.listFiles()) {
                        if (xDirectory.isDirectory()) {
                            try {
                                Integer xValue = Integer.valueOf(xDirectory.getName());
                                TileDirectory.XDirectory x = new TileDirectory.XDirectory(tileDirectory);
                                x.directory = new File(zoom.directory, xDirectory.getName());
                                x.x = xValue;
                                zoom.xValues.put(xValue, x);
                                zoom.minX = Math.min(zoom.minX, xValue);
                                zoom.maxX = Math.max(zoom.maxX, xValue);
                                for (File yImage : xDirectory.listFiles()) {
                                    if (yImage.isFile()) {
                                        try {
                                            String yImageName = yImage.getName();
                                            int extensionLocation = yImageName.lastIndexOf(".");
                                            if (extensionLocation >= 0) {
                                                yImageName = yImageName.substring(0, extensionLocation);
                                            }
                                            TileDirectory.YFile y = new TileDirectory.YFile(tileDirectory);
                                            y.y = Integer.valueOf(yImageName);
                                            y.file = new File(x.directory, yImage.getName());
                                            x.yValues.put(y.y, y);
                                            x.minY = Math.min(x.minY, y.y);
                                            x.maxY = Math.max(x.maxY, y.y);
                                        }
                                        catch (NumberFormatException e) {
                                            LOGGER.log(Level.INFO, "Skipping file: " + yImage.getAbsolutePath());
                                        }
                                        continue;
                                    }
                                    LOGGER.log(Level.INFO, "Skipping directory: " + yImage.getAbsolutePath());
                                }
                                zoom.minY = Math.min(zoom.minY, x.minY);
                                zoom.maxY = Math.max(zoom.maxY, x.maxY);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.log(Level.INFO, "Skipping directory: " + xDirectory.getAbsolutePath());
                            }
                            continue;
                        }
                        LOGGER.log(Level.INFO, "Skipping file: " + xDirectory.getAbsolutePath());
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.INFO, "Skipping directory: " + zoomDirectory.getAbsolutePath());
                    continue;
                }
            }
            LOGGER.log(Level.INFO, "Skipping file: " + zoomDirectory.getAbsolutePath());
        }
        return tileDirectory;
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-i image_format] [-r] input_directory tile_type geopackage_file tile_table");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tReads a tile set from the file system in a z/x/y folder system into a new table in a new or existing GeoPackage file");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-i image_format");
        System.out.println("\t\tStorage image format in the GeoPackage: png, jpg, jpeg (default is 'png')");
        System.out.println();
        System.out.println("\t-r");
        System.out.println("\t\tUse the raw image bytes, only works when combining and cropping is not required. Not compatible with image_format");
        System.out.println();
        System.out.println("\tinput_directory");
        System.out.println("\t\tinput directory containing the tile image set used to create the GeoPakage tiles");
        System.out.println();
        System.out.println("\ttile_type");
        System.out.println("\t\tTile input format specifying z/x/y folder organization: " + TileFormatType.GEOPACKAGE.name().toLowerCase() + ", " + TileFormatType.XYZ.name().toLowerCase() + ", " + TileFormatType.TMS.name().toLowerCase());
        System.out.println("\t\t\t" + TileFormatType.GEOPACKAGE.name().toLowerCase() + " - x and y represent GeoPackage Tile Matrix width and height. Requires a input_directory/" + "tiles.properties" + " file");
        System.out.println("\t\t\t" + TileFormatType.XYZ.name().toLowerCase() + " - x and y origin is top left");
        System.out.println("\t\t\t" + TileFormatType.TMS.name().toLowerCase() + " - (Tile Map Service) x and y origin is bottom left");
        System.out.println();
        System.out.println("\tgeopackage_file");
        System.out.println("\t\tpath to the GeoPackage file to create or add a new tile table to");
        System.out.println();
        System.out.println("\ttile_table");
        System.out.println("\t\tnew tile table name to create within the GeoPackage file");
        System.out.println();
        System.out.println("GEOPACKAGE PROPERTIES");
        System.out.println();
        System.out.println("\tReading tiles with a tile_type of geopackage requires a properties file located at: input_directory/tiles.properties");
        System.out.println();
        System.out.println("\tRequired Properties:");
        System.out.println();
        System.out.println("\t\tepsg=");
        System.out.println("\t\tmin_x=");
        System.out.println("\t\tmax_x=");
        System.out.println("\t\tmin_y=");
        System.out.println("\t\tmax_y=");
        System.out.println();
        System.out.println("\tOptional Properties:");
        System.out.println();
        System.out.println("\t\tIf the file structure is fully populated and represents the matrix width and height, the properties can be omitted.");
        System.out.println("\t\tIf a non top zoom level matrix width and height increase by a factor of 2 with each zoom level, the properties can be omitted for those zoom levels.");
        System.out.println();
        System.out.println("\t\t" + TileProperties.getMatrixWidthProperty("{zoom}") + "=");
        System.out.println("\t\t" + TileProperties.getMatrixHeightProperty("{zoom}") + "=");
        System.out.println();
    }
}

