/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SQLExecResult {
    private Set<String> tables = new LinkedHashSet<String>();
    private List<String> columns = new ArrayList<String>();
    private List<Integer> columnWidths = new ArrayList<Integer>();
    private List<List<String>> rows = new ArrayList<List<String>>();
    private Integer updateCount = null;
    private Integer maxRows = null;

    protected SQLExecResult() {
    }

    protected void addTable(String table) {
        if (table != null && !table.trim().isEmpty()) {
            this.tables.add(table.trim());
        }
    }

    public List<String> getTables() {
        return new ArrayList<String>(this.tables);
    }

    protected void addColumn(String column) {
        this.columns.add(column);
    }

    public int numColumns() {
        return this.columns.size();
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String getColumn(int index) {
        return this.columns.get(index);
    }

    public boolean hasColumns() {
        return this.numColumns() > 0;
    }

    protected void addColumnWidth(int width) {
        this.columnWidths.add(width);
    }

    protected void addColumnWidths(int[] widths) {
        for (int width : widths) {
            this.addColumnWidth(width);
        }
    }

    public List<Integer> getColumnWidths() {
        return this.columnWidths;
    }

    public int getColumnWidth(int index) {
        return this.columnWidths.get(index);
    }

    protected void addRow(List<String> row) {
        this.rows.add(row);
    }

    public int numRows() {
        return this.rows.size();
    }

    public boolean hasRows() {
        return this.numRows() > 0;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public List<String> getRow(int index) {
        return this.rows.get(index);
    }

    public String getValue(int rowIndex, int columnIndex) {
        return this.getRow(rowIndex).get(columnIndex);
    }

    protected void setUpdateCount(Integer updateCount) {
        this.updateCount = updateCount;
    }

    public Integer getUpdateCount() {
        return this.updateCount;
    }

    public boolean hasUpdateCount() {
        return this.getUpdateCount() != null;
    }

    protected void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public boolean hasMaxResults() {
        return this.maxRows != null && this.numRows() >= this.maxRows;
    }

    public void printResults() {
        System.out.println();
        if (this.hasColumns()) {
            int width = 0;
            for (int columnWidth : this.columnWidths) {
                width += columnWidth;
            }
            width += this.numColumns() + 1;
            this.printTables();
            this.printHorizontalDivider(width += 2 * this.numColumns());
            this.printColumns();
            this.printHorizontalDivider(width);
            this.printRows(width);
            this.printHorizontalDivider(width);
            this.printRowCount();
        } else if (this.hasUpdateCount()) {
            System.out.println("Update Count: " + this.getUpdateCount());
        } else {
            System.out.println("No Results");
        }
    }

    private void printRowCount() {
        System.out.println("Rows: " + this.numRows() + (this.hasMaxResults() ? " (max)" : ""));
    }

    private void printTables() {
        List<String> tables = this.getTables();
        if (!tables.isEmpty()) {
            System.out.print("Table");
            if (tables.size() > 1) {
                System.out.print("s");
            }
            System.out.print(": ");
            for (int i = 0; i < tables.size(); ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(tables.get(i));
            }
            System.out.println();
        }
    }

    private void printColumns() {
        for (int col = 0; col < this.numColumns(); ++col) {
            this.printVerticalDivider();
            this.printSpace();
            String column = this.getColumn(col);
            int width = this.getColumnWidth(col);
            System.out.print(column);
            this.printSpace(width - column.length());
            this.printSpace();
        }
        this.printVerticalDivider();
        System.out.println();
    }

    private void printRows(int width) {
        if (this.hasRows()) {
            for (int row = 0; row < this.numRows(); ++row) {
                this.printRow(row);
            }
        } else {
            this.printVerticalDivider();
            this.printSpace(width - 2);
            this.printVerticalDivider();
            System.out.println();
        }
    }

    private void printRow(int index) {
        List<String> values = this.getRow(index);
        for (int col = 0; col < this.numColumns(); ++col) {
            this.printVerticalDivider();
            this.printSpace();
            String value = values.get(col);
            int width = this.getColumnWidth(col);
            int valueLength = 0;
            if (value != null) {
                System.out.print(value);
                valueLength = value.length();
            }
            this.printSpace(width - valueLength);
            this.printSpace();
        }
        this.printVerticalDivider();
        System.out.println();
    }

    private void printHorizontalDivider(int width) {
        for (int i = 0; i < width; ++i) {
            this.printHorizontalDivider();
        }
        System.out.println();
    }

    private void printHorizontalDivider() {
        System.out.print("-");
    }

    private void printVerticalDivider() {
        System.out.print("|");
    }

    private void printSpace(int width) {
        for (int i = 0; i < width; ++i) {
            this.printSpace();
        }
    }

    private void printSpace() {
        System.out.print(" ");
    }
}

