/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.SQLUtils;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;
import mil.nga.geopackage.db.master.SQLiteMasterQuery;
import mil.nga.geopackage.db.master.SQLiteMasterType;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.db.table.TableInfo;
import mil.nga.geopackage.extension.RTreeIndexExtension;
import mil.nga.geopackage.io.SQLExecAlterTable;
import mil.nga.geopackage.io.SQLExecResult;
import mil.nga.geopackage.manager.GeoPackageManager;
import mil.nga.geopackage.validate.GeoPackageValidate;

public class SQLExec {
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_MAX_ROWS = "m";
    public static final int DEFAULT_MAX_ROWS = 100;
    public static final Pattern HISTORY_PATTERN = Pattern.compile("^!-?\\d+$");
    public static final String COMMAND_PROMPT = "sql> ";
    public static final String COMMAND_HELP = "help";
    public static final String COMMAND_TABLES = "tables";
    public static final String COMMAND_INDEXES = "indexes";
    public static final String COMMAND_VIEWS = "views";
    public static final String COMMAND_TRIGGERS = "triggers";
    public static final int COMMAND_ALL_ROWS = 0x7FFFFFFE;
    public static final String COMMAND_HISTORY = "history";
    public static final String COMMAND_PREVIOUS = "!!";
    public static final String COMMAND_WRITE_BLOBS = "blobs";
    public static final String COMMAND_MAX_ROWS = "rows";
    public static final String COMMAND_TABLE_INFO = "info";
    public static final String COMMAND_SQLITE_MASTER = "sqlite_master";
    public static final String COMMAND_CONTENTS = "contents";
    public static final String COMMAND_GEOPACKAGE_INFO = "ginfo";
    public static final String COMMAND_EXTENSIONS = "extensions";
    public static final String BLOB_DISPLAY_VALUE = "BLOB";
    public static final String BLOBS_WRITE_DEFAULT_DIRECTORY = "blobs";
    public static final String BLOBS_ARGUMENT_EXTENSION = "e";
    public static final String BLOBS_ARGUMENT_DIRECTORY = "d";
    public static final String BLOBS_ARGUMENT_PATTERN = "p";
    public static final String BLOBS_COLUMN_START_REGEX = "\\(";
    public static final String BLOBS_COLUMN_END_REGEX = "\\)";
    public static final Pattern BLOBS_COLUMN_PATTERN = Pattern.compile("\\(([^\\)]+)\\)");
    public static final int BLOBS_COLUMN_PATTERN_GROUP = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        boolean valid = true;
        boolean requiredArguments = false;
        File sqliteFile = null;
        Integer maxRows = null;
        StringBuilder sql = null;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "m": {
                        if (i < args.length) {
                            String maxRowsString = args[++i];
                            try {
                                maxRows = Integer.valueOf(maxRowsString);
                            }
                            catch (NumberFormatException e) {
                                valid = false;
                                System.out.println("Error: Max Rows argument '" + arg + "' must be followed by a valid number. Invalid: " + maxRowsString);
                            }
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Max Rows argument '" + arg + "' must be followed by a valid number");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (sqliteFile == null) {
                sqliteFile = new File(arg);
                requiredArguments = true;
                continue;
            }
            if (sql == null) {
                sql = new StringBuilder(arg);
                continue;
            }
            sql.append(" ").append(arg);
        }
        if (!valid || !requiredArguments) {
            SQLExec.printUsage();
        } else {
            try (GeoPackage database = GeoPackageManager.open(sqliteFile, false);){
                if (SQLExec.isGeoPackage(database)) {
                    System.out.print("GeoPackage");
                } else {
                    System.out.print("Database");
                }
                System.out.println(": " + database.getName());
                System.out.println("Path: " + database.getPath());
                System.out.println("Max Rows: " + (maxRows != null ? maxRows : 100));
                if (sql != null) {
                    try {
                        SQLExecResult result = SQLExec.executeSQL(database, sql.toString(), maxRows);
                        result.printResults();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                } else {
                    SQLExec.commandPrompt(database, maxRows);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commandPrompt(GeoPackage database, Integer maxRows) {
        SQLExec.printHelp(database);
        ArrayList<String> history = new ArrayList<String>();
        try (Scanner scanner = new Scanner(System.in);){
            StringBuilder sqlBuilder = new StringBuilder();
            SQLExec.resetCommandPrompt(sqlBuilder);
            while (scanner.hasNextLine()) {
                try {
                    boolean singleLine;
                    boolean executeSql;
                    String sqlLine = scanner.nextLine().trim();
                    int semicolon = sqlLine.indexOf(";");
                    boolean bl = executeSql = semicolon >= 0;
                    if (executeSql) {
                        sqlLine = sqlLine.substring(0, semicolon + 1);
                    }
                    boolean bl2 = singleLine = sqlBuilder.length() == 0;
                    if (!sqlLine.isEmpty()) {
                        if (!singleLine) {
                            sqlBuilder.append(" ");
                        }
                        sqlBuilder.append(sqlLine);
                    }
                    if (singleLine) {
                        CharSequence sql;
                        if (executeSql) {
                            sqlLine = sqlLine.substring(0, sqlLine.length() - 1).trim();
                        }
                        boolean command = true;
                        if (sqlLine.isEmpty()) {
                            break;
                        }
                        if (sqlLine.equalsIgnoreCase(COMMAND_HELP)) {
                            SQLExec.printHelp(database);
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLine.toLowerCase().startsWith(COMMAND_TABLES)) {
                            String name = sqlLine.substring(COMMAND_TABLES.length(), sqlLine.length()).trim();
                            sql = SQLExec.buildSqlMasterQuery(false, SQLiteMasterType.TABLE, name);
                            SQLExec.executeSQL(database, sqlBuilder, (String)sql, (Integer)0x7FFFFFFE, history);
                        } else if (sqlLine.toLowerCase().startsWith(COMMAND_INDEXES)) {
                            String name = sqlLine.substring(COMMAND_INDEXES.length(), sqlLine.length()).trim();
                            sql = SQLExec.buildSqlMasterQuery(true, SQLiteMasterType.INDEX, name);
                            SQLExec.executeSQL(database, sqlBuilder, (String)sql, (Integer)0x7FFFFFFE, history);
                        } else if (sqlLine.toLowerCase().startsWith(COMMAND_VIEWS)) {
                            String name = sqlLine.substring(COMMAND_VIEWS.length(), sqlLine.length()).trim();
                            sql = SQLExec.buildSqlMasterQuery(false, SQLiteMasterType.VIEW, name);
                            SQLExec.executeSQL(database, sqlBuilder, (String)sql, (Integer)0x7FFFFFFE, history);
                        } else if (sqlLine.toLowerCase().startsWith(COMMAND_TRIGGERS)) {
                            String name = sqlLine.substring(COMMAND_TRIGGERS.length(), sqlLine.length()).trim();
                            sql = SQLExec.buildSqlMasterQuery(true, SQLiteMasterType.TRIGGER, name);
                            SQLExec.executeSQL(database, sqlBuilder, (String)sql, (Integer)0x7FFFFFFE, history);
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_HISTORY)) {
                            for (int i = 0; i < history.size(); ++i) {
                                System.out.println(" " + String.format("%4d", i + 1) + "  " + (String)history.get(i));
                            }
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_PREVIOUS)) {
                            SQLExec.executeSQL(database, sqlBuilder, history.size(), maxRows, history);
                        } else if (sqlLine.toLowerCase().startsWith("blobs")) {
                            SQLExec.writeBlobs(database, sqlBuilder, maxRows, history, sqlLine.substring("blobs".length()));
                        } else if (HISTORY_PATTERN.matcher(sqlLine).matches()) {
                            int historyNumber = Integer.parseInt(sqlLine.substring(1, sqlLine.length()));
                            SQLExec.executeSQL(database, sqlBuilder, historyNumber, maxRows, history);
                        } else if (sqlLine.toLowerCase().startsWith(COMMAND_MAX_ROWS)) {
                            maxRows = Integer.parseInt(sqlLine.substring(COMMAND_MAX_ROWS.length(), sqlLine.length()).trim());
                            System.out.println("Max Rows: " + maxRows);
                            SQLExec.resetCommandPrompt(sqlBuilder);
                        } else if (sqlLine.toLowerCase().startsWith(COMMAND_TABLE_INFO)) {
                            String tableName = sqlLine.substring(COMMAND_TABLE_INFO.length(), sqlLine.length()).trim();
                            if (!tableName.isEmpty()) {
                                SQLExec.executeSQL(database, sqlBuilder, "PRAGMA table_info(\"" + tableName + "\");", (Integer)0x7FFFFFFE, history);
                            } else {
                                SQLExec.resetCommandPrompt(sqlBuilder);
                            }
                        } else if (sqlLine.equalsIgnoreCase(COMMAND_SQLITE_MASTER) || SQLiteMaster.count((GeoPackageCoreConnection)database.getDatabase(), (SQLiteMasterType[])new SQLiteMasterType[]{SQLiteMasterType.TABLE, SQLiteMasterType.VIEW}, (SQLiteMasterQuery)SQLiteMasterQuery.create((SQLiteMasterColumn)SQLiteMasterColumn.NAME, (String)sqlLine)) > 0) {
                            SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM \"" + sqlLine + "\";", maxRows, history);
                        } else if (SQLExec.isGeoPackage(database)) {
                            String dataType;
                            if (sqlLine.toLowerCase().startsWith(COMMAND_CONTENTS)) {
                                String tableName = sqlLine.substring(COMMAND_CONTENTS.length(), sqlLine.length()).trim();
                                sql = new StringBuilder("SELECT table_name, data_type FROM gpkg_contents");
                                if (!tableName.isEmpty()) {
                                    ((StringBuilder)sql).append(" WHERE table_name LIKE ");
                                    ((StringBuilder)sql).append(CoreSQLUtils.quoteWrap((String)tableName));
                                }
                                ((StringBuilder)sql).append(" ORDER BY table_name;");
                                SQLExec.executeSQL(database, sqlBuilder, ((StringBuilder)sql).toString(), (Integer)0x7FFFFFFE, history);
                            } else if (sqlLine.toLowerCase().startsWith(COMMAND_GEOPACKAGE_INFO)) {
                                String tableName = sqlLine.substring(COMMAND_GEOPACKAGE_INFO.length(), sqlLine.length()).trim();
                                if (!tableName.isEmpty()) {
                                    SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_contents WHERE LOWER(table_name) = '" + tableName.toLowerCase() + "';", 0x7FFFFFFE, history, false);
                                    dataType = database.getTableDataType(tableName);
                                    if (dataType != null) {
                                        switch (1.$SwitchMap$mil$nga$geopackage$core$contents$ContentsDataType[dataType.ordinal()]) {
                                            case 1: {
                                                break;
                                            }
                                            case 2: {
                                                SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_geometry_columns WHERE table_name = '" + tableName + "';", 0x7FFFFFFE, history, false);
                                                break;
                                            }
                                            case 3: {
                                                SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_2d_gridded_coverage_ancillary WHERE tile_matrix_set_name = '" + tableName + "';", 0x7FFFFFFE, history, false);
                                                SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_2d_gridded_tile_ancillary WHERE tpudt_name = '" + tableName + "';", 0x7FFFFFFE, history, false);
                                            }
                                            case 4: {
                                                SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_tile_matrix_set WHERE table_name = '" + tableName + "';", 0x7FFFFFFE, history, false);
                                                SQLExec.executeSQL(database, sqlBuilder, "SELECT * FROM gpkg_tile_matrix WHERE table_name = '" + tableName + "';", 0x7FFFFFFE, history, false);
                                            }
                                        }
                                    }
                                    SQLExec.executeSQL(database, sqlBuilder, "PRAGMA table_info(\"" + tableName + "\");", 0x7FFFFFFE, history, false);
                                }
                                SQLExec.resetCommandPrompt(sqlBuilder);
                            } else if (sqlLine.toLowerCase().startsWith(COMMAND_EXTENSIONS)) {
                                String tableName = sqlLine.substring(COMMAND_EXTENSIONS.length(), sqlLine.length()).trim();
                                sql = new StringBuilder("SELECT table_name, column_name, extension_name, definition FROM gpkg_extensions");
                                if (!tableName.isEmpty()) {
                                    ((StringBuilder)sql).append(" WHERE LOWER(table_name) LIKE ");
                                    ((StringBuilder)sql).append(CoreSQLUtils.quoteWrap((String)tableName.toLowerCase()));
                                }
                                ((StringBuilder)sql).append(";");
                                SQLExec.executeSQL(database, sqlBuilder, ((StringBuilder)sql).toString(), (Integer)0x7FFFFFFE, history);
                            } else {
                                String[] parts = sqlLine.split("\\s+");
                                dataType = parts[0];
                                if (ContentsDataType.fromName((String)dataType.toLowerCase()) != null || !database.getTables(dataType.toLowerCase()).isEmpty() || !database.getTables(dataType).isEmpty()) {
                                    String tableName;
                                    StringBuilder sql2 = new StringBuilder("SELECT table_name FROM gpkg_contents WHERE LOWER(data_type) = '");
                                    sql2.append(dataType.toLowerCase());
                                    sql2.append("'");
                                    if (parts.length > 0 && !(tableName = sqlLine.substring(dataType.length(), sqlLine.length()).trim()).isEmpty()) {
                                        sql2.append(" AND table_name LIKE ");
                                        sql2.append(CoreSQLUtils.quoteWrap((String)tableName));
                                    }
                                    sql2.append(" ORDER BY table_name;");
                                    SQLExec.executeSQL(database, sqlBuilder, sql2.toString(), (Integer)0x7FFFFFFE, history);
                                } else {
                                    command = false;
                                }
                            }
                        } else {
                            command = false;
                        }
                        if (command) {
                            executeSql = false;
                        }
                    }
                    if (!executeSql) continue;
                    SQLExec.executeSQL(database, sqlBuilder, sqlBuilder.toString(), maxRows, history);
                }
                catch (Exception e) {
                    System.out.println(e);
                    SQLExec.resetCommandPrompt(sqlBuilder);
                }
            }
        }
    }

    private static String buildSqlMasterQuery(boolean tableName, SQLiteMasterType type, String name) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
        if (tableName) {
            sql.append(", ");
            sql.append(SQLiteMasterColumn.TBL_NAME.name().toLowerCase());
        }
        sql.append(" FROM ");
        sql.append(COMMAND_SQLITE_MASTER);
        sql.append(" WHERE ");
        sql.append(SQLiteMasterColumn.TYPE.name().toLowerCase());
        sql.append(" = '");
        sql.append(type.name().toLowerCase());
        sql.append("' AND ");
        sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
        sql.append(" NOT LIKE 'sqlite_%'");
        if (name != null && !(name = name.trim()).isEmpty()) {
            sql.append(" AND ");
            sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
            sql.append(" LIKE ");
            sql.append(CoreSQLUtils.quoteWrap((String)name));
        }
        sql.append(" ORDER BY ");
        sql.append(SQLiteMasterColumn.NAME.name().toLowerCase());
        sql.append(";");
        return sql.toString();
    }

    private static void printHelp(GeoPackage database) {
        boolean isGeoPackage = SQLExec.isGeoPackage(database);
        System.out.println();
        System.out.println("- Supports most SQLite statements including:");
        System.out.println("\tSELECT, INSERT, UPDATE, DELETE, CREATE, ALTER, DROP, PRAGMA, VACUUM, etc");
        System.out.println("- Terminate SQL statements with a ;");
        System.out.println("- Exit with a single empty line");
        System.out.println();
        System.out.println("Commands:");
        System.out.println();
        System.out.println("\thelp              - print this help information");
        System.out.println("\ttables [name]     - list database tables (all or LIKE table name)");
        System.out.println("\tindexes [name]    - list database indexes (all or LIKE index name)");
        System.out.println("\tviews [name]      - list database views (all or LIKE view name)");
        System.out.println("\ttriggers [name]   - list database triggers (all or LIKE trigger name)");
        System.out.println("\trows n            - set the max rows per query to n");
        System.out.println("\thistory           - list successfully executed sql commands");
        System.out.println("\t!!                - re-execute the previous successful sql command");
        System.out.println("\t!n                - re-execute a sql statement by history id n");
        System.out.println("\t!-n               - re-execute a sql statement n commands back in history");
        System.out.println("\tblobs [-e file_extension] [-d directory] [-p pattern]");
        System.out.println("\t                  - write blobs from the previous successful sql command to the file system");
        System.out.println("\t                        ([directory]|blobs)/table_name/column_name/(pk_values|result_index|[pattern])[.file_extension]");
        System.out.println("\t                     file_extension - file extension added to each saved blob file");
        System.out.println("\t                     directory      - base directory to save table_name/column_name/blobs (default is ./blobs)");
        System.out.println("\t                     pattern        - file directory and/or name pattern consisting of column names in parentheses");
        System.out.println("\t                                       (column_name)-(column_name2)");
        System.out.println("\t                                       (column_name)/(column_name2)");
        System.out.println("\tinfo <name>       - PRAGMA table_info(<name>);");
        System.out.println("\t<name>            - SELECT * FROM <name>;");
        if (isGeoPackage) {
            System.out.println("\tcontents [name]   - List GeoPackage contents (all or LIKE table name)");
            System.out.println("\t" + ContentsDataType.ATTRIBUTES.getName() + " [name] - List GeoPackage attributes tables (all or LIKE table name)");
            System.out.println("\t" + ContentsDataType.FEATURES.getName() + " [name]   - List GeoPackage feature tables (all or LIKE table name)");
            System.out.println("\t" + ContentsDataType.TILES.getName() + " [name]      - List GeoPackage tile tables (all or LIKE table name)");
            System.out.println("\tginfo <name>      - Query GeoPackage metadata for the table name");
            System.out.println("\textensions [name] - List GeoPackage extensions (all or LIKE table name)");
        }
        System.out.println();
        System.out.println("Special Supported Cases:");
        System.out.println();
        System.out.println("\tDrop Column  - Not natively supported in SQLite");
        System.out.println("\t                  * ALTER TABLE table_name DROP column_name");
        System.out.println("\t                  * ALTER TABLE table_name DROP COLUMN column_name");
        System.out.println("\tCopy Table   - Not a traditional SQL statment");
        System.out.println("\t                  * ALTER TABLE table_name COPY TO new_table_name");
        if (isGeoPackage) {
            System.out.println("\tRename Table - User tables are updated throughout the GeoPackage");
            System.out.println("\t                  * ALTER TABLE table_name RENAME TO new_table_name");
            System.out.println("\tDrop Table   - User tables are dropped throughout the GeoPackage");
            System.out.println("\t                  * DROP TABLE table_name");
        }
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, int historyNumber, Integer maxRows, List<String> history) throws SQLException {
        int number = historyNumber;
        number = number < 0 ? (number += history.size()) : --number;
        if (number >= 0 && number < history.size()) {
            String sql = history.get(number);
            System.out.println(sql);
            SQLExec.executeSQL(database, sqlBuilder, sql, maxRows, history);
        } else {
            System.out.println("No History at " + historyNumber);
            SQLExec.resetCommandPrompt(sqlBuilder);
        }
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Integer maxRows, List<String> history) throws SQLException {
        SQLExec.executeSQL(database, sqlBuilder, sql, maxRows, history, true);
    }

    private static void executeSQL(GeoPackage database, StringBuilder sqlBuilder, String sql, Integer maxRows, List<String> history, boolean resetCommandPrompt) throws SQLException {
        SQLExecResult result = SQLExec.executeSQL(database, sql, maxRows);
        result.printResults();
        history.add(sql);
        if (resetCommandPrompt) {
            SQLExec.resetCommandPrompt(sqlBuilder);
        }
    }

    private static void resetCommandPrompt(StringBuilder sqlBuilder) {
        sqlBuilder.setLength(0);
        System.out.println();
        System.out.print(COMMAND_PROMPT);
    }

    public static SQLExecResult executeSQL(File databaseFile, String sql) throws SQLException {
        return SQLExec.executeSQL(databaseFile, sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLExecResult executeSQL(File databaseFile, String sql, Integer maxRows) throws SQLException {
        SQLExecResult result = null;
        try (GeoPackage database = GeoPackageManager.open(databaseFile);){
            result = SQLExec.executeSQL(database, sql, maxRows);
        }
        return result;
    }

    public static SQLExecResult executeSQL(GeoPackage database, String sql) throws SQLException {
        return SQLExec.executeSQL(database, sql, null);
    }

    public static SQLExecResult executeSQL(GeoPackage database, String sql, Integer maxRows) throws SQLException {
        SQLExecResult result;
        if (maxRows == null) {
            maxRows = 100;
        }
        sql = sql.trim();
        RTreeIndexExtension rtree = new RTreeIndexExtension(database);
        if (rtree.has()) {
            rtree.createAllFunctions();
        }
        if ((result = SQLExecAlterTable.alterTable(database, sql)) == null) {
            result = SQLExec.executeQuery(database, sql, maxRows);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SQLExecResult executeQuery(GeoPackage database, String sql, int maxRows) throws SQLException {
        SQLExecResult result = new SQLExecResult();
        if (!sql.equals(";")) {
            PreparedStatement statement;
            block12: {
                statement = null;
                try {
                    statement = database.getConnection().getConnection().prepareStatement(sql);
                    statement.setMaxRows(maxRows);
                    result.setMaxRows(maxRows);
                    boolean hasResultSet = statement.execute();
                    if (hasResultSet) {
                        ResultSet resultSet = statement.getResultSet();
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int numColumns = metadata.getColumnCount();
                        int[] columnWidths = new int[numColumns];
                        int[] columnTypes = new int[numColumns];
                        for (int col = 1; col <= numColumns; ++col) {
                            result.addTable(metadata.getTableName(col));
                            String columnName = metadata.getColumnName(col);
                            result.addColumn(columnName);
                            columnTypes[col - 1] = metadata.getColumnType(col);
                            columnWidths[col - 1] = columnName.length();
                        }
                        while (resultSet.next()) {
                            ArrayList<String> row = new ArrayList<String>();
                            result.addRow(row);
                            for (int col = 1; col <= numColumns; ++col) {
                                String stringValue = resultSet.getString(col);
                                if (stringValue != null) {
                                    switch (columnTypes[col - 1]) {
                                        case 2004: {
                                            stringValue = BLOB_DISPLAY_VALUE;
                                            break;
                                        }
                                        default: {
                                            stringValue = stringValue.replaceAll("\\s*[\\r\\n]+\\s*", " ");
                                        }
                                    }
                                    int valueLength = stringValue.length();
                                    if (valueLength > columnWidths[col - 1]) {
                                        columnWidths[col - 1] = valueLength;
                                    }
                                }
                                row.add(stringValue);
                            }
                        }
                        result.addColumnWidths(columnWidths);
                        break block12;
                    }
                    int updateCount = statement.getUpdateCount();
                    if (updateCount < 0) break block12;
                    result.setUpdateCount(updateCount);
                }
                catch (Throwable throwable) {
                    SQLUtils.closeStatement(statement, sql);
                    throw throwable;
                }
            }
            SQLUtils.closeStatement(statement, sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBlobs(GeoPackage database, StringBuilder sqlBuilder, Integer maxRows, List<String> history, String args) throws SQLException, IOException {
        if (history.isEmpty()) {
            System.out.println("No previous query with blobs");
        } else {
            boolean valid = true;
            String extension = null;
            String directory = null;
            String pattern = null;
            ArrayList<String> patternColumns = new ArrayList<String>();
            if (args != null && !args.isEmpty()) {
                String[] argParts = args.trim().split("\\s+");
                block12: for (int i = 0; valid && i < argParts.length; ++i) {
                    String arg = argParts[i];
                    if (arg.startsWith(ARGUMENT_PREFIX)) {
                        String argument;
                        switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                            case "e": {
                                if (i < argParts.length) {
                                    extension = argParts[++i];
                                    break;
                                }
                                valid = false;
                                System.out.println("Error: Blobs extension argument '" + arg + "' must be followed by a file extension");
                                break;
                            }
                            case "d": {
                                if (i < argParts.length) {
                                    directory = argParts[++i];
                                    break;
                                }
                                valid = false;
                                System.out.println("Error: Blobs directory argument '" + arg + "' must be followed by a directory location");
                                break;
                            }
                            case "p": {
                                if (i < argParts.length) {
                                    pattern = argParts[++i];
                                    Matcher matcher = BLOBS_COLUMN_PATTERN.matcher(pattern);
                                    while (matcher.find()) {
                                        String columnName = matcher.group(1);
                                        patternColumns.add(columnName);
                                    }
                                    if (!patternColumns.isEmpty()) continue block12;
                                    valid = false;
                                    System.out.println("Error: Blobs pattern argument '" + arg + "' must be followed by a save pattern with at least one column surrounded by parentheses");
                                    break;
                                }
                                valid = false;
                                System.out.println("Error: Blobs pattern argument '" + arg + "' must be followed by a save pattern");
                                break;
                            }
                            default: {
                                valid = false;
                                System.out.println("Error: Unsupported arg: '" + arg + "'");
                            }
                        }
                        continue;
                    }
                    valid = false;
                    System.out.println("Error: Unsupported arg: '" + arg + "'");
                }
            }
            if (valid) {
                PreparedStatement statement;
                int blobsWrittenCount;
                LinkedHashSet<String> blobsWritten;
                String sql;
                block47: {
                    sql = history.get(history.size() - 1);
                    if (maxRows == null) {
                        maxRows = 100;
                    }
                    blobsWritten = new LinkedHashSet<String>();
                    blobsWrittenCount = 0;
                    statement = null;
                    try {
                        int col;
                        statement = database.getConnection().getConnection().prepareStatement(sql);
                        statement.setMaxRows(maxRows);
                        boolean hasResultSet = statement.execute();
                        if (!hasResultSet) break block47;
                        ResultSet resultSet = statement.getResultSet();
                        ResultSetMetaData metadata = resultSet.getMetaData();
                        int numColumns = metadata.getColumnCount();
                        ArrayList<Integer> blobColumns = new ArrayList<Integer>();
                        ArrayList<String> tables = new ArrayList<String>();
                        ArrayList<String> columnNames = new ArrayList<String>();
                        HashMap tableNameColumns = new HashMap();
                        HashMap<String, Integer> columnNameIndexes = new HashMap<String, Integer>();
                        for (col = 1; col <= numColumns; ++col) {
                            columnNameIndexes.put(metadata.getColumnName(col), col);
                        }
                        for (col = 1; col <= numColumns; ++col) {
                            if (metadata.getColumnType(col) != 2004) continue;
                            blobColumns.add(col);
                            String tableName = metadata.getTableName(col);
                            ArrayList<Integer> nameColumns = (ArrayList<Integer>)tableNameColumns.get(tableName);
                            if (nameColumns == null) {
                                nameColumns = new ArrayList<Integer>();
                                TableInfo tableInfo = TableInfo.info((GeoPackageCoreConnection)database.getConnection(), (String)tableName);
                                ArrayList<String> nameColumnNames = null;
                                if (pattern != null) {
                                    nameColumnNames = patternColumns;
                                } else if (tableInfo.hasPrimaryKey()) {
                                    nameColumnNames = new ArrayList();
                                    for (TableColumn tableColumn : tableInfo.getPrimaryKeys()) {
                                        nameColumnNames.add(tableColumn.getName());
                                    }
                                }
                                if (nameColumnNames != null) {
                                    for (String columnName : nameColumnNames) {
                                        Integer columnIndex = (Integer)columnNameIndexes.get(columnName);
                                        if (columnIndex == null && pattern != null) {
                                            throw new IllegalArgumentException("Pattern column not found in query: " + columnName);
                                        }
                                        nameColumns.add(columnIndex);
                                    }
                                }
                                tableNameColumns.put(tableName, nameColumns);
                            }
                            tables.add(tableName);
                            columnNames.add(metadata.getColumnName(col));
                        }
                        if (!blobColumns.isEmpty()) {
                            if (extension != null && !extension.startsWith(".")) {
                                extension = "." + extension;
                            }
                            if (directory == null) {
                                directory = "blobs";
                            }
                            File blobsDirectory = new File(directory);
                            int resultCount = 0;
                            while (resultSet.next()) {
                                ++resultCount;
                                for (int i = 0; i < blobColumns.size(); ++i) {
                                    List nameColumns;
                                    int col2 = (Integer)blobColumns.get(i);
                                    byte[] blobBytes = resultSet.getBytes(col2);
                                    if (blobBytes == null) continue;
                                    String tableName = (String)tables.get(i);
                                    File tableDirectory = new File(blobsDirectory, tableName);
                                    File columnDirectory = new File(tableDirectory, (String)columnNames.get(i));
                                    String name = null;
                                    if (pattern != null) {
                                        name = pattern;
                                    }
                                    if (!(nameColumns = (List)tableNameColumns.get(tableName)).isEmpty()) {
                                        for (int j = 0; j < nameColumns.size(); ++j) {
                                            String columnValue;
                                            Integer nameColumn = (Integer)nameColumns.get(j);
                                            if (nameColumn == null || (columnValue = resultSet.getString(nameColumn)) == null) continue;
                                            if (pattern != null) {
                                                String columnName = (String)patternColumns.get(j);
                                                name = name.replaceAll(BLOBS_COLUMN_START_REGEX + columnName + BLOBS_COLUMN_END_REGEX, columnValue);
                                                continue;
                                            }
                                            name = name == null ? columnValue : name + ARGUMENT_PREFIX + columnValue;
                                        }
                                    }
                                    if (name == null) {
                                        name = String.valueOf(resultCount);
                                    }
                                    if (extension != null) {
                                        name = name + extension;
                                    }
                                    File blobFile = new File(columnDirectory, name);
                                    blobFile.getParentFile().mkdirs();
                                    FileOutputStream fos = new FileOutputStream(blobFile);
                                    fos.write(blobBytes);
                                    fos.close();
                                    ++blobsWrittenCount;
                                    blobsWritten.add(columnDirectory.getAbsolutePath());
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.closeStatement(statement, sql);
                        throw throwable;
                    }
                }
                SQLUtils.closeStatement(statement, sql);
                if (blobsWrittenCount <= 0) {
                    System.out.println("No Blobs in previous query: " + sql);
                } else {
                    System.out.println(blobsWrittenCount + " Blobs written to:");
                    for (String location : blobsWritten) {
                        System.out.println(location);
                    }
                }
            }
        }
        SQLExec.resetCommandPrompt(sqlBuilder);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-m max_rows] sqlite_file [sql]");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tExecutes SQL on a SQLite database");
        System.out.println();
        System.out.println("\tProvide the SQL to execute a single statement. Omit to start an interactive session.");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-m max_rows");
        System.out.println("\t\tMax rows to query and display (Default is 100)");
        System.out.println();
        System.out.println("\tsqlite_file");
        System.out.println("\t\tpath to the SQLite database file");
        System.out.println();
        System.out.println("\tsql");
        System.out.println("\t\tSQL statement to execute");
        System.out.println();
    }

    public static boolean isGeoPackage(GeoPackage database) {
        return GeoPackageValidate.hasMinimumTables((GeoPackageCore)database);
    }
}

