/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.File;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.features.OAPIFeatureGenerator;
import mil.nga.geopackage.io.GeoPackageTextOutput;
import mil.nga.geopackage.io.Progress;
import mil.nga.geopackage.manager.GeoPackageManager;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionFactory;

public class OAPIFeatureGen {
    private static final Logger LOGGER = Logger.getLogger(OAPIFeatureGen.class.getName());
    private static final int LOG_FEATURE_FREQUENCY = 1000;
    private static final int LOG_FEATURE_TIME_FREQUENCY = 60;
    public static final String ARGUMENT_PREFIX = "-";
    public static final String ARGUMENT_LIMIT = "limit";
    public static final String ARGUMENT_BOUNDING_BOX = "bbox";
    public static final String ARGUMENT_BOUNDING_BOX_PROJECTION = "bbox-proj";
    public static final String ARGUMENT_TIME = "time";
    public static final String ARGUMENT_PROJECTION = "proj";
    public static final String ARGUMENT_TOTAL_LIMIT = "totalLimit";
    public static final String ARGUMENT_TRANSACTION_LIMIT = "transactionLimit";
    public static final String ARGUMENT_LOG_COUNT = "logCount";
    public static final String ARGUMENT_LOG_TIME = "logTime";
    private static Progress progress = new Progress("OGC API Feature Generation", "features", 1000, 60);
    private static File geoPackageFile = null;
    private static GeoPackage geoPackage = null;
    private static String tableName = null;
    private static String server = null;
    private static String id = null;
    private static Integer limit = null;
    private static BoundingBox boundingBox = null;
    private static Projection boundingBoxProjection = null;
    private static String time = null;
    private static Projection projection = null;
    private static Integer totalLimit = null;
    private static Integer transactionLimit = null;

    public static void main(String[] args) {
        final Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                progress.cancel();
                try {
                    mainThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARNING, "Failed to wait for the main thread to finish", e);
                }
            }
        });
        boolean valid = true;
        boolean requiredArguments = false;
        for (int i = 0; valid && i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith(ARGUMENT_PREFIX)) {
                String argument;
                switch (argument = arg.substring(ARGUMENT_PREFIX.length())) {
                    case "limit": {
                        if (i < args.length) {
                            limit = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Limit argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "bbox": {
                        if (i < args.length) {
                            String bbox;
                            String[] bboxParts;
                            if ((bboxParts = (bbox = args[++i]).split(",")).length != 4) {
                                valid = false;
                                System.out.println("Error: Bounding Box argument '" + arg + "' value must be in the format: minLon,minLat,maxLon,maxLat");
                                break;
                            }
                            double minLon = Double.valueOf(bboxParts[0]);
                            double minLat = Double.valueOf(bboxParts[1]);
                            double maxLon = Double.valueOf(bboxParts[2]);
                            double maxLat = Double.valueOf(bboxParts[3]);
                            boundingBox = new BoundingBox(minLon, minLat, maxLon, maxLat);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Bounding Box argument '" + arg + "' must be followed by bbox values: minLon,minLat,maxLon,maxLat");
                        break;
                    }
                    case "bbox-proj": {
                        String proj;
                        String[] projParts;
                        if (i < args.length) {
                            if ((projParts = (proj = args[++i]).split(",")).length != 2) {
                                valid = false;
                                System.out.println("Error: Bounding Box Projection argument '" + arg + "' value must be in the format: authority,code");
                                break;
                            }
                            boundingBoxProjection = ProjectionFactory.getProjection((String)projParts[0], (String)projParts[1]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Bounding Box Projection argument '" + arg + "' must be followed by projection values: authority,code");
                        break;
                    }
                    case "time": {
                        if (i < args.length) {
                            time = args[++i];
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Time argument '" + arg + "' must be followed by a date-time or a period string that adheres to RFC 3339");
                        break;
                    }
                    case "proj": {
                        String proj;
                        String[] projParts;
                        if (i < args.length) {
                            if ((projParts = (proj = args[++i]).split(",")).length != 2) {
                                valid = false;
                                System.out.println("Error: Projection argument '" + arg + "' value must be in the format: authority,code");
                                break;
                            }
                            projection = ProjectionFactory.getProjection((String)projParts[0], (String)projParts[1]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Projection argument '" + arg + "' must be followed by projection values: authority,code");
                        break;
                    }
                    case "totalLimit": {
                        if (i < args.length) {
                            totalLimit = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Total Limit argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "transactionLimit": {
                        if (i < args.length) {
                            transactionLimit = Integer.valueOf(args[++i]);
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Transaction Limit argument '" + arg + "' must be followed by a value");
                        break;
                    }
                    case "logCount": {
                        if (i < args.length) {
                            progress.setCountFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Count argument '" + arg + "' must be followed by a frequency count value");
                        break;
                    }
                    case "logTime": {
                        if (i < args.length) {
                            progress.setTimeFrequency(Integer.valueOf(args[++i]));
                            break;
                        }
                        valid = false;
                        System.out.println("Error: Log Time argument '" + arg + "' must be followed by a frequency time value in seconds");
                        break;
                    }
                    default: {
                        valid = false;
                        System.out.println("Error: Unsupported arg: '" + arg + "'");
                    }
                }
                continue;
            }
            if (geoPackageFile == null) {
                geoPackageFile = new File(arg);
                continue;
            }
            if (tableName == null) {
                tableName = arg;
                continue;
            }
            if (server == null) {
                server = arg;
                continue;
            }
            if (id == null) {
                id = arg;
                requiredArguments = true;
                continue;
            }
            valid = false;
            System.out.println("Error: Unsupported extra argument: " + arg);
        }
        if (!valid || !requiredArguments) {
            OAPIFeatureGen.printUsage();
        } else {
            try {
                OAPIFeatureGen.generate();
            }
            catch (Exception e) {
                OAPIFeatureGen.printUsage();
                throw e;
            }
        }
    }

    public static void generate() {
        if (!geoPackageFile.exists() && !GeoPackageManager.create(geoPackageFile)) {
            throw new GeoPackageException("Failed to create GeoPackage file: " + geoPackageFile.getAbsolutePath());
        }
        geoPackage = GeoPackageManager.open(geoPackageFile);
        OAPIFeatureGenerator featureGenerator = new OAPIFeatureGenerator(geoPackage, tableName, server, id);
        featureGenerator.setLimit(limit);
        featureGenerator.setBoundingBox(boundingBox);
        featureGenerator.setBoundingBoxProjection(boundingBoxProjection);
        featureGenerator.setTime(time);
        featureGenerator.setProjection(projection);
        featureGenerator.setTotalLimit(totalLimit);
        if (transactionLimit != null) {
            featureGenerator.setTransactionLimit(transactionLimit);
        }
        System.out.println();
        System.out.println("GeoPackage: " + geoPackage.getName());
        System.out.println("Feature Table: " + tableName);
        System.out.println("Server: " + server);
        System.out.println("Collection Id: " + id);
        if (limit != null) {
            System.out.println("Limit: " + limit);
        }
        if (boundingBox != null) {
            System.out.println("Bounding Box:");
            System.out.println("\tMin Lon: " + boundingBox.getMinLongitude());
            System.out.println("\tMin Lat: " + boundingBox.getMinLatitude());
            System.out.println("\tMax Lon: " + boundingBox.getMaxLongitude());
            System.out.println("\tMax Lat: " + boundingBox.getMaxLatitude());
        }
        if (boundingBoxProjection != null) {
            System.out.println("Bounding Box Projection: " + boundingBoxProjection.getAuthority() + "," + boundingBoxProjection.getCode());
        }
        if (time != null) {
            System.out.println("Time: " + time);
        }
        if (projection != null) {
            System.out.println("Projection: " + projection.getAuthority() + "," + projection.getCode());
        }
        if (totalLimit != null) {
            System.out.println("Total Limit: " + totalLimit);
        }
        if (transactionLimit != null) {
            System.out.println("Transaction Limit: " + transactionLimit);
        }
        System.out.println("Log Count Frequency: " + progress.getCountFrequency() + " features");
        System.out.println("Log Time Frequency: " + progress.getTimeFrequency() + " seconds");
        System.out.println();
        featureGenerator.setProgress(progress);
        LOGGER.log(Level.INFO, "Generating Features...");
        try {
            featureGenerator.generateFeatures();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Exception while generating features", (Throwable)e);
        }
        OAPIFeatureGen.finish();
    }

    private static void finish() {
        if (progress.getMax() != null) {
            StringBuilder output = new StringBuilder();
            output.append("\nFeature Generation: ").append(progress.getProgress()).append(" of ").append(progress.getMax());
            if (geoPackage != null) {
                try {
                    GeoPackageTextOutput textOutput = new GeoPackageTextOutput(geoPackage);
                    output.append("\n\n");
                    output.append(textOutput.header());
                    output.append("\n\n");
                    output.append(textOutput.featureTable(tableName));
                }
                finally {
                    geoPackage.close();
                }
            }
            System.out.println(output.toString());
        }
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("USAGE");
        System.out.println();
        System.out.println("\t[-limit limit] [-bbox minLon,minLat,maxLon,maxLat] [-bbox-proj authority,code] [-time time] [-proj authority,code] [-totalLimit total_limit] [-transactionLimit transaction_limit] [-logCount count] [-logTime time] geopackage_file table_name server_url collection_id");
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println();
        System.out.println("\tGenerates features into a GeoPackage feature table by requesting them from an OGC API Features URL");
        System.out.println();
        System.out.println("ARGUMENTS");
        System.out.println();
        System.out.println("\t-limit limit");
        System.out.println("\t\tLimits the number of items per single server response");
        System.out.println();
        System.out.println("\t-bbox minLon,minLat,maxLon,maxLat");
        System.out.println("\t\tRequest bounding box for features with intersecting geometries (default is the world)");
        System.out.println();
        System.out.println("\t-bbox-proj authority,code");
        System.out.println("\t\tProjection of the request bounding box");
        System.out.println();
        System.out.println("\t-time time");
        System.out.println("\t\tA date-time or a period string that adheres to RFC3339 (examples: 2018-02-12T23:20:50Z, 2018-02-12T00:00:00Z/2018-03-18T12:31:12Z, 2018-02-12T00:00:00Z/P1M6DT12H31M12S)");
        System.out.println();
        System.out.println("\t-proj authority,code");
        System.out.println("\t\tRequest projection");
        System.out.println();
        System.out.println("\t-totalLimit total_limit");
        System.out.println("\t\tTotal limit or max number of features to request from the server");
        System.out.println();
        System.out.println("\t-transactionLimit transaction_limit");
        System.out.println("\t\tLimit on number of features to insert into the GeoPackage in a single transaction");
        System.out.println();
        System.out.println("\t-logCount count");
        System.out.println("\t\tLog frequency count of generated features (default is 1000)");
        System.out.println();
        System.out.println("\t-logTime time");
        System.out.println("\t\tLog frequency time in seconds (default is 60)");
        System.out.println();
        System.out.println("\tgeopackage_file");
        System.out.println("\t\tpath to the GeoPackage file to create, or existing file to update");
        System.out.println();
        System.out.println("\ttable_name");
        System.out.println("\t\tfeature table name within the GeoPackage file to create or update");
        System.out.println();
        System.out.println("\tserver_url");
        System.out.println("\t\tOGC API Features base server URL");
        System.out.println();
        System.out.println("\tcollection_id");
        System.out.println("\t\tOGC API Features collection identifier");
        System.out.println();
    }
}

