/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileDao;

public class GeoPackageTextOutput {
    private final GeoPackage geoPackage;

    public GeoPackageTextOutput(GeoPackage geoPackage) {
        this.geoPackage = geoPackage;
    }

    public String header() {
        StringBuilder output = new StringBuilder();
        output.append("GeoPackage File: " + this.geoPackage.getPath());
        output.append("\nGeoPackage Name: " + this.geoPackage.getName());
        return output.toString();
    }

    public String tileTable(String table) {
        StringBuilder output = new StringBuilder();
        TileDao tileDao = this.geoPackage.getTileDao(table);
        output.append("Table Name: " + tileDao.getTableName());
        long minZoom = tileDao.getMinZoom();
        long maxZoom = tileDao.getMaxZoom();
        output.append("\nMin Zoom: " + minZoom);
        output.append("\nMax Zoom: " + maxZoom);
        output.append("\nTiles: " + tileDao.count());
        TileMatrixSet tileMatrixSet = tileDao.getTileMatrixSet();
        output.append("\n\nContents\n\n").append(this.textOutput(tileMatrixSet.getContents()));
        output.append("\n\nTile Matrix Set\n\n").append(this.textOutput(tileMatrixSet));
        output.append("\n\n Tile Matrices");
        for (long zoom = minZoom; zoom <= maxZoom; ++zoom) {
            TileMatrix tileMatrix = tileDao.getTileMatrix(zoom);
            if (tileMatrix == null) continue;
            output.append("\n\n").append(this.textOutput(tileMatrix));
            output.append("\n\tTiles: " + tileDao.count(zoom));
            BoundingBox boundingBox = tileDao.getBoundingBox(zoom);
            output.append("\n\tTile Bounds: \n").append(this.textOutput(boundingBox));
        }
        return output.toString();
    }

    public String featureTable(String table) {
        StringBuilder output = new StringBuilder();
        FeatureDao featureDao = this.geoPackage.getFeatureDao(table);
        output.append("Table Name: " + featureDao.getTableName());
        output.append("\nFeatures: " + featureDao.count());
        GeometryColumns geometryColumns = featureDao.getGeometryColumns();
        output.append("\n\nContents\n\n").append(this.textOutput(geometryColumns.getContents()));
        output.append("\n\nGeometry Columns\n\n").append(this.textOutput(geometryColumns));
        return output.toString();
    }

    public String textOutput(SpatialReferenceSystem srs) {
        StringBuilder output = new StringBuilder();
        output.append("\tSRS organization: " + srs.getOrganization());
        output.append("\n\tSRS organization_coordsys_id: " + srs.getOrganizationCoordsysId());
        output.append("\n\tSRS definition: " + srs.getDefinition());
        return output.toString();
    }

    public String textOutput(Contents contents) {
        StringBuilder output = new StringBuilder();
        output.append("\ttable_name: " + contents.getTableName());
        output.append("\n\tdata_type: " + contents.getDataType());
        output.append("\n\tidentifier: " + contents.getIdentifier());
        output.append("\n\tdescription: " + contents.getDescription());
        output.append("\n\tlast_change: " + contents.getLastChange());
        output.append("\n\tmin_x: " + contents.getMinX());
        output.append("\n\tmin_y: " + contents.getMinY());
        output.append("\n\tmax_x: " + contents.getMaxX());
        output.append("\n\tmax_y: " + contents.getMaxY());
        output.append("\n" + this.textOutput(contents.getSrs()));
        return output.toString();
    }

    public String textOutput(TileMatrixSet tileMatrixSet) {
        StringBuilder output = new StringBuilder();
        output.append("\ttable_name: " + tileMatrixSet.getTableName());
        output.append("\n" + this.textOutput(tileMatrixSet.getSrs()));
        output.append("\n\tmin_x: " + tileMatrixSet.getMinX());
        output.append("\n\tmin_y: " + tileMatrixSet.getMinY());
        output.append("\n\tmax_x: " + tileMatrixSet.getMaxX());
        output.append("\n\tmax_y: " + tileMatrixSet.getMaxY());
        return output.toString();
    }

    public String textOutput(TileMatrix tileMatrix) {
        StringBuilder output = new StringBuilder();
        output.append("\ttable_name: " + tileMatrix.getTableName());
        output.append("\n\tzoom_level: " + tileMatrix.getZoomLevel());
        output.append("\n\tmatrix_width: " + tileMatrix.getMatrixWidth());
        output.append("\n\tmatrix_height: " + tileMatrix.getMatrixHeight());
        output.append("\n\ttile_width: " + tileMatrix.getTileWidth());
        output.append("\n\ttile_height: " + tileMatrix.getTileHeight());
        output.append("\n\tpixel_x_size: " + tileMatrix.getPixelXSize());
        output.append("\n\tpixel_y_size: " + tileMatrix.getPixelYSize());
        return output.toString();
    }

    public String textOutput(BoundingBox boundingBox) {
        StringBuilder output = new StringBuilder();
        output.append("\tMin Longitude: " + boundingBox.getMinLongitude());
        output.append("\n\tMin Latitude: " + boundingBox.getMinLatitude());
        output.append("\n\tMax Longitude: " + boundingBox.getMaxLongitude());
        output.append("\n\tMax Latitude: " + boundingBox.getMaxLatitude());
        return output.toString();
    }

    public String textOutput(GeometryColumns geometryColumns) {
        StringBuilder output = new StringBuilder();
        output.append("\ttable_name: " + geometryColumns.getTableName());
        output.append("\n\tcolumn_name: " + geometryColumns.getColumnName());
        output.append("\n\tgeometry_type_name: " + geometryColumns.getGeometryTypeName());
        output.append("\n" + this.textOutput(geometryColumns.getSrs()));
        output.append("\n\tz: " + geometryColumns.getZ());
        output.append("\n\tm: " + geometryColumns.getM());
        return output.toString();
    }
}

