/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.ArrayList;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.ManualFeatureQueryResults;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;

public class ManualFeatureQuery {
    private final FeatureDao featureDao;
    protected int chunkLimit = 1000;
    protected double tolerance = 1.0E-14;

    public ManualFeatureQuery(FeatureDao featureDao) {
        this.featureDao = featureDao;
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public int getChunkLimit() {
        return this.chunkLimit;
    }

    public void setChunkLimit(int chunkLimit) {
        this.chunkLimit = chunkLimit;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public FeatureResultSet query() {
        return (FeatureResultSet)this.featureDao.query();
    }

    public FeatureResultSet query(String[] columns) {
        return (FeatureResultSet)this.featureDao.query(columns);
    }

    public int count() {
        return this.featureDao.count();
    }

    public int countWithGeometries() {
        return this.featureDao.count(CoreSQLUtils.quoteWrap((String)this.featureDao.getGeometryColumnName()) + " IS NOT NULL", null);
    }

    public FeatureResultSet query(Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.query(where, whereArgs);
    }

    public FeatureResultSet query(String[] columns, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.query(columns, where, whereArgs);
    }

    public int count(Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.featureDao.count(where, whereArgs);
    }

    public FeatureResultSet query(String where) {
        return (FeatureResultSet)this.featureDao.query(where);
    }

    public FeatureResultSet query(String[] columns, String where) {
        return (FeatureResultSet)this.featureDao.query(columns, where);
    }

    public int count(String where) {
        return this.featureDao.count(where);
    }

    public FeatureResultSet query(String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.query(where, whereArgs);
    }

    public FeatureResultSet query(String[] columns, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.query(columns, where, whereArgs);
    }

    public int count(String where, String[] whereArgs) {
        return this.featureDao.count(where, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoundingBox getBoundingBox() {
        GeometryEnvelope envelope = null;
        long offset = 0L;
        boolean hasResults = true;
        String[] columns = new String[]{this.featureDao.getGeometryColumnName()};
        while (hasResults) {
            hasResults = false;
            try (FeatureResultSet resultSet = (FeatureResultSet)this.featureDao.queryForChunk(columns, this.chunkLimit, offset);){
                while (resultSet.moveToNext()) {
                    hasResults = true;
                    FeatureRow featureRow = (FeatureRow)resultSet.getRow();
                    GeometryEnvelope featureEnvelope = featureRow.getGeometryEnvelope();
                    if (featureEnvelope == null) continue;
                    if (envelope == null) {
                        envelope = featureEnvelope;
                        continue;
                    }
                    envelope = envelope.union(featureEnvelope);
                }
            }
            offset += (long)this.chunkLimit;
        }
        BoundingBox boundingBox = null;
        if (envelope != null) {
            boundingBox = new BoundingBox(envelope);
        }
        return boundingBox;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null && projection != null) {
            ProjectionTransform projectionTransform = this.featureDao.getProjection().getTransformation(projection);
            boundingBox = boundingBox.transform(projectionTransform);
        }
        return boundingBox;
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox) {
        return this.query(boundingBox.buildEnvelope());
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox) {
        return this.query(columns, boundingBox.buildEnvelope());
    }

    public long count(BoundingBox boundingBox) {
        return this.count(boundingBox.buildEnvelope());
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(boundingBox.buildEnvelope(), fieldValues);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public long count(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.count(boundingBox.buildEnvelope(), fieldValues);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, String where) {
        return this.query(boundingBox, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, String where) {
        return this.query(columns, boundingBox, where, null);
    }

    public long count(BoundingBox boundingBox, String where) {
        return this.count(boundingBox, where, null);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public long count(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.count(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox);
    }

    public long count(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox, fieldValues);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox, fieldValues);
    }

    public long count(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox, fieldValues);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection, String where) {
        return this.query(boundingBox, projection, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(columns, boundingBox, projection, where, null);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where) {
        return this.count(boundingBox, projection, where, null);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox, where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox, where, whereArgs);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox, where, whereArgs);
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope) {
        return this.query(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope) {
        return this.query(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public long count(GeometryEnvelope envelope) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public long count(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope, String where) {
        return this.query(envelope, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope, String where) {
        return this.query(columns, envelope, where, null);
    }

    public long count(GeometryEnvelope envelope, String where) {
        return this.count(envelope, where, null);
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public long count(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY) {
        return this.query(minX, minY, maxX, maxY, null, null);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY) {
        return this.query(columns, minX, minY, maxX, maxY, null, null);
    }

    public long count(double minX, double minY, double maxX, double maxY) {
        return this.query(minX, minY, maxX, maxY).count();
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(minX, minY, maxX, maxY, where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(columns, minX, minY, maxX, maxY, where, whereArgs);
    }

    public long count(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.count(minX, minY, maxX, maxY, where, whereArgs);
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY, String where) {
        return this.query(minX, minY, maxX, maxY, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY, String where) {
        return this.query(columns, minX, minY, maxX, maxY, where, null);
    }

    public long count(double minX, double minY, double maxX, double maxY, String where) {
        return this.count(minX, minY, maxX, maxY, where, null);
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.query(this.featureDao.getColumnNames(), minX, minY, maxX, maxY, where, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        ArrayList<Long> featureIds = new ArrayList<Long>();
        long offset = 0L;
        boolean hasResults = true;
        minX -= this.tolerance;
        maxX += this.tolerance;
        minY -= this.tolerance;
        maxY += this.tolerance;
        String[] queryColumns = this.featureDao.getIdAndGeometryColumnNames();
        while (hasResults) {
            hasResults = false;
            try (FeatureResultSet resultSet = (FeatureResultSet)this.featureDao.queryForChunk(queryColumns, where, whereArgs, this.chunkLimit, offset);){
                while (resultSet.moveToNext()) {
                    hasResults = true;
                    FeatureRow featureRow = (FeatureRow)resultSet.getRow();
                    GeometryEnvelope envelope = featureRow.getGeometryEnvelope();
                    if (envelope == null) continue;
                    double minXMax = Math.max(minX, envelope.getMinX());
                    double maxXMin = Math.min(maxX, envelope.getMaxX());
                    double minYMax = Math.max(minY, envelope.getMinY());
                    double maxYMin = Math.min(maxY, envelope.getMaxY());
                    if (!(minXMax <= maxXMin) || !(minYMax <= maxYMin)) continue;
                    featureIds.add(featureRow.getId());
                }
            }
            offset += (long)this.chunkLimit;
        }
        ManualFeatureQueryResults results = new ManualFeatureQueryResults(this.featureDao, columns, featureIds);
        return results;
    }

    public long count(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.query(minX, minY, maxX, maxY, where, whereArgs).count();
    }
}

