/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.io.IOException;
import java.util.Arrays;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureColumns;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.user.ContentValues;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserRow;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.GeometryType;

public class FeatureRow
extends UserRow<FeatureColumn, FeatureTable> {
    FeatureRow(FeatureTable table, FeatureColumns columns, int[] columnTypes, Object[] values) {
        super(table, columns, columnTypes, values);
    }

    FeatureRow(FeatureTable table) {
        super(table);
    }

    public FeatureRow(FeatureRow featureRow) {
        super(featureRow);
    }

    public FeatureColumns getColumns() {
        return (FeatureColumns)super.getColumns();
    }

    public void setValue(int index, Object value) {
        if (index == this.getGeometryColumnIndex() && value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            value = new GeoPackageGeometryData(bytes);
        }
        super.setValue(index, value);
    }

    protected Object copyValue(FeatureColumn column, Object value) {
        Object copyValue = null;
        if (column.isGeometry() && value instanceof GeoPackageGeometryData) {
            GeoPackageGeometryData geometryData = (GeoPackageGeometryData)value;
            try {
                byte[] bytes = geometryData.toBytes();
                byte[] copyBytes = Arrays.copyOf(bytes, bytes.length);
                copyValue = new GeoPackageGeometryData(copyBytes);
            }
            catch (IOException e) {
                throw new GeoPackageException("Failed to copy Geometry Data bytes. column: " + column.getName(), (Throwable)e);
            }
        } else {
            copyValue = super.copyValue((UserColumn)column, value);
        }
        return copyValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void columnToContentValue(ContentValues contentValues, FeatureColumn column, Object value) {
        if (column.isGeometry()) {
            String columnName = column.getName();
            if (value instanceof GeoPackageGeometryData) {
                GeoPackageGeometryData geometryData = (GeoPackageGeometryData)value;
                try {
                    contentValues.put(columnName, geometryData.toBytes());
                    return;
                }
                catch (IOException e) {
                    throw new GeoPackageException("Failed to write Geometry Data bytes. column: " + columnName, (Throwable)e);
                }
            } else {
                if (!(value instanceof byte[])) throw new GeoPackageException("Unsupported update geometry column value type. column: " + columnName + ", value type: " + value.getClass().getName());
                contentValues.put(columnName, (byte[])value);
            }
            return;
        } else {
            super.columnToContentValue(contentValues, column, value);
        }
    }

    public int getGeometryColumnIndex() {
        return this.getColumns().getGeometryIndex();
    }

    public FeatureColumn getGeometryColumn() {
        return this.getColumns().getGeometryColumn();
    }

    public String getGeometryColumnName() {
        return this.getColumns().getGeometryColumnName();
    }

    public GeoPackageGeometryData getGeometry() {
        GeoPackageGeometryData geometryData = null;
        Object value = this.getValue(this.getGeometryColumnIndex());
        if (value != null) {
            geometryData = (GeoPackageGeometryData)value;
        }
        return geometryData;
    }

    public void setGeometry(GeoPackageGeometryData geometryData) {
        this.setValue(this.getGeometryColumnIndex(), geometryData);
    }

    public Geometry getGeometryValue() {
        GeoPackageGeometryData data = this.getGeometry();
        Geometry geometry = null;
        if (data != null) {
            geometry = data.getGeometry();
        }
        return geometry;
    }

    public GeometryType getGeometryType() {
        Geometry geometry = this.getGeometryValue();
        GeometryType geometryType = null;
        if (geometry != null) {
            geometryType = geometry.getGeometryType();
        }
        return geometryType;
    }

    public GeometryEnvelope getGeometryEnvelope() {
        GeoPackageGeometryData data = this.getGeometry();
        GeometryEnvelope envelope = null;
        if (data != null) {
            envelope = data.getOrBuildEnvelope();
        }
        return envelope;
    }

    public FeatureRow copy() {
        return new FeatureRow(this);
    }
}

