/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureConnection;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.user.UserDao;
import mil.nga.sf.GeometryType;
import mil.nga.sf.proj.Projection;

public class FeatureDao
extends UserDao<FeatureColumn, FeatureTable, FeatureRow, FeatureResultSet> {
    private final FeatureConnection featureDb = (FeatureConnection)this.getUserDb();
    private final GeometryColumns geometryColumns;

    public FeatureDao(String database, GeoPackageConnection db, GeometryColumns geometryColumns, FeatureTable table) {
        super(database, db, new FeatureConnection(db), table);
        this.geometryColumns = geometryColumns;
        if (geometryColumns.getContents() == null) {
            throw new GeoPackageException(GeometryColumns.class.getSimpleName() + " " + geometryColumns.getId() + " has null " + Contents.class.getSimpleName());
        }
        if (geometryColumns.getSrs() == null) {
            throw new GeoPackageException(GeometryColumns.class.getSimpleName() + " " + geometryColumns.getId() + " has null " + SpatialReferenceSystem.class.getSimpleName());
        }
        this.projection = geometryColumns.getProjection();
    }

    public BoundingBox getBoundingBox() {
        return this.getBoundingBox(this.projection);
    }

    public BoundingBox getBoundingBox(Projection projection) {
        Contents contents = this.geometryColumns.getContents();
        BoundingBox boundingBox = contents.getBoundingBox(projection);
        return boundingBox;
    }

    public FeatureRow newRow() {
        return new FeatureRow((FeatureTable)this.getTable());
    }

    public FeatureConnection getFeatureDb() {
        return this.featureDb;
    }

    public GeometryColumns getGeometryColumns() {
        return this.geometryColumns;
    }

    public String getGeometryColumnName() {
        return this.geometryColumns.getColumnName();
    }

    public GeometryType getGeometryType() {
        return this.geometryColumns.getGeometryType();
    }

    public FeatureColumn getIdColumn() {
        return (FeatureColumn)((FeatureTable)this.getTable()).getPkColumn();
    }

    public String getIdColumnName() {
        return ((FeatureTable)this.getTable()).getPkColumnName();
    }

    public String[] getIdAndGeometryColumnNames() {
        return ((FeatureTable)this.getTable()).getIdAndGeometryColumnNames();
    }
}

