/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.features.user.FeatureCache;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;

public class FeatureCacheTables {
    private Map<String, FeatureCache> tableCache = new HashMap<String, FeatureCache>();
    private int maxCacheSize;

    public FeatureCacheTables() {
        this(1000);
    }

    public FeatureCacheTables(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public Set<String> getTables() {
        return this.tableCache.keySet();
    }

    public FeatureCache getCache(String tableName) {
        FeatureCache cache = this.tableCache.get(tableName);
        if (cache == null) {
            cache = new FeatureCache(this.maxCacheSize);
            this.tableCache.put(tableName, cache);
        }
        return cache;
    }

    public FeatureCache getCache(FeatureRow featureRow) {
        return this.getCache(((FeatureTable)featureRow.getTable()).getTableName());
    }

    public int getMaxSize(String tableName) {
        return this.getCache(tableName).getMaxSize();
    }

    public int getSize(String tableName) {
        return this.getCache(tableName).getSize();
    }

    public FeatureRow get(String tableName, long featureId) {
        return this.getCache(tableName).get(featureId);
    }

    public FeatureRow put(FeatureRow featureRow) {
        return this.getCache(featureRow).put(featureRow);
    }

    public FeatureRow remove(FeatureRow featureRow) {
        return this.remove(((FeatureTable)featureRow.getTable()).getTableName(), featureRow.getId());
    }

    public FeatureRow remove(String tableName, long featureId) {
        return this.getCache(tableName).remove(featureId);
    }

    public void clear(String tableName) {
        this.tableCache.remove(tableName);
    }

    public void clear() {
        this.tableCache.clear();
    }

    public void resize(String tableName, int maxCacheSize) {
        this.getCache(tableName).resize(maxCacheSize);
    }

    public void resize(int maxCacheSize) {
        this.setMaxCacheSize(maxCacheSize);
        for (FeatureCache cache : this.tableCache.values()) {
            cache.resize(maxCacheSize);
        }
    }

    public void clearAndResize(String tableName, int maxCacheSize) {
        this.getCache(tableName).clearAndResize(maxCacheSize);
    }

    public void clearAndResize(int maxCacheSize) {
        this.setMaxCacheSize(maxCacheSize);
        for (FeatureCache cache : this.tableCache.values()) {
            cache.clearAndResize(maxCacheSize);
        }
    }
}

