/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mil.nga.geopackage.features.index.FeatureIndexResults;
import mil.nga.geopackage.features.user.FeatureRow;

public class MultipleFeatureIndexResults
implements FeatureIndexResults {
    private final List<FeatureIndexResults> results = new ArrayList<FeatureIndexResults>();
    private final int count;

    public MultipleFeatureIndexResults(FeatureIndexResults ... results) {
        this(Arrays.asList(results));
    }

    public MultipleFeatureIndexResults(Collection<FeatureIndexResults> results) {
        this.results.addAll(results);
        int totalCount = 0;
        for (FeatureIndexResults result : results) {
            totalCount = (int)((long)totalCount + result.count());
        }
        this.count = totalCount;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public void close() {
        for (FeatureIndexResults result : this.results) {
            result.close();
        }
    }

    @Override
    public Iterator<FeatureRow> iterator() {
        return new Iterator<FeatureRow>(){
            int index = -1;
            private Iterator<FeatureRow> currentResults = null;

            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                if (this.currentResults != null) {
                    hasNext = this.currentResults.hasNext();
                }
                if (!hasNext) {
                    while (!hasNext && ++this.index < MultipleFeatureIndexResults.this.results.size()) {
                        this.currentResults = ((FeatureIndexResults)MultipleFeatureIndexResults.this.results.get(this.index)).iterator();
                        hasNext = this.currentResults.hasNext();
                    }
                }
                return hasNext;
            }

            @Override
            public FeatureRow next() {
                FeatureRow row = null;
                if (this.currentResults != null) {
                    row = this.currentResults.next();
                }
                return row;
            }
        };
    }

    @Override
    public Iterable<Long> ids() {
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    int index = -1;
                    private Iterator<Long> currentResults = null;

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = false;
                        if (this.currentResults != null) {
                            hasNext = this.currentResults.hasNext();
                        }
                        if (!hasNext) {
                            while (!hasNext && ++this.index < MultipleFeatureIndexResults.this.results.size()) {
                                this.currentResults = ((FeatureIndexResults)MultipleFeatureIndexResults.this.results.get(this.index)).ids().iterator();
                                hasNext = this.currentResults.hasNext();
                            }
                        }
                        return hasNext;
                    }

                    @Override
                    public Long next() {
                        Long id = null;
                        if (this.currentResults != null) {
                            id = this.currentResults.next();
                        }
                        return id;
                    }
                };
            }
        };
    }
}

