/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.RTreeIndexExtension;
import mil.nga.geopackage.extension.RTreeIndexTableDao;
import mil.nga.geopackage.extension.index.FeatureTableIndex;
import mil.nga.geopackage.features.index.FeatureIndexFeatureResults;
import mil.nga.geopackage.features.index.FeatureIndexLocation;
import mil.nga.geopackage.features.index.FeatureIndexResults;
import mil.nga.geopackage.features.index.FeatureIndexType;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.ManualFeatureQuery;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.Projection;

public class FeatureIndexManager {
    private static final Logger LOGGER = Logger.getLogger(FeatureIndexManager.class.getName());
    private final FeatureDao featureDao;
    private final FeatureTableIndex featureTableIndex;
    private final RTreeIndexTableDao rTreeIndexTableDao;
    private final ManualFeatureQuery manualFeatureQuery;
    private Set<FeatureIndexType> indexLocationQueryOrder = new LinkedHashSet<FeatureIndexType>();
    private FeatureIndexType indexLocation;
    private boolean continueOnError = true;

    public FeatureIndexManager(GeoPackage geoPackage, String featureTable) {
        this(geoPackage, geoPackage.getFeatureDao(featureTable));
    }

    public FeatureIndexManager(GeoPackage geoPackage, FeatureDao featureDao) {
        this.featureDao = featureDao;
        this.featureTableIndex = new FeatureTableIndex(geoPackage, featureDao);
        RTreeIndexExtension rTreeExtension = new RTreeIndexExtension(geoPackage);
        this.rTreeIndexTableDao = rTreeExtension.getTableDao(featureDao);
        this.manualFeatureQuery = new ManualFeatureQuery(featureDao);
        this.indexLocationQueryOrder.add(FeatureIndexType.RTREE);
        this.indexLocationQueryOrder.add(FeatureIndexType.GEOPACKAGE);
    }

    public void close() {
        this.featureTableIndex.close();
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public FeatureTableIndex getFeatureTableIndex() {
        return this.featureTableIndex;
    }

    public RTreeIndexTableDao getRTreeIndexTableDao() {
        return this.rTreeIndexTableDao;
    }

    public Set<FeatureIndexType> getIndexLocationQueryOrder() {
        return Collections.unmodifiableSet(this.indexLocationQueryOrder);
    }

    public FeatureIndexType getIndexLocation() {
        return this.indexLocation;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void prioritizeQueryLocation(Collection<FeatureIndexType> types) {
        this.prioritizeQueryLocation(types.toArray(new FeatureIndexType[types.size()]));
    }

    public void prioritizeQueryLocation(FeatureIndexType ... types) {
        LinkedHashSet<FeatureIndexType> queryOrder = new LinkedHashSet<FeatureIndexType>();
        for (FeatureIndexType type : types) {
            if (type == FeatureIndexType.NONE) continue;
            queryOrder.add(type);
        }
        queryOrder.addAll(this.indexLocationQueryOrder);
        this.indexLocationQueryOrder = queryOrder;
    }

    public void setIndexLocationOrder(Collection<FeatureIndexType> types) {
        this.setIndexLocationOrder(types.toArray(new FeatureIndexType[types.size()]));
    }

    public void setIndexLocationOrder(FeatureIndexType ... types) {
        LinkedHashSet<FeatureIndexType> queryOrder = new LinkedHashSet<FeatureIndexType>();
        for (FeatureIndexType type : types) {
            if (type == FeatureIndexType.NONE) continue;
            queryOrder.add(type);
        }
        this.indexLocationQueryOrder = queryOrder;
    }

    public void setIndexLocation(FeatureIndexType indexLocation) {
        this.indexLocation = indexLocation;
    }

    public void setProgress(GeoPackageProgress progress) {
        this.featureTableIndex.setProgress(progress);
        this.rTreeIndexTableDao.setProgress(progress);
    }

    public int index() {
        return this.index(this.verifyIndexLocation(), false);
    }

    public int index(List<FeatureIndexType> types) {
        int count = 0;
        for (FeatureIndexType type : types) {
            int typeCount = this.index(type);
            count = Math.max(count, typeCount);
        }
        return count;
    }

    public int index(FeatureIndexType type) {
        return this.index(type, false);
    }

    public int index(boolean force) {
        return this.index(this.verifyIndexLocation(), force);
    }

    public int index(boolean force, List<FeatureIndexType> types) {
        int count = 0;
        for (FeatureIndexType type : types) {
            int typeCount = this.index(type, force);
            count = Math.max(count, typeCount);
        }
        return count;
    }

    public int index(FeatureIndexType type, boolean force) {
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to index");
        }
        int count = 0;
        switch (type) {
            case GEOPACKAGE: {
                count = this.featureTableIndex.index(force);
                break;
            }
            case RTREE: {
                boolean rTreeIndexed = this.rTreeIndexTableDao.has();
                if (rTreeIndexed && !force) break;
                if (rTreeIndexed) {
                    this.rTreeIndexTableDao.delete();
                }
                this.rTreeIndexTableDao.create();
                count = this.rTreeIndexTableDao.count();
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + (Object)((Object)type));
            }
        }
        return count;
    }

    public boolean index(FeatureRow row) {
        return this.index(this.verifyIndexLocation(), row);
    }

    public boolean index(FeatureRow row, List<FeatureIndexType> types) {
        boolean indexed = false;
        for (FeatureIndexType type : types) {
            if (!this.index(type, row)) continue;
            indexed = true;
        }
        return indexed;
    }

    public boolean index(FeatureIndexType type, FeatureRow row) {
        boolean indexed = false;
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to index");
        }
        switch (type) {
            case GEOPACKAGE: {
                indexed = this.featureTableIndex.index(row);
                break;
            }
            case RTREE: {
                indexed = true;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + (Object)((Object)type));
            }
        }
        return indexed;
    }

    public boolean deleteIndex() {
        return this.deleteIndex(this.verifyIndexLocation());
    }

    public boolean deleteAllIndexes() {
        return this.deleteIndex(this.indexLocationQueryOrder);
    }

    public boolean deleteIndex(Collection<FeatureIndexType> types) {
        boolean deleted = false;
        for (FeatureIndexType type : types) {
            if (!this.deleteIndex(type)) continue;
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureIndexType type) {
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to delete index");
        }
        boolean deleted = false;
        switch (type) {
            case GEOPACKAGE: {
                deleted = this.featureTableIndex.deleteIndex();
                break;
            }
            case RTREE: {
                this.rTreeIndexTableDao.delete();
                deleted = true;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + (Object)((Object)type));
            }
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureRow row) {
        return this.deleteIndex(this.verifyIndexLocation(), row);
    }

    public boolean deleteIndex(FeatureRow row, List<FeatureIndexType> types) {
        boolean deleted = false;
        for (FeatureIndexType type : types) {
            if (!this.deleteIndex(type, row)) continue;
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureIndexType type, FeatureRow row) {
        return this.deleteIndex(type, row.getId());
    }

    public boolean deleteIndex(long geomId) {
        return this.deleteIndex(this.verifyIndexLocation(), geomId);
    }

    public boolean deleteIndex(long geomId, List<FeatureIndexType> types) {
        boolean deleted = false;
        for (FeatureIndexType type : types) {
            if (!this.deleteIndex(type, geomId)) continue;
            deleted = true;
        }
        return deleted;
    }

    public boolean deleteIndex(FeatureIndexType type, long geomId) {
        if (type == null) {
            throw new GeoPackageException("FeatureIndexType is required to delete index");
        }
        boolean deleted = false;
        switch (type) {
            case GEOPACKAGE: {
                deleted = this.featureTableIndex.deleteIndex(geomId) > 0;
                break;
            }
            case RTREE: {
                deleted = true;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported FeatureIndexType: " + (Object)((Object)type));
            }
        }
        return deleted;
    }

    public boolean retainIndex(FeatureIndexType type) {
        ArrayList<FeatureIndexType> retain = new ArrayList<FeatureIndexType>();
        retain.add(type);
        return this.retainIndex(retain);
    }

    public boolean retainIndex(Collection<FeatureIndexType> types) {
        HashSet<FeatureIndexType> delete = new HashSet<FeatureIndexType>(this.indexLocationQueryOrder);
        delete.removeAll(types);
        return this.deleteIndex(delete);
    }

    public boolean isIndexed() {
        FeatureIndexType type;
        boolean indexed = false;
        Iterator<FeatureIndexType> iterator = this.indexLocationQueryOrder.iterator();
        while (iterator.hasNext() && !(indexed = this.isIndexed(type = iterator.next()))) {
        }
        return indexed;
    }

    public boolean isIndexed(FeatureIndexType type) {
        boolean indexed = false;
        if (type == null) {
            indexed = this.isIndexed();
        } else {
            switch (type) {
                case GEOPACKAGE: {
                    indexed = this.featureTableIndex.isIndexed();
                    break;
                }
                case RTREE: {
                    indexed = this.rTreeIndexTableDao.has();
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported FeatureIndexType: " + (Object)((Object)type));
                }
            }
        }
        return indexed;
    }

    public List<FeatureIndexType> getIndexedTypes() {
        ArrayList<FeatureIndexType> indexed = new ArrayList<FeatureIndexType>();
        for (FeatureIndexType type : this.indexLocationQueryOrder) {
            if (!this.isIndexed(type)) continue;
            indexed.add(type);
        }
        return indexed;
    }

    public Date getLastIndexed() {
        FeatureIndexType type;
        Date lastIndexed = null;
        Iterator<FeatureIndexType> iterator = this.indexLocationQueryOrder.iterator();
        while (iterator.hasNext() && (lastIndexed = this.getLastIndexed(type = iterator.next())) == null) {
        }
        return lastIndexed;
    }

    public Date getLastIndexed(FeatureIndexType type) {
        Date lastIndexed = null;
        if (type == null) {
            lastIndexed = this.getLastIndexed();
        } else {
            switch (type) {
                case GEOPACKAGE: {
                    lastIndexed = this.featureTableIndex.getLastIndexed();
                    break;
                }
                case RTREE: {
                    if (!this.rTreeIndexTableDao.has()) break;
                    lastIndexed = new Date();
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported FeatureIndexType: " + (Object)((Object)type));
                }
            }
        }
        return lastIndexed;
    }

    public FeatureIndexResults query() {
        return this.query(this.featureDao.getColumnNames());
    }

    public FeatureIndexResults query(String[] columns) {
        FeatureIndexFeatureResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeatures(columns);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeatures(columns);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            FeatureResultSet featureResultSet = this.manualFeatureQuery.query(columns);
            results = new FeatureIndexFeatureResults(featureResultSet);
        }
        return results;
    }

    public long count() {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.count();
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.count();
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.countWithGeometries();
        }
        return count;
    }

    public FeatureIndexResults query(Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(columns, where, whereArgs);
    }

    public long count(Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.count(where, whereArgs);
    }

    public FeatureIndexResults query(String where) {
        return this.query(where, null);
    }

    public FeatureIndexResults query(String[] columns, String where) {
        return this.query(columns, where, null);
    }

    public long count(String where) {
        return this.count(where, null);
    }

    public FeatureIndexResults query(String where, String[] whereArgs) {
        return this.query(this.featureDao.getColumnNames(), where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, String where, String[] whereArgs) {
        FeatureIndexFeatureResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeatures(columns, where, whereArgs);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeatures(columns, where, whereArgs);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            FeatureResultSet featureResultSet = this.manualFeatureQuery.query(columns, where, whereArgs);
            results = new FeatureIndexFeatureResults(featureResultSet);
        }
        return results;
    }

    public long count(String where, String[] whereArgs) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.countFeatures(where, whereArgs);
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.countFeatures(where, whereArgs);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.count(where, whereArgs);
        }
        return count;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox bounds = null;
        boolean success = false;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        bounds = this.featureTableIndex.getBoundingBox();
                        break;
                    }
                    case RTREE: {
                        bounds = this.rTreeIndexTableDao.getBoundingBox();
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                success = true;
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to get bounding box from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (!success) {
            bounds = this.manualFeatureQuery.getBoundingBox();
        }
        return bounds;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox bounds = null;
        boolean success = false;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        bounds = this.featureTableIndex.getBoundingBox(projection);
                        break;
                    }
                    case RTREE: {
                        bounds = this.rTreeIndexTableDao.getBoundingBox(projection);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                success = true;
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to get bounding box from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (!success) {
            bounds = this.manualFeatureQuery.getBoundingBox(projection);
        }
        return bounds;
    }

    public FeatureIndexResults query(BoundingBox boundingBox) {
        return this.query(boundingBox.buildEnvelope());
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox) {
        return this.query(columns, boundingBox.buildEnvelope());
    }

    public long count(BoundingBox boundingBox) {
        return this.count(boundingBox.buildEnvelope());
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public long count(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.count(boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, String where) {
        return this.query(boundingBox, where, null);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, String where) {
        return this.query(columns, boundingBox, where, null);
    }

    public long count(BoundingBox boundingBox, String where) {
        return this.count(boundingBox, where, null);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public long count(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.count(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureIndexResults query(GeometryEnvelope envelope) {
        return this.query(envelope, null, null);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope) {
        return this.query(columns, envelope, null, null);
    }

    public long count(GeometryEnvelope envelope) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.count(envelope);
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.count(envelope);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.count(envelope);
        }
        return count;
    }

    public FeatureIndexResults query(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(envelope, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(columns, envelope, where, whereArgs);
    }

    public long count(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.count(envelope, where, whereArgs);
    }

    public FeatureIndexResults query(GeometryEnvelope envelope, String where) {
        return this.query(envelope, where, null);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope, String where) {
        return this.query(columns, envelope, where, null);
    }

    public long count(GeometryEnvelope envelope, String where) {
        return this.count(envelope, where, null);
    }

    public FeatureIndexResults query(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(this.featureDao.getColumnNames(), envelope, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        FeatureIndexResults results = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        FeatureResultSet geoPackageResultSet = this.featureTableIndex.queryFeatures(columns, envelope, where, whereArgs);
                        results = new FeatureIndexFeatureResults(geoPackageResultSet);
                        break;
                    }
                    case RTREE: {
                        FeatureResultSet rTreeResultSet = this.rTreeIndexTableDao.queryFeatures(columns, envelope, where, whereArgs);
                        results = new FeatureIndexFeatureResults(rTreeResultSet);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to query from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (results == null) {
            results = this.manualFeatureQuery.query(columns, envelope, where, whereArgs);
        }
        return results;
    }

    public long count(GeometryEnvelope envelope, String where, String[] whereArgs) {
        Long count = null;
        for (FeatureIndexType type : this.getLocation()) {
            try {
                switch (type) {
                    case GEOPACKAGE: {
                        count = this.featureTableIndex.countFeatures(envelope, where, whereArgs);
                        break;
                    }
                    case RTREE: {
                        count = this.rTreeIndexTableDao.countFeatures(envelope, where, whereArgs);
                        break;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported feature index type: " + (Object)((Object)type));
                    }
                }
                break;
            }
            catch (Exception e) {
                if (this.continueOnError) {
                    LOGGER.log(Level.SEVERE, "Failed to count from feature index: " + (Object)((Object)type), e);
                    continue;
                }
                throw e;
            }
        }
        if (count == null) {
            count = this.manualFeatureQuery.count(envelope, where, whereArgs);
        }
        return count;
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox);
    }

    public long count(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox, fieldValues);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox, fieldValues);
    }

    public long count(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox, fieldValues);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection, String where) {
        return this.query(boundingBox, projection, where, null);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(columns, boundingBox, projection, where, null);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where) {
        return this.count(boundingBox, projection, where, null);
    }

    public FeatureIndexResults query(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox, where, whereArgs);
    }

    public FeatureIndexResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox, where, whereArgs);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox, where, whereArgs);
    }

    public FeatureIndexLocation getLocation() {
        return new FeatureIndexLocation(this);
    }

    public FeatureIndexType getIndexedType() {
        FeatureIndexType indexType = FeatureIndexType.NONE;
        for (FeatureIndexType type : this.indexLocationQueryOrder) {
            if (!this.isIndexed(type)) continue;
            indexType = type;
            break;
        }
        return indexType;
    }

    private FeatureIndexType verifyIndexLocation() {
        if (this.indexLocation == null) {
            throw new GeoPackageException("Index Location is not set, set the location or call an index method specifying the location");
        }
        return this.indexLocation;
    }
}

