/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.style;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.extension.style.StyleRow;
import mil.nga.sf.GeometryType;
import mil.nga.sf.util.GeometryUtils;

public class Styles {
    private StyleRow defaultStyle;
    private Map<GeometryType, StyleRow> styles = new HashMap<GeometryType, StyleRow>();
    private boolean tableStyles;

    public Styles() {
        this(false);
    }

    public Styles(boolean tableStyles) {
        this.tableStyles = tableStyles;
    }

    public void setDefault(StyleRow styleRow) {
        this.setStyle(styleRow, null);
    }

    public void setStyle(StyleRow styleRow, GeometryType geometryType) {
        if (styleRow != null) {
            styleRow.setTableStyle(this.tableStyles);
        }
        if (geometryType != null) {
            if (styleRow != null) {
                this.styles.put(geometryType, styleRow);
            } else {
                this.styles.remove(geometryType);
            }
        } else {
            this.defaultStyle = styleRow;
        }
    }

    public StyleRow getDefault() {
        return this.defaultStyle;
    }

    public Map<GeometryType, StyleRow> getStyles() {
        return Collections.unmodifiableMap(this.styles);
    }

    public StyleRow getStyle() {
        return this.getStyle(null);
    }

    public StyleRow getStyle(GeometryType geometryType) {
        StyleRow styleRow = null;
        if (geometryType != null && !this.styles.isEmpty()) {
            GeometryType type;
            List geometryTypes = GeometryUtils.parentHierarchy((GeometryType)geometryType);
            geometryTypes.add(0, geometryType);
            Iterator iterator = geometryTypes.iterator();
            while (iterator.hasNext() && (styleRow = this.styles.get(type = (GeometryType)iterator.next())) == null) {
            }
        }
        if (styleRow == null) {
            styleRow = this.defaultStyle;
        }
        if (styleRow == null && geometryType == null && this.styles.size() == 1) {
            styleRow = this.styles.values().iterator().next();
        }
        return styleRow;
    }

    public boolean isEmpty() {
        return this.defaultStyle == null && this.styles.isEmpty();
    }

    public boolean hasDefault() {
        return this.defaultStyle != null;
    }

    public boolean isTableStyles() {
        return this.tableStyles;
    }

    public void setTableStyles(boolean tableStyles) {
        this.tableStyles = tableStyles;
    }
}

