/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageConnection;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.extension.related.UserMappingDao;
import mil.nga.geopackage.extension.related.UserMappingRow;
import mil.nga.geopackage.extension.related.media.MediaDao;
import mil.nga.geopackage.extension.related.media.MediaTable;
import mil.nga.geopackage.extension.related.simple.SimpleAttributesDao;
import mil.nga.geopackage.extension.related.simple.SimpleAttributesTable;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomDao;
import mil.nga.geopackage.user.custom.UserCustomResultSet;

public class RelatedTablesExtension
extends RelatedTablesCoreExtension {
    private GeoPackageConnection connection;

    public RelatedTablesExtension(GeoPackage geoPackage) {
        super((GeoPackageCore)geoPackage);
        this.connection = geoPackage.getConnection();
    }

    public UserCustomDao getUserDao(String tableName) {
        return UserCustomDao.readTable(this.getGeoPackage().getName(), this.connection, tableName);
    }

    public UserMappingDao getMappingDao(ExtendedRelation extendedRelation) {
        return this.getMappingDao(extendedRelation.getMappingTableName());
    }

    public UserMappingDao getMappingDao(String tableName) {
        return new UserMappingDao(this.getUserDao(tableName));
    }

    public MediaDao getMediaDao(MediaTable mediaTable) {
        return this.getMediaDao(mediaTable.getTableName());
    }

    public MediaDao getMediaDao(ExtendedRelation extendedRelation) {
        return this.getMediaDao(extendedRelation.getRelatedTableName());
    }

    public MediaDao getMediaDao(String tableName) {
        MediaDao mediaDao = new MediaDao(this.getUserDao(tableName));
        this.setContents((UserTable)mediaDao.getTable());
        return mediaDao;
    }

    public SimpleAttributesDao getSimpleAttributesDao(SimpleAttributesTable simpleAttributesTable) {
        return this.getSimpleAttributesDao(simpleAttributesTable.getTableName());
    }

    public SimpleAttributesDao getSimpleAttributesDao(ExtendedRelation extendedRelation) {
        return this.getSimpleAttributesDao(extendedRelation.getRelatedTableName());
    }

    public SimpleAttributesDao getSimpleAttributesDao(String tableName) {
        SimpleAttributesDao simpleAttributesDao = new SimpleAttributesDao(this.getUserDao(tableName));
        this.setContents((UserTable)simpleAttributesDao.getTable());
        return simpleAttributesDao;
    }

    public List<Long> getMappingsForBase(ExtendedRelation extendedRelation, long baseId) {
        return this.getMappingsForBase(extendedRelation.getMappingTableName(), baseId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getMappingsForBase(String tableName, long baseId) {
        ArrayList<Long> relatedIds = new ArrayList<Long>();
        UserMappingDao userMappingDao = this.getMappingDao(tableName);
        try (UserCustomResultSet resultSet = userMappingDao.queryByBaseId(baseId);){
            while (resultSet.moveToNext()) {
                UserMappingRow row = userMappingDao.getRow(resultSet);
                relatedIds.add(row.getRelatedId());
            }
        }
        return relatedIds;
    }

    public List<Long> getMappingsForRelated(ExtendedRelation extendedRelation, long relatedId) {
        return this.getMappingsForRelated(extendedRelation.getMappingTableName(), relatedId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getMappingsForRelated(String tableName, long relatedId) {
        ArrayList<Long> baseIds = new ArrayList<Long>();
        UserMappingDao userMappingDao = this.getMappingDao(tableName);
        try (UserCustomResultSet resultSet = userMappingDao.queryByRelatedId(relatedId);){
            while (resultSet.moveToNext()) {
                UserMappingRow row = userMappingDao.getRow(resultSet);
                baseIds.add(row.getBaseId());
            }
        }
        return baseIds;
    }

    public boolean hasMapping(String tableName, long baseId, long relatedId) {
        UserMappingDao userMappingDao = this.getMappingDao(tableName);
        return userMappingDao.countByIds(baseId, relatedId) > 0;
    }
}

