/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.index;

import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureRowSync;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.Projection;

public class FeatureTableIndex
extends FeatureTableCoreIndex {
    private static final Logger log = Logger.getLogger(FeatureTableIndex.class.getName());
    private final FeatureDao featureDao;
    private final FeatureRowSync featureRowSync = new FeatureRowSync();

    public FeatureTableIndex(GeoPackage geoPackage, FeatureDao featureDao) {
        super((GeoPackageCore)geoPackage, featureDao.getTableName(), featureDao.getGeometryColumnName());
        this.featureDao = featureDao;
    }

    public Projection getProjection() {
        return this.featureDao.getProjection();
    }

    public void close() {
    }

    public boolean index(FeatureRow row) {
        TableIndex tableIndex = this.getTableIndex();
        if (tableIndex == null) {
            throw new GeoPackageException("GeoPackage table is not indexed. GeoPackage: " + this.getGeoPackage().getName() + ", Table: " + this.getTableName());
        }
        boolean indexed = this.index(tableIndex, row.getId(), row.getGeometry());
        this.updateLastIndexed();
        return indexed;
    }

    protected int indexTable(final TableIndex tableIndex) {
        int count = 0;
        long offset = 0L;
        int chunkCount = 0;
        final String[] columns = this.featureDao.getIdAndGeometryColumnNames();
        while (chunkCount >= 0) {
            final long chunkOffset = offset;
            try {
                ConnectionSource connectionSource = this.getGeoPackage().getDatabase().getConnectionSource();
                chunkCount = (Integer)TransactionManager.callInTransaction((ConnectionSource)connectionSource, (Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        FeatureResultSet resultSet = (FeatureResultSet)FeatureTableIndex.this.featureDao.queryForChunk(columns, FeatureTableIndex.this.chunkLimit, chunkOffset);
                        int count = FeatureTableIndex.this.indexRows(tableIndex, resultSet);
                        return count;
                    }
                });
                if (chunkCount > 0) {
                    count += chunkCount;
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to Index Table. GeoPackage: " + this.getGeoPackage().getName() + ", Table: " + this.getTableName(), (Throwable)e);
            }
            offset += (long)this.chunkLimit;
        }
        if (this.progress == null || this.progress.isActive()) {
            this.updateLastIndexed();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int indexRows(TableIndex tableIndex, FeatureResultSet resultSet) {
        int count = -1;
        try {
            while ((this.progress == null || this.progress.isActive()) && resultSet.moveToNext()) {
                if (count < 0) {
                    ++count;
                }
                try {
                    FeatureRow row = (FeatureRow)resultSet.getRow();
                    boolean indexed = this.index(tableIndex, row.getId(), row.getGeometry());
                    if (indexed) {
                        ++count;
                    }
                    if (this.progress == null) continue;
                    this.progress.addProgress(1);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to index feature. Table: " + tableIndex.getTableName() + ", Position: " + resultSet.getPosition(), e);
                }
            }
            return count;
        }
        finally {
            resultSet.close();
        }
    }

    public int deleteIndex(FeatureRow row) {
        return this.deleteIndex(row.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureRow getFeatureRow(GeometryIndex geometryIndex) {
        long geomId = geometryIndex.getGeomId();
        FeatureRow row = (FeatureRow)this.featureRowSync.getRowOrLock(geomId);
        if (row == null) {
            try {
                row = (FeatureRow)this.featureDao.queryForIdRow(geomId);
            }
            finally {
                this.featureRowSync.setRow(geomId, row);
            }
        }
        return row;
    }

    public FeatureResultSet queryFeatures() {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(String[] columns) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(Map<String, Object> fieldValues) {
        return this.featureDao.countIn(this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String where) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), where);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), where);
    }

    public int countFeatures(String where) {
        return this.featureDao.countIn(this.queryIdsSQL(), where);
    }

    public FeatureResultSet queryFeatures(String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(String where, String[] whereArgs) {
        return this.featureDao.countIn(this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox) {
        return this.queryFeatures(boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox) {
        return this.queryFeatures(columns, boundingBox.buildEnvelope());
    }

    public int countFeatures(BoundingBox boundingBox) {
        return this.countFeatures(boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where) {
        return this.queryFeatures(boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where) {
        return this.queryFeatures(columns, boundingBox, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, String where) {
        return this.countFeatures(boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.queryFeatures(featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.queryFeatures(columns, featureBoundingBox);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.countFeatures(featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.queryFeatures(featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.queryFeatures(columns, featureBoundingBox, fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.countFeatures(featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(columns, boundingBox, projection, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.queryFeatures(featureBoundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.queryFeatures(columns, featureBoundingBox, where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        return this.countFeatures(featureBoundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(envelope));
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(envelope));
    }

    public int countFeatures(GeometryEnvelope envelope) {
        return this.featureDao.countIn(this.queryIdsSQL(envelope));
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(envelope), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(envelope), fieldValues);
    }

    public int countFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.featureDao.countIn(this.queryIdsSQL(envelope), fieldValues);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where) {
        return this.queryFeatures(envelope, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(columns, envelope, where, null);
    }

    public int countFeatures(GeometryEnvelope envelope, String where) {
        return this.countFeatures(envelope, where, null);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(envelope), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(envelope), where, whereArgs);
    }

    public int countFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.featureDao.countIn(this.queryIdsSQL(envelope), where, whereArgs);
    }
}

