/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.util.List;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.RTreeIndexExtension;
import mil.nga.geopackage.extension.RTreeIndexTableRow;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.geopackage.user.custom.UserCustomDao;
import mil.nga.geopackage.user.custom.UserCustomResultSet;
import mil.nga.geopackage.user.custom.UserCustomRow;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;

public class RTreeIndexTableDao
extends UserCustomDao {
    private final RTreeIndexExtension rTree;
    private final FeatureDao featureDao;
    protected GeoPackageProgress progress;
    protected double tolerance = 1.0E-14;

    RTreeIndexTableDao(RTreeIndexExtension rTree, UserCustomDao dao, FeatureDao featureDao) {
        super(dao, (UserCustomTable)dao.getTable());
        this.rTree = rTree;
        this.featureDao = featureDao;
        this.projection = featureDao.getProjection();
    }

    public void setProgress(GeoPackageProgress progress) {
        this.progress = progress;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public boolean has() {
        return this.rTree.has((FeatureTable)this.featureDao.getTable());
    }

    public Extensions create() {
        Extensions extension = null;
        if (!this.has()) {
            extension = this.rTree.create((FeatureTable)this.featureDao.getTable());
            if (this.progress != null) {
                this.progress.addProgress(this.count());
            }
        }
        return extension;
    }

    public void delete() {
        this.rTree.delete((FeatureTable)this.featureDao.getTable());
    }

    public RTreeIndexExtension getRTreeIndexExtension() {
        return this.rTree;
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public RTreeIndexTableRow getRow(UserCustomResultSet resultSet) {
        return this.getRow((UserCustomRow)resultSet.getRow());
    }

    public RTreeIndexTableRow getRow(UserCustomRow row) {
        return new RTreeIndexTableRow(row);
    }

    public FeatureRow getFeatureRow(RTreeIndexTableRow row) {
        return (FeatureRow)this.featureDao.queryForIdRow(row.getId());
    }

    public FeatureRow getFeatureRow(UserCustomResultSet resultSet) {
        RTreeIndexTableRow row = this.getRow(resultSet);
        return this.getFeatureRow(row);
    }

    public FeatureRow getFeatureRow(UserCustomRow row) {
        return this.getFeatureRow(this.getRow(row));
    }

    public UserCustomResultSet query() {
        this.validateRTree();
        return (UserCustomResultSet)super.query();
    }

    public UserCustomResultSet query(String[] columns) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(columns);
    }

    public UserCustomResultSet query(String where, String[] whereArgs) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(where, whereArgs);
    }

    public UserCustomResultSet query(String[] columns, String where, String[] whereArgs) {
        this.validateRTree();
        return (UserCustomResultSet)super.query(columns, where, whereArgs);
    }

    public int count(String where, String[] args) {
        this.validateRTree();
        return super.count(where, args);
    }

    public FeatureResultSet queryFeatures() {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(String[] columns) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL());
    }

    public FeatureResultSet queryFeatures(Map<String, Object> fieldValues) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, Map<String, Object> fieldValues) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), fieldValues);
    }

    public int countFeatures(Map<String, Object> fieldValues) {
        this.validateRTree();
        return this.featureDao.countIn(this.queryIdsSQL(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String where) {
        return this.queryFeatures(where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where) {
        return this.queryFeatures(columns, where, null);
    }

    public int countFeatures(String where) {
        return this.countFeatures(where, null);
    }

    public FeatureResultSet queryFeatures(String where, String[] whereArgs) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, String where, String[] whereArgs) {
        this.validateRTree();
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(), where, whereArgs);
    }

    public int countFeatures(String where, String[] whereArgs) {
        this.validateRTree();
        return this.featureDao.countIn(this.queryIdsSQL(), where, whereArgs);
    }

    @Override
    public BoundingBox getBoundingBox() {
        List values = this.querySingleRowTypedResults("SELECT MIN(minx), MIN(miny), MAX(maxx), MAX(maxy) FROM " + CoreSQLUtils.quoteWrap((String)this.getTableName()), null);
        BoundingBox boundingBox = new BoundingBox(((Double)values.get(0)).doubleValue(), ((Double)values.get(1)).doubleValue(), ((Double)values.get(2)).doubleValue(), ((Double)values.get(3)).doubleValue());
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null && projection != null) {
            ProjectionTransform projectionTransform = this.featureDao.getProjection().getTransformation(projection);
            boundingBox = boundingBox.transform(projectionTransform);
        }
        return boundingBox;
    }

    public UserCustomResultSet query(BoundingBox boundingBox) {
        return this.query(boundingBox.buildEnvelope());
    }

    public UserCustomResultSet query(String[] columns, BoundingBox boundingBox) {
        return this.query(columns, boundingBox.buildEnvelope());
    }

    public int count(BoundingBox boundingBox) {
        return this.count(boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox) {
        return this.queryFeatures(boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox) {
        return this.queryFeatures(columns, boundingBox.buildEnvelope());
    }

    public int countFeatures(BoundingBox boundingBox) {
        return this.countFeatures(boundingBox.buildEnvelope());
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.queryFeatures(columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.countFeatures(boundingBox.buildEnvelope(), fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where) {
        return this.queryFeatures(boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where) {
        return this.queryFeatures(columns, boundingBox, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, String where) {
        return this.countFeatures(boundingBox, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.queryFeatures(columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.countFeatures(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public UserCustomResultSet query(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.query(featureBoundingBox);
    }

    public UserCustomResultSet query(String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.query(columns, featureBoundingBox);
    }

    public int count(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(columns, featureBoundingBox);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(featureBoundingBox);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(columns, featureBoundingBox, fieldValues);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(featureBoundingBox, fieldValues);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.queryFeatures(columns, boundingBox, projection, where, null);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where) {
        return this.countFeatures(boundingBox, projection, where, null);
    }

    public FeatureResultSet queryFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(featureBoundingBox, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.queryFeatures(columns, featureBoundingBox, where, whereArgs);
    }

    public int countFeatures(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.projectBoundingBox(boundingBox, projection);
        return this.countFeatures(featureBoundingBox, where, whereArgs);
    }

    public UserCustomResultSet query(GeometryEnvelope envelope) {
        return this.query(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public UserCustomResultSet query(String[] columns, GeometryEnvelope envelope) {
        return this.query(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public int count(GeometryEnvelope envelope) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope) {
        return this.queryFeatures(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope) {
        return this.queryFeatures(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public int countFeatures(GeometryEnvelope envelope) {
        return this.countFeatures(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.queryFeatures(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.queryFeatures(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public int countFeatures(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.countFeatures(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where) {
        return this.queryFeatures(envelope, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where) {
        return this.queryFeatures(columns, envelope, where, null);
    }

    public int countFeatures(GeometryEnvelope envelope, String where) {
        return this.countFeatures(envelope, where, null);
    }

    public FeatureResultSet queryFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.queryFeatures(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.queryFeatures(columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public int countFeatures(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.countFeatures(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public UserCustomResultSet query(double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.query(where, whereArgs);
    }

    public UserCustomResultSet query(String[] columns, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.query(columns, where, whereArgs);
    }

    public int count(double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.count(where, whereArgs);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(where), whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(where), whereArgs);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.featureDao.countIn(this.queryIdsSQL(where), whereArgs);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(where), whereArgs, fieldValues);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(where), whereArgs, fieldValues);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        this.validateRTree();
        String where = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.featureDao.countIn(this.queryIdsSQL(where), whereArgs, fieldValues);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY, String where) {
        return this.queryFeatures(minX, minY, maxX, maxY, where, null);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY, String where) {
        return this.queryFeatures(columns, minX, minY, maxX, maxY, where, null);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY, String where) {
        return this.countFeatures(minX, minY, maxX, maxY, where, null);
    }

    public FeatureResultSet queryFeatures(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs);
    }

    public FeatureResultSet queryFeatures(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return (FeatureResultSet)this.featureDao.queryIn(columns, this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs);
    }

    public int countFeatures(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        this.validateRTree();
        String whereBounds = this.buildWhere(minX, minY, maxX, maxY);
        String[] whereBoundsArgs = this.buildWhereArgs(minX, minY, maxX, maxY);
        return this.featureDao.countIn(this.queryIdsSQL(whereBounds), whereBoundsArgs, where, whereArgs);
    }

    private void validateRTree() {
        if (!this.has()) {
            throw new GeoPackageException("RTree Extension not found for feature table: " + this.featureDao.getTableName());
        }
    }

    private String buildWhere(double minX, double minY, double maxX, double maxY) {
        StringBuilder where = new StringBuilder();
        where.append(this.buildWhere("minx", maxX, "<="));
        where.append(" AND ");
        where.append(this.buildWhere("miny", maxY, "<="));
        where.append(" AND ");
        where.append(this.buildWhere("maxx", minX, ">="));
        where.append(" AND ");
        where.append(this.buildWhere("maxy", minY, ">="));
        return where.toString();
    }

    private String[] buildWhereArgs(double minX, double minY, double maxX, double maxY) {
        return this.buildWhereArgs(new Object[]{maxX += this.tolerance, maxY += this.tolerance, minX -= this.tolerance, minY -= this.tolerance});
    }
}

