/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.Result;
import mil.nga.geopackage.db.ResultSetResult;
import mil.nga.geopackage.db.ResultUtils;
import mil.nga.geopackage.user.ContentValues;

public class SQLUtils {
    private static final Logger log = Logger.getLogger(SQLUtils.class.getName());

    public static void execSQL(Connection connection, String sql) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to execute SQL statement: " + sql, (Throwable)e);
        }
        finally {
            SQLUtils.closeStatement(statement, sql);
        }
    }

    public static ResultSet query(Connection connection, String sql, String[] selectionArgs) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(sql);
            SQLUtils.setArguments(statement, selectionArgs);
            resultSet = statement.executeQuery();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to execute SQL statement: " + sql, (Throwable)e);
        }
        finally {
            if (resultSet == null) {
                SQLUtils.closeStatement(statement, sql);
            }
        }
        return resultSet;
    }

    public static int count(Connection connection, String sql, String[] selectionArgs) {
        if (!sql.toLowerCase().contains(" count(*) ")) {
            int index = sql.toLowerCase().indexOf(" from ");
            if (index == -1) {
                return -1;
            }
            sql = "select count(*)" + sql.substring(index);
        }
        int count = SQLUtils.querySingleInteger(connection, sql, selectionArgs, true);
        return count;
    }

    public static int count(Connection connection, String table, String where, String[] args) {
        StringBuilder countQuery = new StringBuilder();
        countQuery.append("select count(*) from ").append(CoreSQLUtils.quoteWrap((String)table));
        if (where != null) {
            countQuery.append(" where ").append(where);
        }
        String sql = countQuery.toString();
        int count = SQLUtils.querySingleInteger(connection, sql, args, true);
        return count;
    }

    public static Integer min(Connection connection, String table, String column, String where, String[] args) {
        Integer min = null;
        if (SQLUtils.count(connection, table, where, args) > 0) {
            StringBuilder minQuery = new StringBuilder();
            minQuery.append("select min(").append(CoreSQLUtils.quoteWrap((String)column)).append(") from ").append(CoreSQLUtils.quoteWrap((String)table));
            if (where != null) {
                minQuery.append(" where ").append(where);
            }
            String sql = minQuery.toString();
            min = SQLUtils.querySingleInteger(connection, sql, args, false);
        }
        return min;
    }

    public static Integer max(Connection connection, String table, String column, String where, String[] args) {
        Integer max = null;
        if (SQLUtils.count(connection, table, where, args) > 0) {
            StringBuilder maxQuery = new StringBuilder();
            maxQuery.append("select max(").append(CoreSQLUtils.quoteWrap((String)column)).append(") from ").append(CoreSQLUtils.quoteWrap((String)table));
            if (where != null) {
                maxQuery.append(" where ").append(where);
            }
            String sql = maxQuery.toString();
            max = SQLUtils.querySingleInteger(connection, sql, args, false);
        }
        return max;
    }

    private static int querySingleInteger(Connection connection, String sql, String[] args, boolean allowEmptyResults) {
        int result = 0;
        Object value = SQLUtils.querySingleResult(connection, sql, args, 0, GeoPackageDataType.MEDIUMINT);
        if (value != null) {
            result = ((Number)value).intValue();
        } else if (!allowEmptyResults) {
            throw new GeoPackageException("Failed to query for single result. SQL: " + sql);
        }
        return result;
    }

    public static Object querySingleResult(Connection connection, String sql, String[] args, int column, GeoPackageDataType dataType) {
        ResultSetResult result = SQLUtils.wrapQuery(connection, sql, args);
        Object value = ResultUtils.buildSingleResult((Result)result, (int)column, (GeoPackageDataType)dataType);
        return value;
    }

    public static List<Object> querySingleColumnResults(Connection connection, String sql, String[] args, int column, GeoPackageDataType dataType, Integer limit) {
        ResultSetResult result = SQLUtils.wrapQuery(connection, sql, args);
        List results = ResultUtils.buildSingleColumnResults((Result)result, (int)column, (GeoPackageDataType)dataType, (Integer)limit);
        return results;
    }

    public static List<List<Object>> queryResults(Connection connection, String sql, String[] args, GeoPackageDataType[] dataTypes, Integer limit) {
        ResultSetResult result = SQLUtils.wrapQuery(connection, sql, args);
        List results = ResultUtils.buildResults((Result)result, (GeoPackageDataType[])dataTypes, (Integer)limit);
        return results;
    }

    public static int delete(Connection connection, String table, String where, String[] args) {
        StringBuilder delete = new StringBuilder();
        delete.append("delete from ").append(CoreSQLUtils.quoteWrap((String)table));
        if (where != null) {
            delete.append(" where ").append(where);
        }
        String sql = delete.toString();
        PreparedStatement statement = null;
        int count = 0;
        try {
            statement = connection.prepareStatement(sql);
            SQLUtils.setArguments(statement, args);
            count = statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to execute SQL delete statement: " + sql, (Throwable)e);
        }
        finally {
            SQLUtils.closeStatement(statement, sql);
        }
        return count;
    }

    public static int update(Connection connection, String table, ContentValues values, String whereClause, String[] whereArgs) {
        StringBuilder update = new StringBuilder();
        update.append("update ").append(CoreSQLUtils.quoteWrap((String)table)).append(" set ");
        int setValuesSize = values.size();
        int argsSize = whereArgs == null ? setValuesSize : setValuesSize + whereArgs.length;
        Object[] args = new Object[argsSize];
        int i = 0;
        for (String colName : values.keySet()) {
            update.append(i > 0 ? "," : "");
            update.append(CoreSQLUtils.quoteWrap((String)colName));
            args[i++] = values.get(colName);
            update.append("=?");
        }
        if (whereArgs != null) {
            for (i = setValuesSize; i < argsSize; ++i) {
                args[i] = whereArgs[i - setValuesSize];
            }
        }
        if (whereClause != null) {
            update.append(" WHERE ");
            update.append(whereClause);
        }
        String sql = update.toString();
        PreparedStatement statement = null;
        int count = 0;
        try {
            statement = connection.prepareStatement(sql);
            SQLUtils.setArguments(statement, args);
            count = statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to execute SQL update statement: " + sql, (Throwable)e);
        }
        finally {
            SQLUtils.closeStatement(statement, sql);
        }
        return count;
    }

    public static long insert(Connection connection, String table, ContentValues values) {
        try {
            return SQLUtils.insertOrThrow(connection, table, values);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error inserting into table: " + table + ", Values: " + values, e);
            return -1L;
        }
    }

    public static long insertOrThrow(Connection connection, String table, ContentValues values) {
        long id;
        block21: {
            StringBuilder insert = new StringBuilder();
            insert.append("insert into ").append(CoreSQLUtils.quoteWrap((String)table)).append("(");
            Object[] args = null;
            int size = values != null && values.size() > 0 ? values.size() : 0;
            args = new Object[size];
            int i = 0;
            for (String colName : values.keySet()) {
                insert.append(i > 0 ? "," : "");
                insert.append(CoreSQLUtils.quoteWrap((String)colName));
                args[i++] = values.get(colName);
            }
            insert.append(')');
            insert.append(" values (");
            for (i = 0; i < size; ++i) {
                insert.append(i > 0 ? ",?" : "?");
            }
            insert.append(')');
            String sql = insert.toString();
            PreparedStatement statement = null;
            id = 0L;
            try {
                statement = connection.prepareStatement(sql);
                SQLUtils.setArguments(statement, args);
                int count = statement.executeUpdate();
                if (count == 0) {
                    throw new GeoPackageException("Failed to execute SQL insert statement: " + sql + ". No rows added from execution.");
                }
                try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                    if (generatedKeys.next()) {
                        id = generatedKeys.getLong(1);
                        break block21;
                    }
                    throw new GeoPackageException("Failed to execute SQL insert statement: " + sql + ". No row id was found.");
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to execute SQL insert statement: " + sql, (Throwable)e);
            }
            finally {
                SQLUtils.closeStatement(statement, sql);
            }
        }
        return id;
    }

    public static void setArguments(PreparedStatement statement, Object[] selectionArgs) throws SQLException {
        if (selectionArgs != null) {
            for (int i = 0; i < selectionArgs.length; ++i) {
                statement.setObject(i + 1, selectionArgs[i]);
            }
        }
    }

    public static void closeStatement(Statement statement, String sql) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed to close SQL Statement: " + sql, e);
            }
        }
    }

    public static void closeResultSet(ResultSet resultSet, String sql) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed to close SQL ResultSet: " + sql, e);
            }
        }
    }

    public static void closeResultSetStatement(ResultSet resultSet, String sql) {
        if (resultSet != null) {
            try {
                resultSet.getStatement().close();
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Failed to close SQL ResultSet: " + sql, e);
            }
        }
    }

    public static ResultSetResult wrapQuery(Connection connection, String sql, String[] selectionArgs) {
        return new ResultSetResult(SQLUtils.query(connection, sql, selectionArgs));
    }

    public static boolean beginTransaction(Connection connection) {
        boolean autoCommit;
        try {
            autoCommit = connection.getAutoCommit();
            if (autoCommit) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to begin transaction", (Throwable)e);
        }
        return autoCommit;
    }

    public static void endTransaction(Connection connection, boolean successful) {
        SQLUtils.endTransaction(connection, successful, null);
    }

    public static void endTransaction(Connection connection, boolean successful, Boolean autoCommit) {
        try {
            if (successful) {
                connection.commit();
            } else {
                connection.rollback();
            }
            if (autoCommit != null && autoCommit.booleanValue()) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to end transaction", (Throwable)e);
        }
    }
}

